/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.local.appadapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.IRecorderApplicationAdapter;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderApplicationAdapterException;

public class InternetExplorerAdapter
implements IRecorderApplicationAdapter {
    private Process ieProcess;
    private String originalSettingsFileName = "IEConfig.reg";
    private String tempSettingsFileName = "tempIEConfig.reg";
    private String startupURL = "about:blank";
    private String launchPath = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
    private String portnum = null;

    public void init(String string) throws RecorderApplicationAdapterException {
        this.parseInitInfo(string);
        StringBuffer stringBuffer = this.getRegistryInfo();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = this.checkProxyEnabled(stringBuffer);
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"ProxyEnable")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                string3 = stringTokenizer2.nextToken();
                string3 = string3 + ":00000001";
                if (bl) {
                    string3 = string3 + "\r\n\"ProxyServer\"=\"http=localhost:" + this.portnum;
                    string3 = string3 + ";https=localhost:" + this.portnum + "\"";
                } else {
                    string3 = string3 + "\r\n\"ProxyServer\"=\"socks=localhost:";
                    string3 = string3 + this.portnum + "\"";
                }
            } else if (string2.startsWith("\"ProxyHttp1.1")) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ":");
                string3 = stringTokenizer3.nextToken();
                string3 = string3 + ":00000001";
            } else if (string2.startsWith("\"ProxyServer")) {
                string3 = null;
            } else if (string2.startsWith("\"ProxyOverride")) {
                string3 = "\"ProxyOverride\"=\"\"";
            } else if (string2.startsWith("[HKEY_CLASSES_ROOT\\Applications\\iexplore.exe\\shell\\open\\command]")) {
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("@=")) {
                    this.launchPath = string2.substring(2);
                    if (this.launchPath.charAt(0) == '\"' && this.launchPath.charAt(this.launchPath.length() - 1) == '\"') {
                        this.launchPath = this.launchPath.substring(1, this.launchPath.length() - 1);
                    }
                    this.launchPath = this.launchPath.replaceAll("%1", "");
                    int n = this.launchPath.indexOf("\\\\");
                    int n2 = this.launchPath.indexOf("\\\"");
                    while (n > -1 || n2 > -1) {
                        if (n > -1) {
                            this.launchPath = this.launchPath.substring(0, n) + this.launchPath.substring(n + 1, this.launchPath.length());
                        } else if (n2 > -1) {
                            this.launchPath = this.launchPath.substring(0, n2) + this.launchPath.substring(n2 + 1, this.launchPath.length());
                        }
                        n = this.launchPath.indexOf("\\\\");
                        n2 = this.launchPath.indexOf("\\\"");
                    }
                    System.out.println(this.launchPath);
                }
                string3 = null;
            }
            if (string3 == null) continue;
            stringBuffer2.append(string3 + "\r\n");
        }
        this.createRegSettingsFile(stringBuffer2);
        try {
            this.pushRegFile(this.tempSettingsFileName);
        }
        catch (Exception exception) {
            throw new RecorderApplicationAdapterException(exception.getMessage());
        }
    }

    private void pushRegFile(String string) throws InterruptedException, IOException {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        String string2 = "regedit /s " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2, null);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Interrupted");
        }
    }

    private void createRegSettingsFile(StringBuffer stringBuffer) {
        File file = new File(this.tempSettingsFileName);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UnicodeLittle");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer getRegistryInfo() {
        String[] stringArray = new String[]{"\"HKEY_CLASSES_ROOT\\Applications\\iexplore.exe\\shell\\open\\command\"", "\"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\""};
        String string = "regedit /e " + this.originalSettingsFileName + " ";
        InputStreamReader inputStreamReader = null;
        File file = null;
        StringBuffer stringBuffer = new StringBuffer();
        file = new File(this.originalSettingsFileName);
        if (file.exists()) {
            file.delete();
        }
        int n = 0;
        while (n < stringArray.length) {
            Process process = Runtime.getRuntime().exec(string + stringArray[n], null);
            process.waitFor();
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16");
            char[] cArray = new char[1000];
            int n2 = inputStreamReader.read(cArray);
            while (n2 != -1) {
                String string2 = new String(cArray);
                stringBuffer.append(cArray, 0, n2);
                n2 = inputStreamReader.read(cArray);
            }
            inputStreamReader.close();
            ++n;
        }
        Object var12_13 = null;
        if (inputStreamReader == null) return stringBuffer;
        try {
            inputStreamReader.close();
            return stringBuffer;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var12_14 = null;
                if (inputStreamReader == null) return stringBuffer;
                try {
                    inputStreamReader.close();
                    return stringBuffer;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return stringBuffer;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                Object var12_15 = null;
                if (inputStreamReader == null) return stringBuffer;
                try {
                    inputStreamReader.close();
                    return stringBuffer;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return stringBuffer;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public Process start() throws RecorderApplicationAdapterException {
        this.ieProcess = null;
        try {
            this.ieProcess = Runtime.getRuntime().exec(this.launchPath + " " + this.startupURL);
        }
        catch (IOException iOException) {
            throw new RecorderApplicationAdapterException("unable to start Internet Explorer Process: " + iOException.getMessage());
        }
        return this.ieProcess;
    }

    public void cleanup() throws RecorderApplicationAdapterException {
        File file;
        try {
            this.pushRegFile(this.originalSettingsFileName);
        }
        catch (Exception exception) {
            throw new RecorderApplicationAdapterException(exception.getMessage());
        }
        File file2 = new File(this.originalSettingsFileName);
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = new File(this.tempSettingsFileName)).exists()) {
            file.delete();
        }
    }

    public void stop() throws RecorderApplicationAdapterException {
        this.ieProcess.destroy();
    }

    private void parseInitInfo(String string) {
        this.portnum = "";
        this.startupURL = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            if (string3.equals("port")) {
                this.portnum = string4;
                try {
                    Integer.parseInt(this.portnum);
                }
                catch (NumberFormatException numberFormatException) {
                    this.portnum = "443";
                }
                continue;
            }
            if (!string3.equals("startupURL")) continue;
            this.startupURL = string4;
        }
    }

    private boolean checkProxyEnabled(StringBuffer stringBuffer) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            String string2 = string = stringTokenizer.nextToken();
            if (!string.startsWith("\"ProxyEnable")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":");
            string2 = stringTokenizer2.nextToken();
            string2 = stringTokenizer2.nextToken();
            if (!string2.equalsIgnoreCase("00000001")) break;
            bl = true;
            break;
        }
        return bl;
    }

    private String getProxyInfo(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "";
        String string2 = "http=";
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("\"ProxyServer")) continue;
            String string5 = "\"ProxyServer\"=";
            String string6 = string3.substring(string5.length());
            String[] stringArray = string6.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string7 = stringArray[n2].replaceAll("\"", "");
                int n3 = string7.indexOf(string2);
                if (n3 != -1) {
                    String string8 = "";
                    string = string8 = string7.substring(n3 + string2.length());
                }
                ++n2;
            }
        }
        return string;
    }
}

