/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngine;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormEngineLayout
extends Layout {
    public Point computeSize(Composite composite, int wHint, int hHint, boolean changed) {
        FormEngine engine = (FormEngine)composite;
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= engine.marginWidth * 2;
        }
        Point textSize = this.computeTextSize(engine, innerWidth);
        int textWidth = textSize.x + 2 * engine.marginWidth;
        int textHeight = textSize.y + 2 * engine.marginHeight;
        Point result = new Point(textWidth, textHeight);
        return result;
    }

    private Point computeTextSize(FormEngine engine, int wHint) {
        IParagraph[] paragraphs = engine.model.getParagraphs();
        GC gc = new GC((Drawable)engine);
        gc.setFont(engine.getFont());
        Locator loc = new Locator();
        int width = wHint != -1 ? wHint : 0;
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int i = 0;
        while (i < paragraphs.length) {
            IParagraph p = paragraphs[i];
            if (i > 0 && engine.paragraphsSeparated && p.getAddVerticalSpace()) {
                loc.y += engine.getParagraphSpacing(lineHeight);
            }
            loc.rowHeight = 0;
            loc.indent = p.getIndent();
            loc.x = p.getIndent();
            IParagraphSegment[] segments = p.getSegments();
            if (segments.length > 0) {
                int j = 0;
                while (j < segments.length) {
                    IParagraphSegment segment = segments[j];
                    segment.advanceLocator(gc, wHint, loc, engine.objectTable);
                    width = Math.max(width, loc.width);
                    ++j;
                }
                loc.y += loc.rowHeight;
            } else {
                loc.y += lineHeight;
            }
            ++i;
        }
        gc.dispose();
        return new Point(width, loc.y);
    }

    protected void layout(Composite composite, boolean flushCache) {
    }
}

