/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.shortcuts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestComponentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.Workbench;

public class LaunchShortcut
implements ILaunchShortcut {
    static Object getRunnableItemFromElement(Object element, String mode) {
        Object candidateElement = null;
        if (element instanceof TPFTestSuite || element instanceof TPFTestCase || element instanceof TPFTestComponent) {
            candidateElement = element;
        } else if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("testsuite".equals(file.getFileExtension())) {
                EObject[] eobjs = EMFUtil.load(null, file);
                int i = 0;
                while (i < eobjs.length) {
                    if (eobjs[i] instanceof TPFTestSuite) {
                        candidateElement = eobjs[i];
                        break;
                    }
                    ++i;
                }
            } else if ("testcomponent".equals(file.getFileExtension())) {
                EObject[] eobjs = EMFUtil.load(null, file);
                int i = 0;
                while (i < eobjs.length) {
                    if (eobjs[i] instanceof TPFTestComponent) {
                        candidateElement = eobjs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (candidateElement != null) {
            if (LaunchConfigurationExtensionsManager.getInstance().isShortcutAvailable(candidateElement, mode)) {
                return candidateElement;
            }
            return null;
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        IFileEditorInput finput;
        Object obj;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (obj = LaunchShortcut.getRunnableItemFromElement((finput = (IFileEditorInput)input).getFile(), mode)) != null) {
            this.launchElement(obj, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                Object launchable = LaunchShortcut.getRunnableItemFromElement(element, mode);
                if (launchable == null) continue;
                this.launchElement(launchable, mode);
            }
        }
    }

    private void launchElement(Object launchable, String mode) {
        ILaunchConfiguration lconfig = this.findLaunchConfiguration(launchable, mode);
        try {
            if (lconfig == null) {
                lconfig = this.createLaunchConfiguration(launchable);
            }
            if (lconfig != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                lconfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Throwable t) {
            this.reportFailure(t);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(Object launchable, String mode) {
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        ILaunchConfigurationType configsType = this.getConfigType(launchable);
        Assert.isNotNull((Object)configsType);
        ResourceSetImpl shortcutResourceSet = new ResourceSetImpl();
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configsType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                TPFTest configLaunchableElement = null;
                if (launchable instanceof TPFTest) {
                    configLaunchableElement = TestLaunchConfigurationFacade.getTest(configs[i], (ResourceSet)shortcutResourceSet);
                } else if (launchable instanceof TPFTestComponent) {
                    configLaunchableElement = TestComponentLaunchConfigurationFacade.getTestComponent(configs[i], (ResourceSet)shortcutResourceSet);
                }
                if (launchable.equals(configLaunchableElement)) {
                    candidateConfigs.add(configs[i]);
                }
                ++i;
            }
            if (candidateConfigs.size() == 0) {
                return null;
            }
            if (candidateConfigs.size() == 1) {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
            return this.chooseFromCandidateConfigs(candidateConfigs, mode);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return null;
        }
    }

    private ILaunchConfiguration chooseFromCandidateConfigs(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(TestUIPlugin.getString("LaunchShortcut.ambiguousLaunchConfigurationTitle"));
        if (mode.equals("debug")) {
            dialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectDebugLaunchConfigPrompt"));
        } else if (mode.equals("profile")) {
            dialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectProfileLaunchConfigPrompt"));
        } else {
            dialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectRunLaunchConfigPrompt"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createLaunchConfiguration(Object launchable) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationType configType = this.getConfigType(launchable);
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(TestUIPlugin.getString("LaunchShortcut.uniqueNamePrefix")));
        if (launchable instanceof TPFTest) {
            TestLaunchConfigurationFacade.setTest(wc, (TPFTest)launchable);
        } else if (launchable instanceof TPFTestComponent) {
            TestComponentLaunchConfigurationFacade.setTestComponent(wc, (TPFTestComponent)launchable);
        }
        IDeploymentsProvider dprovider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(launchable);
        TPFDeployment depl = null;
        depl = dprovider.getDefaultDeployment(launchable);
        if (depl == null) {
            this.throwException(TestUIPlugin.getString("_EXC_LaunchShortcut.noDefaultDeployment"), null);
        }
        DeploymentLaunchConfigurationFacade.setDeployment(wc, depl);
        String ehName = null;
        IContainer ehLocation = null;
        IExecutionHistoryDefaultsProvider eprovider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(launchable);
        ehName = eprovider.getDefaultName(launchable);
        if (ehName == null) {
            ehName = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(launchable);
        }
        if ((ehLocation = eprovider.getDefaultLocation(launchable)) == null) {
            ehLocation = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(launchable);
        }
        if (ehName == null || ehLocation == null) {
            this.throwException(TestUIPlugin.getString("_EXC_LaunchShortcut.noDefaultExecHistoryInfo"), null);
        }
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(wc, ehName);
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(wc, ehLocation);
        config = wc.doSave();
        return config;
    }

    private void reportFailure(Throwable exception) {
        CoreException ce;
        TestUIPlugin.logError(exception);
        MessageBox msgBox = new MessageBox(Workbench.getInstance().getActiveWorkbenchWindow().getShell(), 33);
        msgBox.setText(TestUIPlugin.getString("LaunchShortcut.errorDialogTitle"));
        String message = null;
        if (exception instanceof CoreException && (ce = (CoreException)exception).getStatus() != null && ce.getStatus().getMessage() != null) {
            message = ce.getStatus().getMessage();
        }
        if (message == null) {
            message = "An exception occured. See error log for more details";
        }
        msgBox.setMessage(message);
        msgBox.open();
    }

    private void throwException(String localizedMessage, Throwable exception) throws CoreException {
        Status status = new Status(4, TestUIPlugin.getID(), 0, localizedMessage, exception);
        throw new CoreException((IStatus)status);
    }

    private ILaunchConfigurationType getConfigType(Object launchable) {
        ILaunchConfigurationType configType = null;
        if (launchable instanceof TPFTest) {
            configType = TestLaunchConfigurationFacade.getLaunchConfigurationType();
        } else if (launchable instanceof TPFTestComponent) {
            configType = TestComponentLaunchConfigurationFacade.getLaunchConfigurationType();
        }
        return configType;
    }

    private Shell getActiveShell() {
        IWorkbenchWindow window = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

