/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.configurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.AbstractLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.util.DeploymentUtil;

public class DeploymentLaunchConfigurationFacade
extends AbstractLaunchConfigurationFacade {
    private static final String PROPERTY_DEPLOYMENT = "org.eclipse.hyades.test.ui.launch.deployment";

    public static TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
        return DeploymentLaunchConfigurationFacade.getDeployment(configuration, EMFUtil.getResourceSet());
    }

    public static TPFDeployment getDeployment(ILaunchConfiguration configuration, ResourceSet resourceSet) throws CoreException {
        EObject eObject = AbstractLaunchConfigurationFacade.resolveEMFReference(configuration, PROPERTY_DEPLOYMENT, resourceSet);
        if (eObject != null && eObject instanceof TPFDeployment) {
            TPFTest test = TestLaunchConfigurationFacade.getTest(configuration, resourceSet);
            TPFTestSuite testSuite = null;
            if (test instanceof TPFTestSuite) {
                testSuite = (TPFTestSuite)test;
            } else if (test instanceof TPFTestCase) {
                testSuite = ((TPFTestCase)test).getTestSuite();
            }
            if (testSuite != null) {
                DeploymentUtil.associateTestAsset((CFGClass)testSuite, (TPFDeployment)eObject);
            }
            return (TPFDeployment)eObject;
        }
        return null;
    }

    public static void setDeployment(ILaunchConfigurationWorkingCopy configuration, TPFDeployment deployment) {
        AbstractLaunchConfigurationFacade.storeEMFReference(configuration, PROPERTY_DEPLOYMENT, (EObject)deployment);
    }
}

