/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IEclipseExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IExecutorWithProgressMonitorSupport;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.util.MutableObject;
import org.eclipse.hyades.execution.harness.ExecutionHarnessDataProcessorFactory;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor2;
import org.eclipse.hyades.execution.harness.util.ExecutionAdapterUtilities;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.harness.util.StandaloneExecutionUtilities;
import org.eclipse.hyades.execution.harness.util.StandaloneSystemUtility;
import org.eclipse.hyades.execution.local.EclipseExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutableObjectStub;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.HyadesTestNodeImpl;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.SessionContext;
import org.eclipse.hyades.execution.local.SessionContextToSessionMap;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class TestExecutionHarness {
    private final Object agentLock = new Object();
    private boolean bAgentReady = false;
    private final HashMap testTypeMap = new HashMap();
    private boolean bFactoryInitialized = false;
    private IExecutionComponentFactory factory;
    private ISession session;
    private IExecutionEnvironment exeEnvironment;
    private IExecutor executor;
    private String[] standaloneConfigurationFiles;
    private ISystemUtility systemUtility;
    private ExecutionHarnessDataProcessorFactory dpFactory;

    public static void main(String[] args) {
        StringBuffer bufError;
        boolean overwriteExistingResult;
        String resultName;
        String resultsLocation;
        String hostName;
        String deploymentPath;
        String testSuitePath;
        String versionString;
        String eclipseHome;
        TestExecutionHarness harness;
        IExecutor executor;
        if (args.length != 8) {
            System.err.println("Usage: TestExecutionHarness <eclipseHomePath> <versionString> <testSuitePath> <deploymentPath> <hostname> <resultLocation> <resultName> <overwriteExistingResult>");
            System.exit(-1);
        }
        if ((executor = (harness = new TestExecutionHarness(eclipseHome = args[0], versionString = args[1])).launchTest(testSuitePath = args[2], deploymentPath = args[3], null, hostName = args[4], "10002", resultsLocation = args[5], resultName = args[6], overwriteExistingResult = Boolean.valueOf(args[7]).booleanValue(), true, true, bufError = new StringBuffer())) == null) {
            System.out.println(bufError.toString());
            throw new RuntimeException(bufError.toString());
        }
        TestExecutionHarness.waitForDataProcessorExit(executor);
    }

    private static IRemoteHyadesComponent findRemoteHyadesComponent(IExecutor executor) {
        IRemoteHyadesComponent comp = null;
        IExecutionComponent[] children = executor.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IRemoteHyadesComponent) {
                comp = (IRemoteHyadesComponent)children[i];
            }
            ++i;
        }
        return comp;
    }

    public TestExecutionHarness() {
        try {
            Class.forName("org.eclipse.core.boot.BootLoader");
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException("Standalone execution requires that a configuration file directory is passed to the TestExecutionHarness constructor!");
        }
    }

    public TestExecutionHarness(String configurationFileDir, String versionString) {
        try {
            Class.forName("org.eclipse.core.boot.BootLoader");
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException exc) {
            String[] plugins = StandaloneExecutionUtilities.getConfigFilesFromConfigDir(configurationFileDir);
            this.setStandaloneConfigurationFiles(plugins);
            String harnessDir = StandaloneExecutionUtilities.getHarnessDir(configurationFileDir, versionString);
            this.systemUtility = new StandaloneSystemUtility(harnessDir);
            RegistryReader.standaloneConfiguration = new RegistryReader.StandaloneConfiguration();
            RegistryReader.standaloneConfiguration.setEclipseFolder(configurationFileDir);
            this.init();
        }
    }

    private void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testsuite", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("deploy", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("execution", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("artifact", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("location", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("datapool", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("sut", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testcomponent", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new FacadeResourceFactoryImpl());
        Common_TestprofilePackageImpl.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAgentLock() {
        Object object = this.agentLock;
        synchronized (object) {
            this.bAgentReady = true;
            this.agentLock.notify();
        }
    }

    protected synchronized void initializeRegisteredExecutionComponents(IExecutionComponentFactory factory, boolean bStandalone, ExecutionHarnessDataProcessorFactory dpFactory) throws ClassNotFoundException, FileNotFoundException {
        if (!bStandalone) {
            IEclipseExecutionComponentFactory eclipseFactory = (IEclipseExecutionComponentFactory)factory;
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] execComps = reg.getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            int i = 0;
            while (i < execComps.length) {
                String type = execComps[i].getAttribute("type");
                String executionComponentName = execComps[i].getAttribute("name");
                eclipseFactory.addExecutionComponent(execComps[i]);
                Object map = this.testTypeMap.get(type);
                if (map == null) {
                    map = new HashMap();
                    this.testTypeMap.put(type, map);
                }
                HashMap execCompMap = (HashMap)map;
                IConfigurationElement[] supportedTestTypes = execComps[i].getChildren("SupportedTestType");
                int j = 0;
                while (j < supportedTestTypes.length) {
                    execCompMap.put(supportedTestTypes[j].getAttribute("name"), executionComponentName);
                    ++j;
                }
                ++i;
            }
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter", "EXECUTION_ENVIRONMENT_ADAPTER", bStandalone);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter", "EXECUTABLE_OBJECT_ADAPTER", bStandalone);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionDeploymentAdapter", "EXECUTION_DEPLOYMENT_ADAPTER", bStandalone);
        } else {
            StandaloneExecutionUtilities.initializeRegisteredExecutionComponents(this.standaloneConfigurationFiles, this.testTypeMap, factory, dpFactory);
        }
    }

    private void mapAdapterClasses(String configElements, String type, boolean bStandalone) {
        if (!bStandalone) {
            IConfigurationElement[] execEnvAdapters = Platform.getExtensionRegistry().getConfigurationElementsFor(configElements);
            int i = 0;
            while (i < execEnvAdapters.length) {
                Object map = this.testTypeMap.get(type);
                if (map == null) {
                    map = new HashMap();
                    this.testTypeMap.put(type, map);
                }
                HashMap execCompMap = (HashMap)map;
                IConfigurationElement[] supportedTestTypes = execEnvAdapters[i].getChildren("SupportedTestType");
                int j = 0;
                while (j < supportedTestTypes.length) {
                    execCompMap.put(supportedTestTypes[j].getAttribute("name"), execEnvAdapters[i]);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected synchronized String getExecutionComponentForTestType(String executionComponentType, String testType, boolean bStandalone) throws ClassNotFoundException {
        HashMap execCompMap;
        Object temp = this.testTypeMap.get(executionComponentType);
        if (temp != null && temp instanceof HashMap && (temp = (execCompMap = (HashMap)temp).get(testType)) != null && temp instanceof String) {
            return (String)temp;
        }
        String msg = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        msg = StringUtil.change((String)msg, (String)"%1", (String)executionComponentType);
        msg = StringUtil.change((String)msg, (String)"%2", (String)testType);
        throw new ClassNotFoundException(msg);
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(suite, theTest, machineName, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        IExecutor iExecutor;
        ArrayList<String> dpIDs = null;
        if (bMonitor) {
            dpIDs = new ArrayList<String>();
            dpIDs.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        try {
            IExecutor executor = null;
            if (!progressMonitor.isCanceled()) {
                IImplementor theImplementor = this.getImplementor(suite, theTest);
                if (!progressMonitor.isCanceled()) {
                    executor = this.launchTest(theImplementor, null, machineName, null, port, executionResultLocation, executionResultName, bStandalone, dpIDs, bufError, progressMonitor);
                }
            }
            iExecutor = executor;
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iExecutor;
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(suite, theTest, deployment, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        return this.launchTest(suite, theTest, deployment, port, executionResultLocation, executionResultName, false, bMonitor, bStandalone, bufError, progressMonitor);
    }

    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean overrideExisting, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(suite, theTest, deployment, port, executionResultLocation, executionResultName, overrideExisting, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean overrideExisting, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        IExecutor iExecutor;
        ArrayList<String> dpIDs = null;
        if (bMonitor) {
            dpIDs = new ArrayList<String>();
            dpIDs.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        try {
            IExecutor executor = null;
            if (!progressMonitor.isCanceled()) {
                IImplementor theImplementor = this.getImplementor(suite, theTest);
                if (!progressMonitor.isCanceled()) {
                    executor = this.launchTest(theImplementor, null, null, deployment, port, executionResultLocation, executionResultName, overrideExisting, bStandalone, dpIDs, bufError, progressMonitor);
                }
            }
            iExecutor = executor;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iExecutor;
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        return this.launchTest(suite, theTest, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, this.createNullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutor launchTest(ITestSuite suite, ITest theTest, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError, IProgressMonitor progressMonitor) {
        IExecutor iExecutor;
        try {
            IExecutor executor = null;
            if (!progressMonitor.isCanceled()) {
                IImplementor theImplementor = this.getImplementor(suite, theTest);
                if (!progressMonitor.isCanceled()) {
                    executor = this.launchTest(theImplementor, null, null, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, progressMonitor);
                }
            }
            iExecutor = executor;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iExecutor;
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, String overrideTestType, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        return this.launchTest(suite, theTest, overrideTestType, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, this.createNullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutor launchTest(ITestSuite suite, ITest theTest, String overrideTestType, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError, IProgressMonitor progressMonitor) {
        IExecutor iExecutor;
        try {
            IExecutor executor = null;
            if (!progressMonitor.isCanceled()) {
                IImplementor theImplementor = this.getImplementor(suite, theTest);
                if (!progressMonitor.isCanceled()) {
                    executor = this.launchTest(theImplementor, overrideTestType, null, deployment, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, progressMonitor);
                }
            }
            iExecutor = executor;
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iExecutor;
    }

    public IExecutor launchTest(ITestSuite suite, ITest theTest, String hostName, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError) {
        return this.launchTest(suite, theTest, hostName, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, this.createNullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutor launchTest(ITestSuite suite, ITest theTest, String hostName, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError, IProgressMonitor progressMonitor) {
        IExecutor iExecutor;
        try {
            IExecutor executor = null;
            if (!progressMonitor.isCanceled()) {
                IImplementor theImplementor = this.getImplementor(suite, theTest);
                if (!progressMonitor.isCanceled()) {
                    executor = this.launchTest(theImplementor, null, hostName, null, port, executionResultLocation, executionResultName, bStandalone, activeDataProcessorIDs, bufError, progressMonitor);
                }
            }
            iExecutor = executor;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iExecutor;
    }

    public IExecutor launchTest(String rootSuitePath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(rootSuitePath, testID, machineName, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    public IExecutor launchTest(String rootSuitePath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        Object theTest = null;
        ITestSuite suite = null;
        TPFDeployment deployment = null;
        bufError.setLength(0);
        try {
            suite = HyadesFactory.INSTANCE.loadTestSuite(rootSuitePath);
        }
        catch (Exception exc) {
            this.systemUtility.logError(exc);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)rootSuitePath));
            return null;
        }
        if (suite instanceof CFGClass) {
            deployment = ConfigurationUtil.createDeploymentWithPair((String)machineName, null, (CFGClass)((CFGClass)suite), (String)machineName);
        }
        theTest = testID != null && testID.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(suite, testID) : suite;
        return this.launchTest(suite, (ITest)theTest, deployment, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError, progressMonitor);
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(rootSuitePath, deploymentPath, testID, machineName, port, executionResultLocation, executionResultName, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        return this.launchTest(rootSuitePath, deploymentPath, testID, machineName, port, executionResultLocation, executionResultName, false, bMonitor, bStandalone, bufError, progressMonitor);
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean overwriteExistingResult, boolean bMonitor, boolean bStandalone, StringBuffer bufError) {
        return this.launchTest(rootSuitePath, deploymentPath, testID, machineName, port, executionResultLocation, executionResultName, overwriteExistingResult, bMonitor, bStandalone, bufError, this.createNullProgressMonitor());
    }

    public IExecutor launchTest(String rootSuitePath, String deploymentPath, String testID, String machineName, String port, String executionResultLocation, String executionResultName, boolean overwriteExistingResult, boolean bMonitor, boolean bStandalone, StringBuffer bufError, IProgressMonitor progressMonitor) {
        Object theTest = null;
        ITestSuite suite = null;
        TPFDeployment deployment = null;
        bufError.setLength(0);
        try {
            suite = HyadesFactory.INSTANCE.loadTestSuite(rootSuitePath);
        }
        catch (Exception exc) {
            this.systemUtility.logError(exc);
            bufError.append(StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)rootSuitePath));
            return null;
        }
        try {
            if (deploymentPath != null && deploymentPath.length() > 0) {
                deployment = HyadesFactory.INSTANCE.loadDeployment(deploymentPath);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (deployment == null && suite instanceof CFGClass) {
            deployment = ConfigurationUtil.createDeploymentWithPair((String)machineName, null, (CFGClass)((CFGClass)suite), (String)machineName);
        }
        theTest = testID != null && testID.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(suite, testID) : suite;
        return this.launchTest(suite, (ITest)theTest, deployment, port, executionResultLocation, executionResultName, overwriteExistingResult, bMonitor, bStandalone, bufError, progressMonitor);
    }

    private synchronized IExecutor launchTest(IImplementor theImplementor, String overrideTestType, String machineName, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError, IProgressMonitor progressMonitor) {
        return this.launchTest(theImplementor, overrideTestType, machineName, deployment, port, executionResultLocation, executionResultName, false, bStandalone, activeDataProcessorIDs, bufError, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized IExecutor launchTest(IImplementor theImplementor, String overrideTestType, String machineName, TPFDeployment deployment, String port, String executionResultLocation, String executionResultName, boolean overrideExistingResult, boolean bStandalone, ArrayList activeDataProcessorIDs, StringBuffer bufError, IProgressMonitor progressMonitor) {
        block41: {
            IExecutor iExecutor;
            block40: {
                block39: {
                    IExecutor iExecutor2;
                    block38: {
                        IExecutor iExecutor3;
                        block37: {
                            IExecutor iExecutor4;
                            block36: {
                                IExecutor iExecutor5;
                                block35: {
                                    IExecutor iExecutor6;
                                    block34: {
                                        IExecutor iExecutor62;
                                        block33: {
                                            IExecutor iExecutor52;
                                            block32: {
                                                IExecutor iExecutor42;
                                                block31: {
                                                    IExecutor iExecutor32;
                                                    block30: {
                                                        TPFTestComponent component;
                                                        progressMonitor.beginTask("", 100);
                                                        this.factory = null;
                                                        this.session = null;
                                                        this.exeEnvironment = null;
                                                        this.executor = null;
                                                        bufError.setLength(0);
                                                        Object rootResource = null;
                                                        ITest owningTest = theImplementor.getOwner();
                                                        rootResource = owningTest != null ? (owningTest instanceof ITestSuite ? (CFGClass)owningTest : (CFGClass)((ITestCase)owningTest).getOwner()) : ((component = ((TPFBehavior)theImplementor).getTestComponent()).eContainer() == null ? component : (CFGClass)component.eContainer());
                                                        try {
                                                            try {
                                                                String testType = overrideTestType != null && overrideTestType.length() > 0 ? overrideTestType : owningTest.getType();
                                                                String machine = machineName;
                                                                if (deployment == null) {
                                                                    deployment = ConfigurationUtil.createDeploymentWithPair(null, null, (CFGClass)rootResource, (String)machineName);
                                                                } else {
                                                                    machine = ConfigurationUtil.getHostNameForTestAsset((CFGClass)rootResource, (TPFDeployment)deployment);
                                                                    if (machine == null) {
                                                                        machine = machineName;
                                                                    }
                                                                }
                                                                if (machine == null) {
                                                                    bufError.append(this.systemUtility.getString("NULL_HOST_NAME_ERR"));
                                                                    iExecutor32 = null;
                                                                    Object var27_27 = null;
                                                                    break block30;
                                                                }
                                                                this.session = this.sessionConnect(port, this.session, machine, bufError, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 25));
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor42 = this.executor;
                                                                    break block31;
                                                                }
                                                                if (this.session == null) {
                                                                    iExecutor52 = null;
                                                                    break block32;
                                                                }
                                                                this.factory = bStandalone ? ExecutionComponentFactoryImpl.getInstance((ISession)this.session) : EclipseExecutionComponentFactoryImpl.getInstance((ISession)this.session);
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor62 = this.executor;
                                                                    break block33;
                                                                }
                                                                progressMonitor.worked(10);
                                                                if (!this.bFactoryInitialized) {
                                                                    this.dpFactory = new ExecutionHarnessDataProcessorFactory(bStandalone);
                                                                    this.initializeRegisteredExecutionComponents(this.factory, bStandalone, this.dpFactory);
                                                                    this.bFactoryInitialized = true;
                                                                }
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor6 = this.executor;
                                                                    break block34;
                                                                }
                                                                progressMonitor.worked(10);
                                                                String envType = this.getExecutionComponentForTestType("ENVIRONMENT", testType, bStandalone);
                                                                this.exeEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType(envType);
                                                                this.session.addChild((IExecutionComponent)this.exeEnvironment);
                                                                if (!ExecutionAdapterUtilities.adaptExecutionDeployment(this.session.getNode(), deployment, bStandalone, testType, bufError, this.systemUtility, this.testTypeMap)) {
                                                                    iExecutor5 = null;
                                                                    break block35;
                                                                }
                                                                if (!ExecutionAdapterUtilities.adaptExecutionEnvironment(this.exeEnvironment, rootResource, theImplementor, bStandalone, testType, deployment, bufError, this.systemUtility, this.testTypeMap)) {
                                                                    iExecutor4 = null;
                                                                    break block36;
                                                                }
                                                                String executorType = this.getExecutionComponentForTestType("EXECUTOR", testType, bStandalone);
                                                                this.executor = (IExecutor)this.factory.createExecutionComponentByType(executorType);
                                                                this.exeEnvironment.addChild((IExecutionComponent)this.executor);
                                                                String execObjType = this.getExecutionComponentForTestType("EXECUTABLEOBJECT", testType, bStandalone);
                                                                IExecutableObject executableObject = this.executor.getCompatibleExecutableObject(execObjType);
                                                                if (!ExecutionAdapterUtilities.adaptExecutableObject(executableObject, rootResource, theImplementor, bStandalone, testType, deployment, bufError, this.systemUtility, this.testTypeMap)) {
                                                                    iExecutor3 = null;
                                                                    break block37;
                                                                }
                                                                if (executableObject != null) {
                                                                    this.executor.setExecutableObject(executableObject);
                                                                    if (this.executor instanceof ExecutorStub) {
                                                                        ((ExecutorStub)this.executor).setExecutionResultLocation(executionResultLocation);
                                                                        ((ExecutorStub)this.executor).setExecutionResultName(executionResultName);
                                                                        ((ExecutorStub)this.executor).setCommunicationPort(port);
                                                                    }
                                                                }
                                                                String agentType = this.getExecutionComponentForTestType("AGENT", testType, bStandalone);
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor2 = this.executor;
                                                                    break block38;
                                                                }
                                                                progressMonitor.worked(10);
                                                                if (activeDataProcessorIDs != null && activeDataProcessorIDs.size() > 0 && this.executor instanceof ExecutorStub) {
                                                                    ArrayList activeDataProcessors = this.initValidDataProcessors(owningTest, machine, agentType, executionResultName, executionResultLocation, overrideExistingResult, port, activeDataProcessorIDs);
                                                                    IExecutionHarnessDataProcessor[] dpArray = this.convertListToArray(activeDataProcessors);
                                                                    this.setAgentData((CFGClass)rootResource, executableObject, (IDataProcessor[])dpArray);
                                                                    ((ExecutorStub)this.executor).setDataProcessors((IDataProcessor[])dpArray);
                                                                } else {
                                                                    this.initializeRemoteHyadesComponent(agentType, null);
                                                                }
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor = this.executor;
                                                                    break block39;
                                                                }
                                                                progressMonitor.worked(10);
                                                                if (this.executor instanceof IExecutorWithProgressMonitorSupport) {
                                                                    ((IExecutorWithProgressMonitorSupport)this.executor).launch((IProgressMonitor)new SubProgressMonitor(progressMonitor, 25));
                                                                } else {
                                                                    this.executor.launch();
                                                                }
                                                                if (progressMonitor.isCanceled()) {
                                                                    iExecutor = this.executor;
                                                                    break block40;
                                                                }
                                                                progressMonitor.worked(10);
                                                                break block41;
                                                            }
                                                            catch (ClassNotFoundException e) {
                                                                this.systemUtility.logError(e);
                                                                String msg = e.getMessage();
                                                                if (msg == null) {
                                                                    msg = e.toString();
                                                                }
                                                                bufError.append(StringUtil.change((String)this.systemUtility.getString("CLASS_NOT_FOUND_ERR_"), (String)"%1", (String)msg));
                                                                Object var27_39 = null;
                                                                progressMonitor.done();
                                                                return this.executor;
                                                            }
                                                            catch (Throwable t) {
                                                                this.systemUtility.logError(t);
                                                                String msg = t.getMessage();
                                                                if (msg != null) {
                                                                    bufError.append(t.getMessage());
                                                                } else {
                                                                    bufError.append(t.toString());
                                                                }
                                                                Object var27_40 = null;
                                                                progressMonitor.done();
                                                                return this.executor;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var27_41 = null;
                                                            progressMonitor.done();
                                                            throw throwable;
                                                        }
                                                    }
                                                    progressMonitor.done();
                                                    return iExecutor32;
                                                }
                                                Object var27_28 = null;
                                                progressMonitor.done();
                                                return iExecutor42;
                                            }
                                            Object var27_29 = null;
                                            progressMonitor.done();
                                            return iExecutor52;
                                        }
                                        Object var27_30 = null;
                                        progressMonitor.done();
                                        return iExecutor62;
                                    }
                                    Object var27_31 = null;
                                    progressMonitor.done();
                                    return iExecutor6;
                                }
                                Object var27_32 = null;
                                progressMonitor.done();
                                return iExecutor5;
                            }
                            Object var27_33 = null;
                            progressMonitor.done();
                            return iExecutor4;
                        }
                        Object var27_34 = null;
                        progressMonitor.done();
                        return iExecutor3;
                    }
                    Object var27_35 = null;
                    progressMonitor.done();
                    return iExecutor2;
                }
                Object var27_36 = null;
                progressMonitor.done();
                return iExecutor;
            }
            Object var27_37 = null;
            progressMonitor.done();
            return iExecutor;
        }
        Object var27_38 = null;
        progressMonitor.done();
        return this.executor;
    }

    private IExecutionHarnessDataProcessor[] convertListToArray(ArrayList registeredDataProcessorsForTestType) {
        IExecutionHarnessDataProcessor[] dp = new IExecutionHarnessDataProcessor[registeredDataProcessorsForTestType.size()];
        int i = 0;
        while (i < registeredDataProcessorsForTestType.size()) {
            dp[i] = (IExecutionHarnessDataProcessor)registeredDataProcessorsForTestType.get(i);
            ++i;
        }
        return dp;
    }

    private void setAgentData(CFGClass rootResource, IExecutableObject executableObject, IDataProcessor[] dataProcessors) {
        if (executableObject instanceof JavaProcessExecutableObjectStub && dataProcessors != null && dataProcessors.length > 1) {
            String dpString = "AgentIDs:";
            int i = 1;
            while (i < dataProcessors.length) {
                dpString = dpString + ((IExecutionHarnessDataProcessor)dataProcessors[i]).getID();
                if (i < dataProcessors.length - 1) {
                    dpString = dpString + ",";
                }
                ++i;
            }
            ((JavaProcessExecutableObjectStub)executableObject).setAgentData(dpString);
        }
    }

    private void initializeRemoteHyadesComponent(String agentType, IExecutionHarnessDataProcessor dp) {
        IRemoteHyadesComponent remoteComponent = (IRemoteHyadesComponent)this.factory.createExecutionComponentByType(agentType);
        this.executor.addChild((IExecutionComponent)remoteComponent);
        remoteComponent.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent event) {
                if (event.getState() == 2) {
                    TestExecutionHarness.this.releaseAgentLock();
                }
            }
        });
        if (dp != null) {
            remoteComponent.startMonitoring((IDataProcessor)dp);
        }
        this.waitForActiveAgent(remoteComponent);
    }

    private ArrayList initValidDataProcessors(ITest theTest, String hostName, String agentType, String executionResultName, String executionResultLocation, boolean overrideExisting, String port, ArrayList validDPIds) {
        ArrayList<IExecutionHarnessDataProcessor> retList = new ArrayList<IExecutionHarnessDataProcessor>();
        ArrayList dpList = this.dpFactory.getDataProcessors();
        int i = 0;
        while (i < dpList.size()) {
            IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dpList.get(i);
            if (validDPIds.contains(dataProcessor.getID())) {
                if (dataProcessor instanceof IExecutionHarnessDataProcessor2) {
                    ((IExecutionHarnessDataProcessor2)dataProcessor).setInitData(theTest, hostName, executionResultName, executionResultLocation, overrideExisting, port);
                } else {
                    dataProcessor.setInitData(theTest, hostName, executionResultName, executionResultLocation, port);
                }
                if (dataProcessor.getID().equalsIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor")) {
                    retList.add(0, dataProcessor);
                } else {
                    retList.add(dataProcessor);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < retList.size()) {
            IExecutionHarnessDataProcessor dp = (IExecutionHarnessDataProcessor)retList.get(i2);
            if (i2 == 0 && dp.getID().compareToIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor") != 0) {
                this.initializeRemoteHyadesComponent(agentType, null);
            } else {
                this.initializeRemoteHyadesComponent(agentType, dp);
            }
            ++i2;
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForActiveAgent(IRemoteHyadesComponent agent) {
        if (agent.getState() == 3) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISession sessionConnect(final String port, ISession session, final String machine, final StringBuffer bufError, final IProgressMonitor progressMonitor) {
        progressMonitor.beginTask("", 20);
        bufError.setLength(0);
        final MutableObject mutableSession = new MutableObject((Object)session);
        try {
            Runnable connectRunnable = new Runnable(){

                public void run() {
                    try {
                        HyadesTestNodeImpl node = new HyadesTestNodeImpl(machine);
                        progressMonitor.worked(5);
                        mutableSession.setValue((Object)node.connect(port, null));
                        progressMonitor.worked(5);
                    }
                    catch (UnknownHostException e) {
                        bufError.append(StringUtil.change((String)TestExecutionHarness.this.systemUtility.getString("TIMEOUT_NODE_ERROR_"), (String)"%1", (String)machine));
                    }
                    catch (AgentControllerUnavailableException e) {
                        bufError.append(StringUtil.change((String)TestExecutionHarness.this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)machine));
                    }
                    catch (UnknownDaemonException e) {
                        bufError.append(StringUtil.change((String)TestExecutionHarness.this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)machine));
                    }
                    catch (Exception e) {
                        TestExecutionHarness.this.systemUtility.logError(e);
                        bufError.append(StringUtil.change((String)TestExecutionHarness.this.systemUtility.getString("RUN_FAILED_ERR_"), (String)"%1", (String)machine));
                    }
                }
            };
            Thread connectThread = new Thread(connectRunnable, "Hyades Session Connect");
            connectThread.setDaemon(true);
            connectThread.start();
            try {
                boolean isCanceled = false;
                while (connectThread.isAlive() && !isCanceled) {
                    progressMonitor.worked(1);
                    if (progressMonitor.isCanceled()) {
                        isCanceled = true;
                        connectThread.interrupt();
                        continue;
                    }
                    connectThread.join(1000L);
                }
            }
            catch (InterruptedException e) {
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return (ISession)mutableSession.getValue();
    }

    private ISession getSession(String port, ISession session, String machine, StringBuffer bufError) {
        bufError.setLength(0);
        SessionContext ctx = new SessionContext(machine, port, null);
        return SessionContextToSessionMap.getInstance().getSessionEntry(ctx);
    }

    private void setStandaloneConfigurationFiles(String[] standaloneConfigurationFiles) {
        this.standaloneConfigurationFiles = standaloneConfigurationFiles;
    }

    public synchronized String stopTest(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)machine);
        }
        try {
            boolean testStopped = false;
            boolean testFound = false;
            ArrayList<IExecutionComponent> componentstoremove = new ArrayList<IExecutionComponent>();
            IExecutionComponent[] exeEnvironments = this.session.getChildren();
            int i = 0;
            while (i < exeEnvironments.length) {
                if (exeEnvironments[i] instanceof IExecutionEnvironment) {
                    IExecutionComponent[] executors = exeEnvironments[i].getChildren();
                    int j = 0;
                    while (j < executors.length) {
                        ExecutableObjectStub exeobj;
                        if (executors[j] instanceof ExecutorStub && (exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) && exeobj.getSuiteID().equals(suite.getId()) && ((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName())) {
                            testFound = true;
                            IExecutionComponent[] agents = executors[j].getChildren();
                            int k = 0;
                            while (k < agents.length) {
                                if (agents[k] instanceof IRemoteHyadesComponent) {
                                    this.stopMonitoringAndWait((IRemoteHyadesComponent)agents[k]);
                                    componentstoremove.add(agents[k]);
                                }
                                ++k;
                            }
                            ((IExecutor)executors[j]).kill();
                            this.removeChildComponents(componentstoremove, executors[j]);
                            componentstoremove.clear();
                            testStopped = true;
                            if (executors[j].getChildren().length == 0) {
                                componentstoremove.add(executors[j]);
                            }
                        }
                        ++j;
                    }
                    this.removeChildComponents(componentstoremove, exeEnvironments[i]);
                    componentstoremove.clear();
                    if (exeEnvironments[i].getChildren().length == 0) {
                        componentstoremove.add(exeEnvironments[i]);
                    }
                }
                ++i;
            }
            this.removeChildComponents(componentstoremove, (IExecutionComponent)this.session);
            if (!testStopped) {
                if (!testFound) {
                    return this.systemUtility.getString("NO_TEST_TO_STOP_ERROR_");
                }
                return this.systemUtility.getString("TEST_STOP_ERROR_");
            }
            this.logStopEvents(execResult);
            execResult.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    public synchronized String stopTest(IExecutor executor, TPFExecutionResult execResult) {
        try {
            if (!this.stopTest(executor)) {
                return this.systemUtility.getString("TEST_STOP_ERROR_");
            }
            this.logStopEvents(execResult);
            execResult.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    private boolean stopTest(IExecutor executor) {
        IExecutionComponent[] agents = executor.getChildren();
        ArrayList<IExecutionComponent> componentsToRemove = new ArrayList<IExecutionComponent>();
        int i = 0;
        while (i < agents.length) {
            if (agents[i] instanceof IRemoteHyadesComponent) {
                try {
                    this.stopMonitoringAndWait((IRemoteHyadesComponent)agents[i]);
                    componentsToRemove.add(agents[i]);
                }
                catch (InterruptedException e) {
                    this.systemUtility.logError(e);
                }
            }
            ++i;
        }
        this.removeChildComponents(componentsToRemove, (IExecutionComponent)executor);
        componentsToRemove.clear();
        executor.kill();
        return true;
    }

    private void logStopEvents(TPFExecutionResult result) {
        String msg = this.systemUtility.getString("TEST_ABORTED_MESSAGE_");
        TPFVerdictEvent verdict = Common_TestprofileFactory.eINSTANCE.createTPFVerdictEvent();
        verdict.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
        verdict.setReason(TPFVerdictReason.ABORT_LITERAL);
        verdict.setText(msg);
        verdict.setExecutionHistory(result.getExecutionHistory());
        TPFTypedEvent stopEvent = Common_TestprofileFactory.eINSTANCE.createTPFTypedEvent();
        stopEvent.setType(TPFExecutionType.STOP_LITERAL);
        stopEvent.setText(msg);
        stopEvent.setTimestamp(System.currentTimeMillis());
        stopEvent.setExecutionHistory(result.getExecutionHistory());
        result.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
    }

    private void stopMonitoringAndWait(IRemoteHyadesComponent agent) throws InterruptedException {
        agent.stopMonitoring();
        Thread.sleep(3000L);
    }

    private void removeChildComponents(ArrayList children, IExecutionComponent parent) {
        int i = 0;
        while (i < children.size()) {
            parent.removeChild((IExecutionComponent)children.get(i));
            ++i;
        }
    }

    public synchronized String performControlEvent(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult, String controlEvent, String[] params) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        if (!this.canSupportControlEvent(suite, theTest, location, port, execResult, controlEvent)) {
            return StringUtil.change((String)this.systemUtility.getString("CANNOT_SUPPORT_MSG_"), (String)"%1", (String)controlEvent);
        }
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)machine);
        }
        String error = null;
        try {
            boolean controlEventPerformed = false;
            IExecutionComponent[] exeEnvironments = this.session.getChildren();
            int i = 0;
            while (i < exeEnvironments.length) {
                if (exeEnvironments[i] instanceof IExecutionEnvironment) {
                    IExecutionComponent[] executors = exeEnvironments[i].getChildren();
                    int j = 0;
                    while (j < executors.length) {
                        ExecutableObjectStub exeobj;
                        if (executors[j] instanceof ExecutorStub && (exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) && exeobj.getSuiteID().equals(suite.getId()) && ((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName()) && (error = ((IExecutor)executors[j]).performControlEvent("CONTROL_EVENT_SUSPEND", params)) == null) {
                            controlEventPerformed = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (!controlEventPerformed) {
                if (error == null) {
                    return StringUtil.change((String)this.systemUtility.getString("CANNOT_PERFORM_MSG_"), (String)"%1", (String)controlEvent);
                }
                return error;
            }
        }
        catch (Throwable t) {
            this.systemUtility.logError(t);
            return t.getMessage();
        }
        return null;
    }

    public synchronized boolean canSupportControlEvent(ITestSuite suite, ITest theTest, CFGLocation location, String port, TPFExecutionResult execResult, String controlEvent) {
        String machine = ((CFGMachineConstraint)location).getHostname();
        StringBuffer bufError = new StringBuffer();
        this.session = this.getSession(port, this.session, machine, bufError);
        if (this.session == null) {
            return false;
        }
        boolean canSupport = false;
        IExecutionComponent[] exeEnvironments = this.session.getChildren();
        int i = 0;
        while (i < exeEnvironments.length) {
            if (exeEnvironments[i] instanceof IExecutionEnvironment) {
                IExecutionComponent[] executors = exeEnvironments[i].getChildren();
                int j = 0;
                while (j < executors.length) {
                    ExecutableObjectStub exeobj;
                    if (executors[j] instanceof ExecutorStub && (exeobj = (ExecutableObjectStub)((IExecutor)executors[j]).getExecutableObject()).getTestID().equals(theTest.getId()) && exeobj.getSuiteID().equals(suite.getId()) && ((ExecutorStub)executors[j]).getExecutionResultName().equals(execResult.getName())) {
                        if (((IExecutor)executors[j]).supportsControlEvent(controlEvent)) {
                            canSupport = true;
                        } else {
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return canSupport;
    }

    private IImplementor getImplementor(ITestSuite suite, ITest theTest) {
        IImplementor theImplementor = null;
        theImplementor = theTest != null ? theTest.getImplementor() : suite.getImplementor();
        return theImplementor;
    }

    public static void waitForDataProcessorExit(IExecutor executor) {
        IRemoteHyadesComponent remoteComponent = TestExecutionHarness.findRemoteHyadesComponent(executor);
        if (remoteComponent != null) {
            while (remoteComponent.isActive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    private IProgressMonitor createNullProgressMonitor() {
        return new NullProgressMonitor();
    }
}

