/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public class TestExecutionHarnessExecutorStub
extends ExecutorStub {
    private static final String AGENT_TYPE = "tester";

    private CustomCommand createResumeCommand() {
        BinaryCustomCommand resumeCommand = new BinaryCustomCommand();
        resumeCommand.setData("START");
        return resumeCommand;
    }

    protected AgentListener getAgentListener() {
        return new AgentListener(){

            public void agentActive(Agent agent) {
            }

            public void agentInactive(Agent agent) {
            }

            public void error(Agent agent, String errorId, String errorMessage) {
            }

            public void handleCommand(Agent agent, CommandElement command) {
            }
        };
    }

    private Process getAgentProcess() {
        return ((SessionStub)this.getSessionContext()).getAgent().getProcess();
    }

    private void handleException(Exception exception) {
        ExecutionHarnessPlugin.getDefault().logError(exception);
    }

    public void launch() throws ExecutionComponentStateException {
        this.launch((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(IProgressMonitor progressMonitor) throws ExecutionComponentStateException {
        super.launch(progressMonitor);
        int timeout = 60000;
        progressMonitor.beginTask("", timeout * 10 + this.getDataProcessors().length * 12);
        try {
            try {
                this.resetAgentInitCount();
                Node node = this.getAgentProcess().getNode();
                IDataProcessor[] dataProcessors = this.getDataProcessors();
                Process process = this.waitForProcess(this.getPid(), node, timeout, progressMonitor);
                if (process != null) {
                    if (dataProcessors != null) {
                        this.launch(process, progressMonitor, dataProcessors);
                    }
                    this.launch(process);
                }
                System.out.println("Process could not be retrieved!");
            }
            catch (InactiveAgentException e) {
                this.handleException((Exception)((Object)e));
                Object var8_10 = null;
                progressMonitor.done();
                return;
            }
            catch (InactiveProcessException e) {
                this.handleException((Exception)((Object)e));
                Object var8_11 = null;
                progressMonitor.done();
                return;
            }
            catch (NotConnectedException e) {
                this.handleException((Exception)((Object)e));
                Object var8_12 = null;
                progressMonitor.done();
                return;
            }
            catch (UnsupportedEncodingException e) {
                this.handleException(e);
                Object var8_13 = null;
                progressMonitor.done();
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
    }

    private void launch(Process process) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        Agent agent = this.findAgent(process, AGENT_TYPE, "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        this.setupControlListener(this.getAgentListener(), agent);
        this.resume(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(Process process, IProgressMonitor progressMonitor, IDataProcessor[] dataProcessors) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        Process process2 = process;
        synchronized (process2) {
            int i = 0;
            int n = dataProcessors.length;
            while (i < n) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                progressMonitor.worked(4);
                IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dataProcessors[i];
                if (dataProcessor.getControlAgent() == null) {
                    Agent agent = this.findAgent(process, AGENT_TYPE, dataProcessor.getName());
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    progressMonitor.worked(4);
                    this.setupDataProcessor(agent, process, dataProcessor);
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    progressMonitor.worked(4);
                    this.setupControlListener(this.getAgentListener(), agent);
                }
                ++i;
            }
        }
        IExecutionHarnessDataProcessor controller = (IExecutionHarnessDataProcessor)dataProcessors[0];
        if (controller != null) {
            this.resume(controller.getControlAgent());
        }
    }

    public String performControlEvent(String controlEvent, String[] params) {
        return "";
    }

    private void resume(Agent agent) throws InactiveAgentException {
        if (agent != null) {
            agent.invokeCustomCommand(this.createResumeCommand());
        }
    }

    protected void setupDataProcessor(Agent agent, Process process, IExecutionHarnessDataProcessor dataProcessor) {
        dataProcessor.setControlAgent(agent);
        dataProcessor.setProcess(process);
        dataProcessor.init();
    }

    public boolean supportsControlEvent(String controlEvent) {
        return true;
    }
}

