/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.harness.ExecutionHarnessDataProcessorFactory;
import org.eclipse.hyades.execution.harness.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandaloneExecutionUtilities {
    public static void initializeRegisteredExecutionComponents(String[] standaloneConfigurationFiles, HashMap testTypeMap, IExecutionComponentFactory factory, ExecutionHarnessDataProcessorFactory dpFactory) throws ClassNotFoundException, FileNotFoundException {
        ArrayList dataProcessorCollection = new ArrayList();
        int i = 0;
        while (i < standaloneConfigurationFiles.length) {
            StandaloneExecutionUtilities.parseConfigFile(standaloneConfigurationFiles[i], testTypeMap, factory, dataProcessorCollection);
            ++i;
        }
        ExecutionHarnessDataProcessorFactory.setStandAloneClassObjects(dataProcessorCollection);
    }

    private static void parseConfigFile(String configFile, HashMap testTypeMap, IExecutionComponentFactory factory, ArrayList dataProcessors) throws ClassNotFoundException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(configFile);
        Element plugin = XMLUtil.loadDom(stream, "plugin");
        NodeList nodeList = XMLUtil.getChildrenByName(plugin, "extension");
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element extensionElement;
                if (nodeList.item(i) instanceof Element && (extensionElement = (Element)nodeList.item(i)) != null) {
                    NodeList envAdapters;
                    int j;
                    if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl")) {
                        NodeList execComps = XMLUtil.getChildrenByName(extensionElement, "RegisteredExecutionComponentImpl");
                        j = 0;
                        while (j < execComps.getLength()) {
                            if (execComps.item(j) instanceof Element) {
                                StandaloneExecutionUtilities.parseRegisteredExecutionComponents((Element)execComps.item(j), testTypeMap, factory);
                            }
                            ++j;
                        }
                    }
                    if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter")) {
                        envAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutionEnvironmentAdapter");
                        j = 0;
                        while (j < envAdapters.getLength()) {
                            if (envAdapters.item(j) instanceof Element) {
                                StandaloneExecutionUtilities.parseAdapters((Element)envAdapters.item(j), testTypeMap, "EXECUTION_ENVIRONMENT_ADAPTER");
                            }
                            ++j;
                        }
                    }
                    if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter")) {
                        NodeList execObjAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutableObjectAdapter");
                        j = 0;
                        while (j < execObjAdapters.getLength()) {
                            if (execObjAdapters.item(j) instanceof Element) {
                                StandaloneExecutionUtilities.parseAdapters((Element)execObjAdapters.item(j), testTypeMap, "EXECUTABLE_OBJECT_ADAPTER");
                            }
                            ++j;
                        }
                    }
                    if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutionDeploymentAdapter")) {
                        envAdapters = XMLUtil.getChildrenByName(extensionElement, "ExecutionDeploymentAdapter");
                        j = 0;
                        while (j < envAdapters.getLength()) {
                            if (envAdapters.item(j) instanceof Element) {
                                StandaloneExecutionUtilities.parseAdapters((Element)envAdapters.item(j), testTypeMap, "EXECUTION_DEPLOYMENT_ADAPTER");
                            }
                            ++j;
                        }
                    }
                    if (extensionElement.getAttribute("point").equals("org.eclipse.hyades.execution.harness.Dataprocessor")) {
                        NodeList dataProcessorNodeList = XMLUtil.getChildrenByName(extensionElement, "dataprocessor");
                        j = 0;
                        while (j < dataProcessorNodeList.getLength()) {
                            if (dataProcessorNodeList.item(j) instanceof Element) {
                                StandaloneExecutionUtilities.parseDataProcessors((Element)dataProcessorNodeList.item(j), dataProcessors);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static void parseRegisteredExecutionComponents(Element extensionElement, HashMap testTypeMap, IExecutionComponentFactory factory) throws ClassNotFoundException {
        String type = extensionElement.getAttribute("type");
        String executionComponentName = extensionElement.getAttribute("name");
        factory.addExecutionComponent(executionComponentName, extensionElement.getAttribute("implClass"));
        factory.addStub(executionComponentName, extensionElement.getAttribute("stubClass"));
        factory.addSkeleton(executionComponentName, extensionElement.getAttribute("skeletonClass"));
        Object map = testTypeMap.get(type);
        if (map == null) {
            map = new HashMap();
            testTypeMap.put(type, map);
        }
        HashMap execCompMap = (HashMap)map;
        NodeList supportedTestTypes = XMLUtil.getChildrenByName(extensionElement, "SupportedTestType");
        int j = 0;
        while (j < supportedTestTypes.getLength()) {
            if (supportedTestTypes.item(j) instanceof Element) {
                Element supportedType = (Element)supportedTestTypes.item(j);
                execCompMap.put(supportedType.getAttribute("name"), executionComponentName);
            }
            ++j;
        }
    }

    private static void parseAdapters(Element adapterElement, HashMap testTypeMap, String type) {
        String adapterClass = adapterElement.getAttribute("class");
        Object map = testTypeMap.get(type);
        if (map == null) {
            map = new HashMap();
            testTypeMap.put(type, map);
        }
        HashMap execCompMap = (HashMap)map;
        NodeList supportedTestTypes = XMLUtil.getChildrenByName(adapterElement, "SupportedTestType");
        int j = 0;
        while (j < supportedTestTypes.getLength()) {
            if (supportedTestTypes.item(j) instanceof Element) {
                Element supportedType = (Element)supportedTestTypes.item(j);
                execCompMap.put(supportedType.getAttribute("name"), adapterClass);
            }
            ++j;
        }
    }

    private static void parseDataProcessors(Element dataProcessorElement, ArrayList dataProcessorCollection) {
        String adapterClass = dataProcessorElement.getAttribute("class");
        try {
            dataProcessorCollection.add(Class.forName(adapterClass));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] getConfigFilesFromConfigDir(String configDir) {
        File configDirFile = new File(configDir);
        if (!configDirFile.isDirectory()) {
            return null;
        }
        configDir = configDirFile.getAbsolutePath();
        configDirFile = new File(configDir = configDir + File.separator + "plugins");
        if (!configDirFile.isDirectory()) {
            return null;
        }
        ArrayList<String> pluginPaths = new ArrayList<String>();
        String[] elements = configDirFile.list();
        int i = 0;
        while (i < elements.length) {
            String element = configDir + File.separator + elements[i];
            File elementFile = new File(element);
            if (elementFile.isDirectory() && (elementFile = new File(element = element + File.separator + "plugin.xml")).exists()) {
                pluginPaths.add(element);
            }
            ++i;
        }
        return pluginPaths.toArray(new String[0]);
    }

    public static String getHarnessDir(String configDir, String version) {
        File configDirFile = new File(configDir);
        if (!configDirFile.isDirectory()) {
            return null;
        }
        configDir = configDirFile.getAbsolutePath();
        String harnessDir = configDir + File.separator + "plugins" + File.separator + "org.eclipse.hyades.execution.harness_" + version;
        File harnessFile = new File(harnessDir);
        if (harnessFile.isDirectory()) {
            return harnessDir;
        }
        return null;
    }
}

