/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DatapoolColumnDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_VARIABLES = "variables";
    private static final int HEIGHT = 120;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private IDatapoolVariable selectedVariable = null;
    private IDatapoolVariable previousVariable = null;
    private Text nameField = null;
    private Text typeField = null;
    private Color nameFieldForeground = null;
    private Color typeFieldForeground = null;
    private Combo insertionVariables = null;
    private Label nameErrorLabel;
    private Label typeErrorLabel;
    private String name = null;
    private String type = new String();
    private String insertionVariableID = null;
    private String insertionVariableName = null;
    private int defaultNameCounter = 1;

    public DatapoolColumnDialog(Shell parentShell, IDatapool datapool, IDatapoolVariable selectedVariable, IDatapoolVariable previousVariable, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.shell = parentShell;
        this.datapool = datapool;
        this.title = title;
        this.selectedVariable = selectedVariable;
        this.previousVariable = previousVariable;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        superComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        superComposite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(superComposite, 0);
        nameLabel.setText(DatapoolPlugin.getResourceString("DATA_COL_DLG_NAME"));
        this.nameField = new Text(superComposite, 2052);
        gridData = new GridData(256);
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        this.nameFieldForeground = this.nameField.getForeground();
        Label typeLabel = new Label(superComposite, 0);
        typeLabel.setText(DatapoolPlugin.getResourceString("DATA_COL_DLG_TYPE"));
        this.typeField = new Text(superComposite, 2052);
        gridData = new GridData(256);
        this.typeField.setLayoutData((Object)gridData);
        this.typeField.addKeyListener((KeyListener)this);
        this.typeFieldForeground = this.typeField.getForeground();
        IDatapoolVariable[] variables = DatapoolUtil.getInstance().getVariables(this.datapool, null);
        if (this.selectedVariable != null) {
            this.name = this.selectedVariable.getName();
            this.nameField.setText(this.name);
            this.nameField.selectAll();
            IDatapoolSuggestedType suggestedType = this.selectedVariable.getSuggestedType();
            if (suggestedType != null) {
                this.type = suggestedType.getSuggestedClassName();
                if (this.type != null) {
                    this.typeField.setText(this.type);
                    this.typeField.setSelection(this.type.length() + 1);
                }
            }
        }
        String[] variableLabels = this.getVariableLabels(variables);
        Label insertionLabel = new Label(superComposite, 0);
        if (this.title.equals(DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"))) {
            insertionLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_INS"));
            this.name = this.createDefaultName();
            while (!DatapoolUtil.getInstance().isVariableNameUnique(this.datapool, this.name, null)) {
                this.name = this.createDefaultName();
            }
            this.nameField.setText(this.name);
            this.nameField.selectAll();
        } else {
            insertionLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_MOVE"));
        }
        this.insertionVariables = new Combo(superComposite, 12);
        this.insertionVariables.setItems(variableLabels);
        this.insertionVariables.setData(TAG_VARIABLES, (Object)variables);
        this.insertionVariables.setLayoutData((Object)new GridData(256));
        this.insertionVariables.addSelectionListener((SelectionListener)this);
        if (variables.length > 0 && this.previousVariable != null) {
            int selectIndex = this.findVariableIndexInCombo(variables, this.previousVariable);
            this.insertionVariables.select(selectIndex + 1);
            this.insertionVariableName = variables[selectIndex].getName();
            this.insertionVariableID = variables[selectIndex].getId();
        } else {
            this.insertionVariables.select(0);
            this.insertionVariableName = new String();
            this.insertionVariableID = new String();
        }
        this.nameErrorLabel = new Label(superComposite, 0);
        this.nameErrorLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_VALID"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.nameErrorLabel.setLayoutData((Object)gridData);
        this.nameErrorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.nameErrorLabel.setVisible(false);
        this.typeErrorLabel = new Label(superComposite, 0);
        this.typeErrorLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_TYPE_NOT_VALID"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.typeErrorLabel.setLayoutData((Object)gridData);
        this.typeErrorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.typeErrorLabel.setVisible(false);
        superComposite.pack();
        return superComposite;
    }

    private boolean enableOK() {
        String name;
        boolean enableButton = true;
        String nameErrorText = new String();
        Display display = Display.getDefault();
        Color color = display.getSystemColor(3);
        String type = this.typeField.getText();
        if (type != null) {
            boolean isTypeValid = DatapoolUtil.getInstance().isVariableTypeValid(type);
            if (!isTypeValid) {
                enableButton = false;
                this.typeField.setForeground(color);
            } else {
                this.typeField.setForeground(this.typeFieldForeground);
            }
            this.typeErrorLabel.setVisible(!enableButton);
        }
        if ((name = this.nameField.getText()) == null || name.length() == 0) {
            enableButton = false;
            this.nameErrorLabel.setVisible(false);
        }
        if (name != null && name.length() > 0) {
            boolean isNameUnique = DatapoolUtil.getInstance().isVariableNameUnique(this.datapool, name, this.selectedVariable);
            boolean isNameValid = DatapoolUtil.getInstance().isVariableNameValid(name);
            if (isNameUnique && isNameValid) {
                this.nameField.setForeground(this.nameFieldForeground);
                this.nameErrorLabel.setVisible(false);
            } else {
                enableButton = false;
                this.nameField.setForeground(color);
                nameErrorText = DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR");
                if (!isNameUnique) {
                    nameErrorText = nameErrorText + DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE");
                } else if (!isNameValid) {
                    nameErrorText = nameErrorText + DatapoolPlugin.getResourceString("DATA_COL_DLG_ERROR_NAME_NOT_VALID");
                }
                this.nameErrorLabel.setText(nameErrorText);
                this.nameErrorLabel.setVisible(true);
            }
        }
        this.getButton(0).setEnabled(enableButton);
        return enableButton;
    }

    private String[] getVariableLabels(IDatapoolVariable[] variables) {
        if (variables == null) {
            return null;
        }
        int listSize = variables.length;
        String[] returnList = new String[listSize + 1];
        String insertLabelPattern = DatapoolPlugin.getResourceString("DATA_DLG_INSERT_VARIABLE_FORMAT");
        int i = 0;
        while (i < listSize) {
            IDatapoolVariable variable = variables[i];
            if (variable != null) {
                Object[] messageElements;
                String name = variable.getName();
                if (i == 0) {
                    messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), name};
                    returnList[i] = MessageFormat.format(insertLabelPattern, messageElements);
                }
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), name};
                returnList[i + 1] = MessageFormat.format(insertLabelPattern, messageElements);
            }
            ++i;
        }
        if (listSize == 0) {
            returnList[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return returnList;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getInsertionVariableName() {
        return this.insertionVariableName;
    }

    public String getInsertionVariableID() {
        return this.insertionVariableID;
    }

    private int findVariableIndexInCombo(IDatapoolVariable[] variables, IDatapoolVariable variable) {
        if (variables == null || variable == null) {
            return -1;
        }
        int i = 0;
        while (i < variables.length) {
            if (variables[i].equals(variable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent e) {
        Combo insertVariableCombo = (Combo)e.widget;
        int selectionIndex = insertVariableCombo.getSelectionIndex();
        IDatapoolVariable[] variables = (IDatapoolVariable[])insertVariableCombo.getData(TAG_VARIABLES);
        if (selectionIndex > 0 && selectionIndex <= variables.length) {
            IDatapoolVariable variable = variables[selectionIndex - 1];
            this.insertionVariableName = variable.getName();
            this.insertionVariableID = variable.getId();
        } else {
            this.insertionVariableName = new String();
            this.insertionVariableID = new String();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        if (this.typeField != null) {
            this.type = this.typeField.getText();
        }
        this.enableOK();
    }

    private String createDefaultName() {
        Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME"), NumberFormat.getInstance().format(this.defaultNameCounter)};
        ++this.defaultNameCounter;
        return MessageFormat.format(DatapoolPlugin.getResourceString("DATA_VARIABLE_NAME_FORMAT"), messageElements);
    }
}

