/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ImageList;

public class Label
extends Control {
    int frameHandle;
    int labelHandle;
    int imageHandle;
    ImageList imageList;
    Image image;
    String text;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.labelHandle == 0) {
            return;
        }
        int accessible = OS.gtk_widget_get_accessible(this.labelHandle);
        int controlAccessible = OS.gtk_widget_get_accessible(control.handle);
        if (accessible != 0 && controlAccessible != 0) {
            OS.atk_object_add_relationship(controlAccessible, 4, accessible);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        boolean fixWrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                if (wHint == -1) {
                    wHint = 64;
                }
            } else if (hHint == -1) {
                hHint = 64;
            }
        }
        boolean bl = fixWrap = this.labelHandle != 0 && (this.style & 0x40) != 0;
        if (fixWrap || this.frameHandle != 0) {
            this.forceResize();
        }
        int[] labelWidth = new int[1];
        int[] labelHeight = new int[1];
        if (fixWrap) {
            OS.gtk_widget_get_size_request(this.labelHandle, labelWidth, labelHeight);
            OS.gtk_widget_set_size_request(this.labelHandle, wHint, hHint);
        }
        if (this.frameHandle != 0) {
            int[] reqWidth = new int[1];
            int[] reqHeight = new int[1];
            OS.gtk_widget_get_size_request(this.handle, reqWidth, reqHeight);
            OS.gtk_widget_set_size_request(this.handle, wHint, hHint);
            size = this.computeNativeSize(this.frameHandle, -1, -1, changed);
            OS.gtk_widget_set_size_request(this.handle, reqWidth[0], reqHeight[0]);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if (fixWrap) {
            OS.gtk_widget_set_size_request(this.labelHandle, labelWidth[0], labelHeight[0]);
        }
        if (hHint == -1 && this.labelHandle != 0) {
            int layout = OS.gtk_label_get_layout(this.labelHandle);
            int context = OS.pango_layout_get_context(layout);
            int lang = OS.pango_context_get_language(context);
            int font = this.getFontDescription();
            int metrics = OS.pango_context_get_metrics(context, font, lang);
            int ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(metrics));
            int descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(metrics));
            OS.pango_font_metrics_unref(metrics);
            int fontHeight = ascent + descent;
            int[] buffer = new int[1];
            OS.g_object_get(this.labelHandle, OS.ypad, buffer, 0);
            fontHeight += 2 * buffer[0];
            if (this.frameHandle != 0) {
                int style = OS.gtk_widget_get_style(this.frameHandle);
                fontHeight += 2 * OS.gtk_style_get_ythickness(style);
                fontHeight += 2 * OS.gtk_container_get_border_width(this.frameHandle);
            }
            size.y = Math.max(size.y, fontHeight);
        }
        return size;
    }

    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if ((this.style & 2) != 0) {
            this.handle = (this.style & 0x100) != 0 ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = OS.gtk_hbox_new(false, 0);
            if (this.handle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.labelHandle);
            OS.gtk_container_add(this.handle, this.imageHandle);
        }
        if ((this.style & 0x800) != 0) {
            this.frameHandle = OS.gtk_frame_new(null);
            if (this.frameHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.frameHandle);
            OS.gtk_container_add(this.frameHandle, this.handle);
            OS.gtk_frame_set_shadow_type(this.frameHandle, 3);
        } else {
            OS.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_label_set_line_wrap(this.labelHandle, true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                OS.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
            }
        }
        this.setAlignment();
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if (this.frameHandle != 0) {
            return OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.frameHandle));
        }
        return 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    boolean isDescribedByLabel() {
        return false;
    }

    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            Composite control = this.parent;
            while (control != null) {
                Control[] children = control._getChildren();
                int index = 0;
                while (index < children.length) {
                    if (children[index] == this) break;
                    ++index;
                }
                if (++index < children.length && children[index].setFocus()) {
                    return result;
                }
                control = control.parent;
            }
        }
        return result;
    }

    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    void register() {
        super.register();
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.frameHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    void resizeHandle(int width, int height) {
        OS.gtk_widget_set_size_request(this.fixedHandle, width, height);
        OS.gtk_widget_set_size_request(this.frameHandle != 0 ? this.frameHandle : this.handle, width, height);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.setAlignment();
    }

    void setAlignment() {
        int layout;
        int linePtr;
        int resolved_dir;
        boolean isRTL;
        boolean bl = isRTL = (this.style & 0x4000000) != 0;
        if (this.text != null && this.text.length() != 0 && OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (resolved_dir = OS.pango_layout_line_get_resolved_dir(linePtr = OS.pango_layout_get_line(layout = OS.gtk_label_get_layout(this.labelHandle), 0))) == 1) {
            boolean bl2 = isRTL = !isRTL;
        }
        if ((this.style & 0x4000) != 0) {
            OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.0f);
            OS.gtk_label_set_justify(this.labelHandle, isRTL ? 1 : 0);
            OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.0f);
            OS.gtk_label_set_justify(this.labelHandle, 2);
            OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.0f);
            OS.gtk_label_set_justify(this.labelHandle, isRTL ? 0 : 1);
            OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        this.setBackgroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setBackgroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundColor(this.imageHandle, color);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean fixWrap;
        boolean bl = fixWrap = resize && this.labelHandle != 0 && (this.style & 0x40) != 0;
        if (fixWrap) {
            OS.gtk_widget_set_size_request(this.labelHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (fixWrap) {
            int labelWidth = OS.GTK_WIDGET_WIDTH(this.handle);
            int labelHeight = OS.GTK_WIDGET_HEIGHT(this.handle);
            OS.gtk_widget_set_size_request(this.labelHandle, labelWidth, labelHeight);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.labelHandle, requisition);
            GtkAllocation allocation = new GtkAllocation();
            allocation.x = OS.GTK_WIDGET_X(this.labelHandle);
            allocation.y = OS.GTK_WIDGET_Y(this.labelHandle);
            allocation.width = labelWidth;
            allocation.height = labelHeight;
            OS.gtk_widget_size_allocate(this.labelHandle, allocation);
        }
        return result;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font(this.labelHandle, font);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font(this.imageHandle, font);
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        this.setForegroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, 2);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, 2);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            OS.gtk_widget_hide(this.labelHandle);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        OS.gtk_widget_hide(this.imageHandle);
        OS.gtk_widget_show(this.labelHandle);
        this.setAlignment();
    }

    void showWidget() {
        super.showWidget();
        if (this.frameHandle != 0) {
            OS.gtk_widget_show(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }
}

