/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPaneFactory;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DetailPaneManager {
    private static DetailPaneManager fgSingleton;
    private Map fFactoriesByPaneID = new HashMap();
    private Map fPreferredDetailPanes;
    private Collection fKnownFactories;
    public static final String PREF_DETAIL_AREAS = "preferredDetailPanes";

    private DetailPaneManager() {
    }

    public static DetailPaneManager getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new DetailPaneManager();
        }
        return fgSingleton;
    }

    public String getPreferredPaneFromSelection(IStructuredSelection selection) {
        Collection possibleFactories = this.getEnabledFactories(selection);
        Set possiblePaneIDs = this.getPossiblePaneIDs(possibleFactories, selection);
        return this.chooseDetailsAreaIDInSet(possiblePaneIDs, possibleFactories, selection);
    }

    public Set getAvailablePaneIDs(IStructuredSelection selection) {
        Collection possibleFactories = this.getEnabledFactories(selection);
        return this.getPossiblePaneIDs(possibleFactories, selection);
    }

    public IDetailPane getDetailPaneFromID(String ID) {
        IDetailPaneFactory factory = (IDetailPaneFactory)this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.createDetailPane(ID);
        }
        return null;
    }

    public String getNameFromID(String ID) {
        IDetailPaneFactory factory = (IDetailPaneFactory)this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.getDetailPaneName(ID);
        }
        return null;
    }

    public String getDescriptionFromID(String ID) {
        IDetailPaneFactory factory = (IDetailPaneFactory)this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.getDetailPaneDescription(ID);
        }
        return null;
    }

    private Collection getEnabledFactories(IStructuredSelection selection) {
        ArrayList<IDetailPaneFactory> factoriesForSelection = new ArrayList<IDetailPaneFactory>();
        if (this.fKnownFactories == null) {
            this.initializeDetailFactories();
        }
        Iterator iter = this.fKnownFactories.iterator();
        while (iter.hasNext()) {
            IDetailPaneFactory currentFactory = (IDetailPaneFactory)iter.next();
            if (!(currentFactory instanceof DetailPaneFactoryExtension) || !((DetailPaneFactoryExtension)currentFactory).isEnabled(selection)) continue;
            factoriesForSelection.add(currentFactory);
        }
        return factoriesForSelection;
    }

    private Set getPossiblePaneIDs(Collection factoriesToQuery, IStructuredSelection selection) {
        LinkedHashSet<String> idsForSelection = new LinkedHashSet<String>();
        Iterator factoryIter = factoriesToQuery.iterator();
        while (factoryIter.hasNext()) {
            IDetailPaneFactory currentFactory = (IDetailPaneFactory)factoryIter.next();
            Iterator detailAreaTypes = currentFactory.getDetailPaneTypes(selection).iterator();
            while (detailAreaTypes.hasNext()) {
                String currentAreaTypeID = (String)detailAreaTypes.next();
                this.fFactoriesByPaneID.put(currentAreaTypeID, currentFactory);
                idsForSelection.add(currentAreaTypeID);
            }
        }
        return idsForSelection;
    }

    private String chooseDetailsAreaIDInSet(Set possiblePaneIDs, Collection enabledFactories, IStructuredSelection selection) {
        if (possiblePaneIDs == null || possiblePaneIDs.isEmpty()) {
            return null;
        }
        String preferredID = this.getUserPreferredDetailPane(possiblePaneIDs);
        if (preferredID == null) {
            Iterator factoryIterator = enabledFactories.iterator();
            while (preferredID == null && factoryIterator.hasNext()) {
                IDetailPaneFactory currentFactory = (IDetailPaneFactory)factoryIterator.next();
                preferredID = currentFactory.getDefaultDetailPane(selection);
            }
            if (preferredID == null) {
                Iterator paneIterator = possiblePaneIDs.iterator();
                preferredID = (String)paneIterator.next();
                while (paneIterator.hasNext() && preferredID != DefaultDetailPaneFactory.DEFAULT_DETAIL_PANE_ID) {
                    String currentID = (String)paneIterator.next();
                    if (!currentID.equals(DefaultDetailPaneFactory.DEFAULT_DETAIL_PANE_ID)) continue;
                    preferredID = currentID;
                }
            }
            this.setPreferredDetailPane(possiblePaneIDs, preferredID);
        }
        return preferredID;
    }

    private synchronized void initializeDetailFactories() {
        if (this.fKnownFactories == null) {
            this.fKnownFactories = new ArrayList();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "detailPaneFactories");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            DetailPaneFactoryExtension delegate = null;
            int i = 0;
            while (i < infos.length) {
                delegate = new DetailPaneFactoryExtension(infos[i]);
                this.fKnownFactories.add(delegate);
                ++i;
            }
        }
    }

    public String getUserPreferredDetailPane(Set possibleDetailsAreaIDs) {
        if (this.fPreferredDetailPanes == null) {
            this.loadPreferredDetailsAreas();
        }
        return (String)this.fPreferredDetailPanes.get(possibleDetailsAreaIDs);
    }

    public void setPreferredDetailPane(Set possibleDetailsAreaIDs, String preferredDetailsAreaID) {
        String currentKey;
        if (possibleDetailsAreaIDs == null) {
            return;
        }
        if (this.fPreferredDetailPanes == null) {
            this.loadPreferredDetailsAreas();
        }
        if ((currentKey = (String)this.fPreferredDetailPanes.get(possibleDetailsAreaIDs)) == null || !currentKey.equals(preferredDetailsAreaID)) {
            this.fPreferredDetailPanes.put(possibleDetailsAreaIDs, preferredDetailsAreaID);
            this.storePreferredDetailsAreas();
        }
    }

    private void storePreferredDetailsAreas() {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fPreferredDetailPanes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Iterator setIter = ((Set)entry.getKey()).iterator();
            while (setIter.hasNext()) {
                String currentID = (String)setIter.next();
                buffer.append(currentID);
                buffer.append(',');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(':');
            buffer.append(entry.getValue());
            buffer.append('|');
        }
        DebugUIPlugin.getDefault().getPluginPreferences().setValue(PREF_DETAIL_AREAS, buffer.toString());
    }

    private void loadPreferredDetailsAreas() {
        this.fPreferredDetailPanes = new HashMap();
        String preferenceValue = DebugUIPlugin.getDefault().getPluginPreferences().getString(PREF_DETAIL_AREAS);
        StringTokenizer entryTokenizer = new StringTokenizer(preferenceValue, "|");
        while (entryTokenizer.hasMoreTokens()) {
            String token = entryTokenizer.nextToken();
            int valueStart = token.indexOf(58);
            StringTokenizer keyTokenizer = new StringTokenizer(token.substring(0, valueStart), ",");
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            while (keyTokenizer.hasMoreTokens()) {
                keys.add(keyTokenizer.nextToken());
            }
            this.fPreferredDetailPanes.put(keys, token.substring(valueStart + 1));
        }
    }

    private class DetailPaneFactoryExtension
    implements IDetailPaneFactory {
        private IConfigurationElement fConfigElement;
        private IDetailPaneFactory fFactory;
        private Expression fEnablementExpression;

        public DetailPaneFactoryExtension(IConfigurationElement configElement) {
            this.fConfigElement = configElement;
        }

        public IDetailPane createDetailPane(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().createDetailPane(paneID);
            }
            return null;
        }

        public Set getDetailPaneTypes(IStructuredSelection selection) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneTypes(selection);
            }
            return new HashSet(0);
        }

        public String getDefaultDetailPane(IStructuredSelection selection) {
            if (this.getFactory() != null) {
                return this.getFactory().getDefaultDetailPane(selection);
            }
            return null;
        }

        public String getDetailPaneName(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneName(paneID);
            }
            return null;
        }

        public String getDetailPaneDescription(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneDescription(paneID);
            }
            return null;
        }

        private IDetailPaneFactory getFactory() {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            try {
                Object obj = this.fConfigElement.createExecutableExtension("class");
                if (!(obj instanceof IDetailPaneFactory)) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.detailFactories extension failed to load a detail factory because the specified class does not implement org.eclipse.debug.ui.IDetailPaneFactory.  Class specified was: " + obj, null));
                }
                this.fFactory = (IDetailPaneFactory)obj;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
                this.fFactory = null;
            }
            return this.fFactory;
        }

        public boolean isEnabled(IStructuredSelection selection) {
            boolean enabled = false;
            if (selection == null || selection.isEmpty()) {
                return "org.eclipse.debug.ui.defaultDetailPaneFactory".equals(this.fConfigElement.getAttribute("id"));
            }
            Expression expression = this.getEnablementExpression();
            if (expression != null) {
                List list = selection.toList();
                EvaluationContext context = new EvaluationContext(null, (Object)list);
                context.addVariable("selection", (Object)list);
                enabled = this.evalEnablementExpression((IEvaluationContext)context, expression);
            } else {
                enabled = true;
            }
            return enabled;
        }

        private boolean evalEnablementExpression(IEvaluationContext context, Expression exp) {
            try {
                EvaluationResult result;
                if (exp != null && ((result = exp.evaluate(context)) == EvaluationResult.TRUE || result == EvaluationResult.NOT_LOADED)) {
                    return true;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
            return false;
        }

        private Expression getEnablementExpression() {
            if (this.fEnablementExpression == null) {
                try {
                    IConfigurationElement enablement;
                    IConfigurationElement[] elements = this.fConfigElement.getChildren("enablement");
                    IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
                    if (enablement != null) {
                        this.fEnablementExpression = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    this.fEnablementExpression = null;
                }
            }
            return this.fEnablementExpression;
        }
    }
}

