/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class ChmodAction
extends ProvisioningAction {
    public static final String ID = "chmod";

    public IStatus execute(Map parameters) {
        String targetFile;
        String targetDir = (String)parameters.get("targetDir");
        if (targetDir == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"targetDir", (Object)ID));
        }
        if (targetDir.equals("@artifact")) {
            try {
                targetDir = Util.resolveArtifactParam(parameters);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            File dir = new File(targetDir);
            if (!dir.isDirectory()) {
                return Util.createError(NLS.bind((String)Messages.artifact_not_directory, (Object)dir));
            }
        }
        if ((targetFile = (String)parameters.get("targetFile")) == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"targetFile", (Object)ID));
        }
        String permissions = (String)parameters.get("permissions");
        if (permissions == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"permissions", (Object)ID));
        }
        this.chmod(targetDir, targetFile, permissions);
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return Status.OK_STATUS;
    }

    private void chmod(String targetDir, String targetFile, String perms) {
        Runtime r = Runtime.getRuntime();
        try {
            r.exec(new String[]{ID, perms, String.valueOf(targetDir) + '/' + targetFile});
        }
        catch (IOException iOException) {}
    }
}

