/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpPreview;
import org.eclipse.jdt.internal.ui.preferences.cleanup.ICleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class CleanUpTabPage
extends ModifyDialogTabPage
implements ICleanUpTabPage {
    private Map fValues;
    private JavaPreview fCleanUpPreview;
    private boolean fIsSaveAction = false;
    int fCount = 0;
    int fSelectedCount = 0;

    public void setOptionsKind(int kind) {
        this.fIsSaveAction = kind == 2;
    }

    public void setWorkingValues(Map workingValues) {
        super.setWorkingValues(workingValues);
        this.fValues = workingValues;
    }

    public boolean isSaveAction() {
        return this.fIsSaveAction;
    }

    public int getCleanUpCount() {
        return this.fCount;
    }

    public int getSelectedCleanUpCount() {
        return this.fSelectedCount;
    }

    protected abstract ICleanUp[] createPreviewCleanUps(Map var1);

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fCleanUpPreview = new CleanUpPreview(parent, this.createPreviewCleanUps(this.fValues));
        return this.fCleanUpPreview;
    }

    protected void doUpdatePreview() {
        this.fCleanUpPreview.setWorkingValues(this.fValues);
        this.fCleanUpPreview.update();
    }

    protected void initializePage() {
        this.fCleanUpPreview.update();
    }

    protected void registerPreference(final ModifyDialogTabPage.CheckboxPreference preference) {
        ++this.fCount;
        preference.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                CleanUpTabPage.this.fSelectedCount = preference.getChecked() ? ++CleanUpTabPage.this.fSelectedCount : --CleanUpTabPage.this.fSelectedCount;
            }
        });
        if (preference.getChecked()) {
            ++this.fSelectedCount;
        }
    }

    protected void registerSlavePreference(ModifyDialogTabPage.CheckboxPreference master, ModifyDialogTabPage.RadioPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.registerPreference(master);
    }

    protected void registerSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.CheckboxPreference[] slaves) {
        this.internalRegisterSlavePreference(master, slaves);
        this.fCount += slaves.length;
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (master.getChecked()) {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            ++CleanUpTabPage.this.fSelectedCount;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < slaves.length) {
                        if (slaves[i].getChecked()) {
                            --CleanUpTabPage.this.fSelectedCount;
                        }
                        ++i;
                    }
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            final ModifyDialogTabPage.CheckboxPreference slave = slaves[i];
            slave.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    CleanUpTabPage.this.fSelectedCount = slave.getChecked() ? ++CleanUpTabPage.this.fSelectedCount : --CleanUpTabPage.this.fSelectedCount;
                }
            });
            ++i;
        }
        if (master.getChecked()) {
            i = 0;
            while (i < slaves.length) {
                if (slaves[i].getChecked()) {
                    ++this.fSelectedCount;
                }
                ++i;
            }
        }
    }

    private void internalRegisterSlavePreference(final ModifyDialogTabPage.CheckboxPreference master, final ModifyDialogTabPage.ButtonPreference[] slaves) {
        master.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(master.getChecked());
                    ++i;
                }
            }
        });
        int i = 0;
        while (i < slaves.length) {
            slaves[i].setEnabled(master.getChecked());
            ++i;
        }
    }

    protected void intent(Composite group) {
        Label l = new Label(group, 0);
        GridData gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(4);
        l.setLayoutData((Object)gd);
    }
}

