/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FilteredElementTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private String fInitialFilter = null;

    public FilteredElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    public void setInitialFilter(String initialFilter) {
        this.fInitialFilter = initialFilter;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        FilteredTreeWithFilter tree = new FilteredTreeWithFilter(parent, style, this.fInitialFilter);
        tree.setLayoutData(new GridData(1808));
        FilteredElementTreeSelectionDialog.applyDialogFont((Control)tree);
        TreeViewer viewer = tree.getViewer();
        SWTUtil.setAccessibilityText(viewer.getControl(), Strings.removeMnemonicIndicator(this.getMessage()));
        return viewer;
    }

    private static class FilteredTreeWithFilter
    extends FilteredTree {
        public FilteredTreeWithFilter(Composite parent, int treeStyle, String initialFilter) {
            super(parent, treeStyle, (PatternFilter)new MultiplePatternFilter());
            if (initialFilter != null) {
                this.setFilterText(initialFilter);
                this.textChanged();
            }
        }
    }

    private static class MultiplePatternFilter
    extends PatternFilter {
        private StringMatcher[] fMatchers;

        private MultiplePatternFilter() {
        }

        public void setPattern(String patternString) {
            super.setPattern(patternString);
            this.fMatchers = null;
            if (patternString != null && patternString.length() > 0) {
                ArrayList<StringMatcher> res = new ArrayList<StringMatcher>();
                StringTokenizer tok = new StringTokenizer(patternString, ",;");
                this.fMatchers = new StringMatcher[tok.countTokens()];
                int i = 0;
                while (i < this.fMatchers.length) {
                    String token = tok.nextToken().trim();
                    if (token.length() > 0) {
                        res.add(new StringMatcher(String.valueOf(token) + '*', true, false));
                    }
                    ++i;
                }
                if (!res.isEmpty()) {
                    this.fMatchers = res.toArray(new StringMatcher[res.size()]);
                }
            }
        }

        protected boolean wordMatches(String text) {
            if (text != null) {
                if (this.fMatchers == null || this.fMatchers.length == 0) {
                    return true;
                }
                int i = 0;
                while (i < this.fMatchers.length) {
                    if (this.fMatchers[i].match(text)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

