/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EclipseClasspath {
    protected List srcDirs = new ArrayList();
    protected List classDirs = new ArrayList();
    protected List inclusionLists = new ArrayList();
    protected List exclusionLists = new ArrayList();
    protected Map variable2valueMap = new LinkedHashMap();
    protected List rawClassPathEntries = new ArrayList();
    protected List rawClassPathEntriesAbsolute = new ArrayList();
    private IJavaProject project;
    private static Map userLibraryCache = new HashMap();

    public EclipseClasspath(IJavaProject project) throws JavaModelException {
        this.init(project, project.getRawClasspath());
    }

    public EclipseClasspath(IJavaProject project, ILaunchConfiguration conf, boolean bootstrap) throws CoreException {
        IRuntimeClasspathEntry[] runtimeEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)conf);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>(runtimeEntries.length);
        int i = 0;
        while (i < runtimeEntries.length) {
            IRuntimeClasspathEntry entry = runtimeEntries[i];
            if (bootstrap && entry.getClasspathProperty() == 2 || !bootstrap && entry.getClasspathProperty() != 2) {
                IClasspathEntry e;
                if (entry.getClass().getName().equals("org.eclipse.jdt.internal.launching.VariableClasspathEntry")) {
                    e = this.convertVariableClasspathEntry(entry);
                    if (e != null) {
                        classpathEntries.add(e);
                    }
                } else if (entry.getClass().getName().equals("org.eclipse.jdt.internal.launching.DefaultProjectClasspathEntry")) {
                    e = JavaCore.newProjectEntry((IPath)entry.getPath());
                    classpathEntries.add(e);
                } else if (entry.getClasspathEntry() != null) {
                    classpathEntries.add(entry.getClasspathEntry());
                }
            }
            ++i;
        }
        IClasspathEntry[] entries = classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
        this.init(project, entries);
    }

    private void init(IJavaProject javaProject, IClasspathEntry[] entries) throws JavaModelException {
        this.project = javaProject;
        this.handle(entries);
    }

    private void handle(IClasspathEntry[] entries) throws JavaModelException {
        int i = 0;
        while (i < entries.length) {
            this.handleSources(entries[i]);
            this.handleVariables(entries[i]);
            this.handleJars(entries[i]);
            this.handleLibraries(entries[i]);
            this.handleProjects(entries[i]);
            ++i;
        }
    }

    private void handleSources(IClasspathEntry entry) throws JavaModelException {
        String projectRoot = ExportUtil.getProjectRoot(this.project);
        String defaultClassDir = this.project.getOutputLocation().toString();
        String defaultClassDirAbsolute = ExportUtil.resolve(this.project.getOutputLocation());
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 3) {
            IPath srcDirPath = entry.getPath();
            IPath classDirPath = entry.getOutputLocation();
            String srcDir = this.handleLinkedResource(srcDirPath);
            ExportUtil.removeProjectRoot(srcDirPath != null ? srcDirPath.toString() : projectRoot, this.project.getProject());
            String classDir = ExportUtil.removeProjectRoot(classDirPath != null ? classDirPath.toString() : defaultClassDir, this.project.getProject());
            this.srcDirs.add(srcDir);
            this.classDirs.add(classDir);
            String classDirAbsolute = classDirPath != null ? ExportUtil.resolve(classDirPath) : defaultClassDirAbsolute;
            this.rawClassPathEntries.add(classDir);
            this.rawClassPathEntriesAbsolute.add(classDirAbsolute);
            IPath[] inclusions = entry.getInclusionPatterns();
            ArrayList<String> inclusionList = new ArrayList<String>();
            int j = 0;
            while (j < inclusions.length) {
                if (inclusions[j] != null) {
                    inclusionList.add(ExportUtil.removeProjectRoot(inclusions[j].toString(), this.project.getProject()));
                }
                ++j;
            }
            this.inclusionLists.add(inclusionList);
            IPath[] exclusions = entry.getExclusionPatterns();
            ArrayList<String> exclusionList = new ArrayList<String>();
            int j2 = 0;
            while (j2 < exclusions.length) {
                if (exclusions[j2] != null) {
                    exclusionList.add(ExportUtil.removeProjectRoot(exclusions[j2].toString(), this.project.getProject()));
                }
                ++j2;
            }
            this.exclusionLists.add(exclusionList);
        }
    }

    private String handleLinkedResource(IPath srcDirPath) {
        IFile file;
        String projectRoot = ExportUtil.getProjectRoot(this.project);
        String srcDir = ExportUtil.removeProjectRoot(srcDirPath != null ? srcDirPath.toString() : projectRoot, this.project.getProject());
        if (srcDirPath == null) {
            return srcDir;
        }
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(srcDirPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return srcDir;
        }
        if (file.isLinked()) {
            String pathVariable = file.getRawLocation().segment(0).toString();
            IPath pathVariableValue = file.getWorkspace().getPathVariableManager().getValue(pathVariable);
            if (pathVariableValue != null) {
                String pathVariableExtension = file.getRawLocation().segment(1).toString();
                String relativePath = ExportUtil.getRelativePath(pathVariableValue.toString(), projectRoot);
                this.variable2valueMap.put(String.valueOf(pathVariable) + ".pathvariable", relativePath);
                this.variable2valueMap.put(String.valueOf(srcDir) + ".link", "${" + pathVariable + ".pathvariable}/" + pathVariableExtension);
            } else {
                String relativePath = ExportUtil.getRelativePath("" + file.getLocation(), projectRoot);
                this.variable2valueMap.put(String.valueOf(srcDir) + ".link", relativePath);
            }
            srcDir = "${" + srcDir + ".link}";
        }
        return srcDir;
    }

    private void handleJars(IClasspathEntry entry) {
        if (entry.getContentKind() == 2 && entry.getEntryKind() == 1) {
            String jarFile = entry.getPath().toString();
            StringBuffer jarFileBuffer = new StringBuffer();
            StringBuffer jarFileAbsoluteBuffer = new StringBuffer();
            String jarFileAbsolute = ExportUtil.resolve(entry.getPath());
            if (jarFileAbsolute == null) {
                jarFileAbsolute = jarFile;
                if (this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                    jarFile = jarFileBuffer.toString();
                    jarFileAbsolute = jarFileAbsoluteBuffer.toString();
                }
            }
            String jarFileOld = jarFile;
            if ((jarFile = ExportUtil.removeProjectRoot(jarFile, this.project.getProject())).equals(jarFileOld) && this.handleSubProjectClassesDirectory(jarFile, jarFileBuffer, jarFileAbsoluteBuffer)) {
                jarFile = jarFileBuffer.toString();
                jarFileAbsolute = jarFileAbsoluteBuffer.toString();
            }
            this.rawClassPathEntries.add(jarFile);
            this.rawClassPathEntriesAbsolute.add(jarFileAbsolute);
        }
    }

    private boolean handleSubProjectClassesDirectory(String file, StringBuffer jarFile, StringBuffer jarFileAbsolute) {
        int i;
        String subproject;
        IJavaProject javaproject;
        if (file != null && file.indexOf(47) == 0 && (javaproject = ExportUtil.getJavaProjectByName(subproject = file.substring(1, i = (i = file.indexOf(47, 1)) != -1 ? i : file.length()))) != null) {
            jarFile.setLength(0);
            jarFileAbsolute.setLength(0);
            String location = String.valueOf(javaproject.getProject().getName()) + ".location";
            jarFileAbsolute.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), ExportUtil.getProjectRoot(javaproject)));
            jarFile.append(ExportUtil.replaceProjectRoot(file, javaproject.getProject(), "${" + location + "}"));
            String projectRoot = ExportUtil.getProjectRoot(this.project);
            String relativePath = ExportUtil.getRelativePath(ExportUtil.getProjectRoot(javaproject), projectRoot);
            this.variable2valueMap.put(location, relativePath);
            return true;
        }
        return false;
    }

    private void handleVariables(IClasspathEntry entry) {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 4) {
            IPath value;
            String e = entry.getPath().toString();
            int index = e.indexOf(47);
            if (index == -1) {
                index = e.indexOf(92);
            }
            String variable = e;
            String path = "";
            if (index != -1) {
                variable = e.substring(0, index);
                path = e.substring(index);
            }
            if ((value = JavaCore.getClasspathVariable((String)variable)) != null) {
                String projectRoot = ExportUtil.getProjectRoot(this.project);
                String relativePath = ExportUtil.getRelativePath(value.toString(), projectRoot);
                this.variable2valueMap.put(variable, relativePath);
            } else if (this.variable2valueMap.get(variable) == null) {
                this.variable2valueMap.put(variable, "");
            }
            this.rawClassPathEntriesAbsolute.add(value + path);
            this.rawClassPathEntries.add("${" + variable + "}" + path);
        }
    }

    private void handleLibraries(IClasspathEntry entry) throws JavaModelException {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 5) {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.project);
            if (container == null) {
                return;
            }
            String jar = entry.getPath().toString();
            if (!jar.startsWith(JavaRuntime.JRE_CONTAINER)) {
                if (jar.startsWith("org.eclipse.jdt.USER_LIBRARY")) {
                    String libraryName = container.getDescription();
                    String userlibraryRef = "${" + libraryName + ".userclasspath}";
                    if (container.getKind() == 2) {
                        userlibraryRef = "${" + libraryName + ".bootclasspath}";
                    }
                    userLibraryCache.put(userlibraryRef, container);
                    this.srcDirs.add(userlibraryRef);
                    this.classDirs.add(userlibraryRef);
                    this.rawClassPathEntries.add(userlibraryRef);
                    this.rawClassPathEntriesAbsolute.add(userlibraryRef);
                    this.inclusionLists.add(new ArrayList());
                    this.exclusionLists.add(new ArrayList());
                } else {
                    String libraryName = container.getDescription();
                    String pluginRef = "${" + libraryName + ".libraryclasspath}";
                    userLibraryCache.put(pluginRef, container);
                    this.srcDirs.add(pluginRef);
                    this.classDirs.add(pluginRef);
                    this.rawClassPathEntries.add(pluginRef);
                    this.rawClassPathEntriesAbsolute.add(pluginRef);
                    this.inclusionLists.add(new ArrayList());
                    this.exclusionLists.add(new ArrayList());
                }
            }
        }
    }

    private void handleProjects(IClasspathEntry entry) {
        if (entry.getContentKind() == 1 && entry.getEntryKind() == 2) {
            String subProjectRoot = entry.getPath().toString();
            IJavaProject subProject = ExportUtil.getJavaProject(subProjectRoot);
            if (subProject == null) {
                AntUIPlugin.log("project is not loaded in workspace: " + subProjectRoot, null);
                return;
            }
            String classpathRef = "${" + subProject.getProject().getName() + ".classpath}";
            this.srcDirs.add(classpathRef);
            this.classDirs.add(classpathRef);
            this.rawClassPathEntries.add(classpathRef);
            this.rawClassPathEntriesAbsolute.add(classpathRef);
            this.inclusionLists.add(new ArrayList());
            this.exclusionLists.add(new ArrayList());
        }
    }

    public static String getClasspath(IJavaProject project) throws CoreException {
        List items = EclipseClasspath.getClasspathList(project);
        return ExportUtil.toString(items, File.pathSeparator);
    }

    public static List getClasspathList(IJavaProject project) throws CoreException {
        String[] classpath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        return Arrays.asList(classpath);
    }

    public static boolean isReference(String s) {
        return EclipseClasspath.isProjectReference(s) || EclipseClasspath.isUserLibraryReference(s) || EclipseClasspath.isUserSystemLibraryReference(s) || EclipseClasspath.isLibraryReference(s);
    }

    public static boolean isProjectReference(String s) {
        return s.startsWith("${") && s.endsWith(".classpath}");
    }

    public static IJavaProject resolveProjectReference(String s) {
        String name = ExportUtil.removePrefixAndSuffix(s, "${", ".classpath}");
        return ExportUtil.getJavaProjectByName(name);
    }

    public static boolean isUserLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".userclasspath}");
    }

    public static boolean isUserSystemLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".bootclasspath}");
    }

    public static boolean isLibraryReference(String s) {
        return s.startsWith("${") && s.endsWith(".libraryclasspath}");
    }

    public static IClasspathContainer resolveUserLibraryReference(String s) {
        return (IClasspathContainer)userLibraryCache.get(s);
    }

    public static boolean isLinkedResource(String s) {
        return s.startsWith("${") && s.endsWith(".link}");
    }

    public static String getLinkedResourceName(String s) {
        return ExportUtil.removePrefixAndSuffix(s, "${", ".link}");
    }

    public String resolveLinkedResource(String s) {
        String suffix;
        String name = ExportUtil.removePrefixAndSuffix(s, "${", "}");
        String value = (String)this.variable2valueMap.get(name);
        int i = value.indexOf(suffix = ".pathvariable}");
        if (i != -1) {
            String pathVariable = value.substring(0, i + suffix.length() - 1);
            pathVariable = ExportUtil.removePrefix(pathVariable, "${");
            return String.valueOf((String)this.variable2valueMap.get(pathVariable)) + value.substring(i + suffix.length());
        }
        return value;
    }

    private IClasspathEntry convertVariableClasspathEntry(IRuntimeClasspathEntry entry) {
        try {
            Document doc = ExportUtil.parseXmlString(entry.getMemento());
            Element element = (Element)doc.getElementsByTagName("memento").item(0);
            String variableString = element.getAttribute("variableString");
            ExportUtil.addVariable(this.variable2valueMap, variableString, ExportUtil.getProjectRoot(this.project));
            variableString = ExportUtil.removePrefix(variableString, "${");
            int i = variableString.indexOf(125);
            if (i != -1) {
                variableString = String.valueOf(variableString.substring(0, i)) + variableString.substring(i + 1);
            }
            Path path = new Path(variableString);
            return JavaCore.newVariableEntry((IPath)path, null, null);
        }
        catch (Exception e) {
            AntUIPlugin.log(e);
            return null;
        }
    }
}

