/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;

public class Profile
implements IQueryable,
IProfile {
    private final String profileId;
    private Profile parentProfile;
    private List subProfileIds;
    private static final String[] noSubProfiles = new String[0];
    private OrderedProperties storage = new OrderedProperties();
    private Set ius = new HashSet();
    private Map iuProperties = new HashMap();
    private boolean changed = false;
    private long timestamp;
    private ISurrogateProfileHandler surrogateProfileHandler;

    public Profile(String profileId, Profile parent, Map properties) {
        if (profileId == null || profileId.length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Null_Profile_Id, null));
        }
        this.profileId = profileId;
        this.setParent(parent);
        if (properties != null) {
            this.storage.putAll(properties);
        }
    }

    public String getProfileId() {
        return this.profileId;
    }

    public IProfile getParentProfile() {
        return this.parentProfile;
    }

    public void setParent(Profile profile) {
        if (profile == this.parentProfile) {
            return;
        }
        if (this.parentProfile != null) {
            this.parentProfile.removeSubProfile(this.profileId);
        }
        this.parentProfile = profile;
        if (this.parentProfile != null) {
            this.parentProfile.addSubProfile(this.profileId);
        }
    }

    public boolean isRootProfile() {
        return this.parentProfile == null;
    }

    public void addSubProfile(String subProfileId) throws IllegalArgumentException {
        if (this.subProfileIds == null) {
            this.subProfileIds = new ArrayList();
        }
        if (!this.subProfileIds.contains(subProfileId)) {
            this.subProfileIds.add(subProfileId);
        }
    }

    public void removeSubProfile(String subProfileId) throws IllegalArgumentException {
        if (this.subProfileIds != null) {
            this.subProfileIds.remove(subProfileId);
        }
    }

    public boolean hasSubProfiles() {
        return this.subProfileIds == null || this.subProfileIds.isEmpty();
    }

    public String[] getSubProfileIds() {
        if (this.subProfileIds == null) {
            return noSubProfiles;
        }
        return this.subProfileIds.toArray(new String[this.subProfileIds.size()]);
    }

    public String getProperty(String key) {
        String value = this.storage.getProperty(key);
        if (value == null && this.parentProfile != null) {
            value = this.parentProfile.getProperty(key);
        }
        return value;
    }

    public String getLocalProperty(String key) {
        return this.storage.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.storage.setProperty(key, value);
        this.changed = true;
    }

    public void removeProperty(String key) {
        this.storage.remove((Object)key);
        this.changed = true;
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return query.perform(this.ius.iterator(), collector);
    }

    public Collector available(Query query, Collector collector, IProgressMonitor monitor) {
        if (this.surrogateProfileHandler != null) {
            return this.surrogateProfileHandler.queryProfile(this, query, collector, monitor);
        }
        return query.perform(this.ius.iterator(), collector);
    }

    public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
        OrderedProperties properties = (OrderedProperties)this.iuProperties.get(Profile.createIUKey(iu));
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    public String setInstallableUnitProperty(IInstallableUnit iu, String key, String value) {
        String iuKey = Profile.createIUKey(iu);
        OrderedProperties properties = (OrderedProperties)this.iuProperties.get(iuKey);
        if (properties == null) {
            properties = new OrderedProperties();
            this.iuProperties.put(iuKey, properties);
        }
        this.changed = true;
        return (String)properties.setProperty(key, value);
    }

    public String removeInstallableUnitProperty(IInstallableUnit iu, String key) {
        String iuKey = Profile.createIUKey(iu);
        OrderedProperties properties = (OrderedProperties)this.iuProperties.get(iuKey);
        if (properties == null) {
            return null;
        }
        String oldValue = (String)properties.remove((Object)key);
        if (properties.isEmpty()) {
            this.iuProperties.remove(iuKey);
        }
        this.changed = true;
        return oldValue;
    }

    private static String createIUKey(IInstallableUnit iu) {
        return String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
    }

    public Map getLocalProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.storage);
    }

    public Map getProperties() {
        if (this.parentProfile == null) {
            return this.getLocalProperties();
        }
        HashMap properties = new HashMap(this.parentProfile.getProperties());
        properties.putAll(this.storage);
        return OrderedProperties.unmodifiableProperties(properties);
    }

    public void addProperties(Map properties) {
        this.storage.putAll(properties);
        this.changed = true;
    }

    public void addInstallableUnit(IInstallableUnit iu) {
        if (this.ius.contains(iu = iu.unresolved())) {
            return;
        }
        this.ius.add(iu);
        this.changed = true;
    }

    public void removeInstallableUnit(IInstallableUnit iu) {
        iu = iu.unresolved();
        this.ius.remove(iu);
        this.changed = true;
    }

    public Map getInstallableUnitProperties(IInstallableUnit iu) {
        OrderedProperties properties = (OrderedProperties)this.iuProperties.get(Profile.createIUKey(iu));
        if (properties == null) {
            properties = new OrderedProperties();
        }
        return OrderedProperties.unmodifiableProperties((Map)properties);
    }

    public void clearLocalProperties() {
        this.storage.clear();
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean isChanged) {
        this.changed = isChanged;
    }

    public void clearInstallableUnits() {
        this.ius.clear();
        this.iuProperties.clear();
        this.changed = true;
    }

    public Profile snapshot() {
        Iterator it;
        Profile parentSnapshot = null;
        if (this.parentProfile != null) {
            parentSnapshot = this.parentProfile.snapshot();
        }
        Profile snapshot = new Profile(this.profileId, parentSnapshot, (Map)this.storage);
        if (this.surrogateProfileHandler != null) {
            snapshot.setSurrogateProfileHandler(this.surrogateProfileHandler);
        }
        snapshot.setTimestamp(this.timestamp);
        if (this.subProfileIds != null) {
            it = this.subProfileIds.iterator();
            while (it.hasNext()) {
                String subProfileId = (String)it.next();
                snapshot.addSubProfile(subProfileId);
            }
        }
        it = this.ius.iterator();
        while (it.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)it.next();
            snapshot.addInstallableUnit(iu);
            Map properties = this.getInstallableUnitProperties(iu);
            if (properties == null) continue;
            snapshot.addInstallableUnitProperties(iu, properties);
        }
        snapshot.setChanged(false);
        return snapshot;
    }

    public void addInstallableUnitProperties(IInstallableUnit iu, Map properties) {
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setInstallableUnitProperty(iu, key, value);
        }
    }

    public void clearInstallableUnitProperties(IInstallableUnit iu) {
        this.iuProperties.remove(Profile.createIUKey(iu));
        this.changed = true;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long millis) {
        this.timestamp = millis;
    }

    public void setSurrogateProfileHandler(ISurrogateProfileHandler surrogateProfileHandler) {
        this.surrogateProfileHandler = surrogateProfileHandler;
    }
}

