/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;

public class EngineSession {
    private List phaseActionRecordsPairs = new ArrayList();
    private Phase currentPhase;
    private List currentActionRecords;
    private ActionsRecord currentRecord;
    private IProfile profile;
    private ProvisioningContext context;

    public EngineSession(IProfile profile, ProvisioningContext context) {
        this.profile = profile;
        this.context = context;
    }

    public void commit() {
        this.phaseActionRecordsPairs.clear();
    }

    public MultiStatus rollback() {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        if (this.currentPhase != null) {
            this.rollBackPhase(this.currentPhase, this.currentActionRecords);
            this.currentPhase = null;
            this.currentActionRecords = null;
            this.currentRecord = null;
        }
        ListIterator it = this.phaseActionRecordsPairs.listIterator(this.phaseActionRecordsPairs.size());
        while (it.hasPrevious()) {
            Object[] pair = (Object[])it.previous();
            Phase phase = (Phase)pair[0];
            List actionRecords = (List)pair[1];
            this.rollBackPhase(phase, actionRecords);
        }
        this.phaseActionRecordsPairs.clear();
        return result;
    }

    private MultiStatus rollBackPhase(Phase phase, List actionRecords) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        if (phase != this.currentPhase) {
            phase.prePerform(result, this.profile, this.context, (IProgressMonitor)new NullProgressMonitor());
        }
        ListIterator it = actionRecords.listIterator(actionRecords.size());
        while (it.hasPrevious()) {
            ActionsRecord record = (ActionsRecord)it.previous();
            ProvisioningAction[] actions = record.actions.toArray(new ProvisioningAction[record.actions.size()]);
            phase.undo(result, this, this.profile, record.operand, actions, this.context);
        }
        phase.postPerform(result, this.profile, this.context, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    void recordPhaseStart(Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(Messages.null_phase);
        }
        if (this.currentPhase != null) {
            throw new IllegalStateException(Messages.phase_started);
        }
        this.currentPhase = phase;
        this.currentActionRecords = new ArrayList();
    }

    void recordPhaseEnd(Phase phase) {
        if (this.currentPhase == null) {
            throw new IllegalStateException(Messages.phase_not_started);
        }
        if (this.currentPhase != phase) {
            throw new IllegalArgumentException(Messages.not_current_phase);
        }
        this.phaseActionRecordsPairs.add(new Object[]{this.currentPhase, this.currentActionRecords});
        this.currentPhase = null;
        this.currentActionRecords = null;
        this.currentRecord = null;
    }

    void recordAction(ProvisioningAction action, Operand operand) {
        if (action == null || operand == null) {
            throw new IllegalArgumentException(Messages.action_or_iu_operand_null);
        }
        if (this.currentRecord == null || operand != this.currentRecord.operand) {
            this.currentRecord = new ActionsRecord(operand);
            this.currentActionRecords.add(this.currentRecord);
        }
        this.currentRecord.actions.add(action);
    }

    private static class ActionsRecord {
        Operand operand;
        List actions = new ArrayList();

        ActionsRecord(Operand operand) {
            this.operand = operand;
        }
    }
}

