/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.soc.ide4edu.ui.view.NewJavaLiteProjectWizardPageOne;
import org.eclipse.soc.ide4edu.ui.view.NewJavaLiteProjectWizardPageTwo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class NewJavaLiteProjectWizardPageTwo
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private NewJavaLiteProjectWizardPageOne fFirstPage = null;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;
    private HashSet fOrginalFolders;

    public NewJavaLiteProjectWizardPageTwo(NewJavaLiteProjectWizardPageOne newJavaLiteProjectWizardPageOne) {
        this.fFirstPage = newJavaLiteProjectWizardPageOne;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    protected final boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && this.fCurrProject == null;
        if (bl) {
            if (bl2) {
                this.createProvisonalProject();
            }
        } else if (this.getContainer().getCurrentPage() == this.fFirstPage) {
            this.removeProvisonalProject();
        }
        super.setVisible(bl);
        if (bl2) {
            this.setFocus();
        }
    }

    private boolean hasExistingContent(URI uRI) throws CoreException {
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        return iFileStore.fetchInfo().exists();
    }

    private IStatus changeToNewProject() {
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus;
            final /* synthetic */ NewJavaLiteProjectWizardPageTwo this$0;

            UpdateRunnable(NewJavaLiteProjectWizardPageTwo newJavaLiteProjectWizardPageTwo) {
                this.this$0 = newJavaLiteProjectWizardPageTwo;
                this.infoStatus = Status.OK_STATUS;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (NewJavaLiteProjectWizardPageTwo.access$0(this.this$0) == null) {
                            NewJavaLiteProjectWizardPageTwo.access$1(this.this$0, CoreUtility.enableAutoBuild((boolean)false));
                        }
                        this.infoStatus = NewJavaLiteProjectWizardPageTwo.access$2(this.this$0, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        }
        UpdateRunnable updateRunnable = new UpdateRunnable(this);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)updateRunnable));
            return updateRunnable.infoStatus;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.NewJavaProjectWizardPageTwo_error_title;
            String string2 = NewWizardMessages.NewJavaProjectWizardPageTwo_error_message;
            ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)this.getShell(), (String)string, (String)string2);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private static URI getRealLocation(String string, URI uRI) {
        if (uRI == null) {
            try {
                URI uRI2 = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                uRI = new URI(uRI2.getScheme(), null, Path.fromPortableString((String)uRI2.getPath()).append(string).toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Assert.isTrue((boolean)false, (String)"Can't happen");
            }
        }
        return uRI;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IStatus updateProject(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        IStatus iStatus = StatusInfo.OK_STATUS;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_initialize, 7);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String string = this.fFirstPage.getProjectName();
            this.fCurrProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            this.fCurrProjectLocation = this.fFirstPage.getProjectLocationURI();
            URI uRI = NewJavaLiteProjectWizardPageTwo.getRealLocation(string, this.fCurrProjectLocation);
            this.fKeepContent = this.hasExistingContent(uRI);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fKeepContent) {
                this.rememberExistingFiles(uRI);
                this.rememberExisitingFolders(uRI);
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                NewJavaLiteProjectWizardPageTwo.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() != 567) throw coreException;
                iStatus = new StatusInfo(1, Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageTwo_DeleteCorruptProjectFile_message, (Object)coreException.getLocalizedMessage()));
                this.deleteProjectFile(uRI);
                if (this.fCurrProject.exists()) {
                    this.fCurrProject.delete(true, null);
                }
                NewJavaLiteProjectWizardPageTwo.createProject((IProject)this.fCurrProject, (URI)this.fCurrProjectLocation, null);
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.initializeBuildPath(JavaCore.create((IProject)this.fCurrProject), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
        return iStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeBuildPath(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_monitor_init_build_path, 2);
        try {
            IPath iPath;
            IClasspathEntry[] iClasspathEntryArray;
            block12: {
                IProject iProject;
                block11: {
                    iClasspathEntryArray = null;
                    iPath = null;
                    iProject = iJavaProject.getProject();
                    if (!this.fKeepContent) break block11;
                    if (!iProject.getFile(FILENAME_CLASSPATH).exists()) {
                        ClassPathDetector classPathDetector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                        iClasspathEntryArray = classPathDetector.getClasspath();
                        iPath = classPathDetector.getOutputLocation();
                        if (iClasspathEntryArray.length == 0) {
                            iClasspathEntryArray = null;
                        }
                        break block12;
                    } else {
                        iProgressMonitor.worked(2);
                    }
                    break block12;
                }
                ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                IWorkspaceRoot iWorkspaceRoot = iProject.getWorkspace().getRoot();
                IClasspathEntry[] iClasspathEntryArray2 = this.fFirstPage.getSourceClasspathEntries();
                int n = 0;
                while (true) {
                    if (n >= iClasspathEntryArray2.length) {
                        arrayList.addAll(Arrays.asList(this.fFirstPage.getDefaultClasspathEntries()));
                        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                        iPath = this.fFirstPage.getOutputLocation();
                        if (iPath.segmentCount() <= 1) break;
                        IFolder iFolder = iWorkspaceRoot.getFolder(iPath);
                        CoreUtility.createDerivedFolder((IFolder)iFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        break;
                    }
                    IPath iPath2 = iClasspathEntryArray2[n].getPath();
                    if (iPath2.segmentCount() > 1) {
                        IFolder iFolder = iWorkspaceRoot.getFolder(iPath2);
                        CoreUtility.createFolder((IFolder)iFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    arrayList.add(iClasspathEntryArray2[n]);
                    ++n;
                }
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(iJavaProject, iPath, iClasspathEntryArray, false);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var12_16 = null;
        }
        iProgressMonitor.done();
    }

    private void deleteProjectFile(URI uRI) throws CoreException {
        IFileStore iFileStore;
        IFileStore iFileStore2 = EFS.getStore((URI)uRI);
        if (iFileStore2.fetchInfo().exists() && (iFileStore = iFileStore2.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            iFileStore.delete(0, null);
        }
    }

    private void rememberExisitingFolders(URI uRI) {
        this.fOrginalFolders = new HashSet();
        try {
            IFileStore[] iFileStoreArray = EFS.getStore((URI)uRI).childStores(0, null);
            int n = 0;
            while (n < iFileStoreArray.length) {
                IFileStore iFileStore = iFileStoreArray[n];
                IFileInfo iFileInfo = iFileStore.fetchInfo();
                if (iFileInfo.isDirectory() && iFileInfo.exists() && !this.fOrginalFolders.contains(iFileStore.getName())) {
                    this.fOrginalFolders.add(iFileStore);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log((Throwable)coreException);
        }
    }

    private void restoreExistingFolders(URI uRI) {
        try {
            IFileStore iFileStore;
            IFileStore[] iFileStoreArray = EFS.getStore((URI)uRI).childStores(0, null);
            int n = 0;
            while (n < iFileStoreArray.length) {
                iFileStore = iFileStoreArray[n];
                IFileInfo iFileInfo = iFileStore.fetchInfo();
                if (iFileInfo.isDirectory() && iFileInfo.exists() && !this.fOrginalFolders.contains(iFileStore)) {
                    iFileStore.delete(0, null);
                    this.fOrginalFolders.remove(iFileStore);
                }
                ++n;
            }
            Iterator iterator = this.fOrginalFolders.iterator();
            while (iterator.hasNext()) {
                iFileStore = (IFileStore)iterator.next();
                iFileStore.mkdir(0, null);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log((Throwable)coreException);
        }
    }

    private void rememberExistingFiles(URI uRI) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        if (iFileStore.fetchInfo().exists()) {
            IFileStore iFileStore2;
            IFileStore iFileStore3 = iFileStore.getChild(FILENAME_PROJECT);
            if (iFileStore3.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(iFileStore3, "project-desc");
            }
            if ((iFileStore2 = iFileStore.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(iFileStore2, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore;
        int n = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        iProgressMonitor.beginTask("", n);
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(FILENAME_PROJECT);
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.NewJavaProjectWizardPageTwo_problem_restore_project, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(FILENAME_CLASSPATH);
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.NewJavaProjectWizardPageTwo_problem_restore_classpath, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore iFileStore, String string) throws CoreException {
        try {
            File file = File.createTempFile("eclipse-" + string, ".bak");
            this.copyFile(iFileStore, file);
            return file;
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageTwo_problem_backup, (Object)string), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore iFileStore, File file) throws IOException, CoreException {
        InputStream inputStream = iFileStore.openInputStream(0, null);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.copyFile(inputStream, fileOutputStream);
    }

    private void copyFile(File file, IFileStore iFileStore, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = iFileStore.openOutputStream(0, iProgressMonitor);
        this.copyFile(fileInputStream, outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                inputStream.close();
                Object var7_11 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                outputStream.close();
                throw throwable2;
            }
            outputStream.close();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var7_12 = null;
            outputStream.close();
            throw throwable;
        }
        inputStream.close();
        Object var7_13 = null;
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFinish(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        try {
            String string;
            iProgressMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            if (!this.fKeepContent && (string = this.fFirstPage.getCompilerCompliance()) != null) {
                IJavaProject iJavaProject = JavaCore.create((IProject)this.fCurrProject);
                Map map = iJavaProject.getOptions(false);
                JavaModelUtil.setCompilanceOptions((Map)map, (String)string);
                JavaModelUtil.setDefaultClassfileOptions((Map)map, (String)string);
                iJavaProject.setOptions(map);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild == null) throw throwable;
            CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
            this.fIsAutobuild = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
        this.fCurrProject = null;
        if (this.fIsAutobuild == null) return;
        CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
        this.fIsAutobuild = null;
    }

    protected IProject createProvisonalProject() {
        IStatus iStatus = this.changeToNewProject();
        if (iStatus != null && !iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewJavaProjectWizardPageTwo_error_title, null, (IStatus)iStatus);
        }
        return this.fCurrProject;
    }

    protected void removeProvisonalProject() {
        if (!this.fCurrProject.exists()) {
            this.fCurrProject = null;
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                NewJavaLiteProjectWizardPageTwo.this.doRemoveProject(iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(iRunnableWithProgress));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.NewJavaProjectWizardPageTwo_error_remove_title;
            String string2 = NewWizardMessages.NewJavaProjectWizardPageTwo_error_remove_message;
            ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)this.getShell(), (String)string, (String)string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doRemoveProject(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        boolean bl;
        boolean bl2 = bl = this.fCurrProjectLocation == null;
        if (iProgressMonitor == null || bl) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(NewWizardMessages.NewJavaProjectWizardPageTwo_operation_remove, 3);
        try {
            try {
                try {
                    boolean bl3;
                    URI uRI = this.fCurrProject.getLocationURI();
                    boolean bl4 = bl3 = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    if (!bl3) {
                        this.restoreExistingFolders(uRI);
                    }
                    this.fCurrProject.delete(bl3, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    this.restoreExistingFiles(uRI, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                    this.fIsAutobuild = null;
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    CoreUtility.enableAutoBuild((boolean)this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            iProgressMonitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        iProgressMonitor.done();
        this.fCurrProject = null;
        this.fKeepContent = false;
    }

    public void performCancel() {
        if (this.fCurrProject != null) {
            this.removeProvisonalProject();
        }
    }

    static /* synthetic */ Boolean access$0(NewJavaLiteProjectWizardPageTwo newJavaLiteProjectWizardPageTwo) {
        return newJavaLiteProjectWizardPageTwo.fIsAutobuild;
    }

    static /* synthetic */ void access$1(NewJavaLiteProjectWizardPageTwo newJavaLiteProjectWizardPageTwo, Boolean bl) {
        newJavaLiteProjectWizardPageTwo.fIsAutobuild = bl;
    }

    static /* synthetic */ IStatus access$2(NewJavaLiteProjectWizardPageTwo newJavaLiteProjectWizardPageTwo, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        return newJavaLiteProjectWizardPageTwo.updateProject(iProgressMonitor);
    }
}

