/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewLitePackageWizardPage
extends NewContainerWizardPage {
    private static final String PAGE_NAME = "NewPackageWizardPage";
    private static final String PACKAGE = "NewPackageWizardPage.package";
    private StringDialogField fPackageDialogField;
    private IStatus fPackageStatus;
    private IPackageFragment fCreatedPackageFragment;

    public NewLitePackageWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewPackageWizardPage_title);
        this.setDescription(NewWizardMessages.NewPackageWizardPage_description);
        this.fCreatedPackageFragment = null;
        PackageFieldAdapter packageFieldAdapter = new PackageFieldAdapter();
        this.fPackageDialogField = new StringDialogField();
        this.fPackageDialogField.setDialogFieldListener((IDialogFieldListener)packageFieldAdapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.NewPackageWizardPage_package_label);
        this.fPackageStatus = new StatusInfo();
    }

    public void init(IStructuredSelection iStructuredSelection) {
        IPackageFragment iPackageFragment;
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        String string = "";
        if (iJavaElement != null && (iPackageFragment = (IPackageFragment)iJavaElement.getAncestor(4)) != null && !iPackageFragment.isDefaultPackage()) {
            string = iPackageFragment.getElementName();
        }
        this.setPackageText(string, true);
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        int n = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(NewWizardMessages.NewPackageWizardPage_info);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createPackageControls(composite2, n);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.jdt.ui.new_package_wizard_page_context");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fPackageDialogField.setFocus();
    }

    private void createPackageControls(Composite composite, int n) {
        this.fPackageDialogField.doFillIntoGrid(composite, n - 1);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace((Composite)composite);
        TextFieldNavigationHandler.install((Text)text);
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        if (string == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    private IStatus validatePackageName(String string) {
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject == null || !iJavaProject.exists()) {
            return JavaConventions.validatePackageName((String)string, (String)"1.3", (String)"1.3");
        }
        String string2 = iJavaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String string3 = iJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validatePackageName((String)string, (String)string2, (String)string3);
    }

    private IStatus packageChanged() {
        IStatus iStatus;
        StatusInfo statusInfo = new StatusInfo();
        String string = this.getPackageText();
        if (string.length() > 0) {
            iStatus = this.validatePackageName(string);
            if (iStatus.getSeverity() == 4) {
                statusInfo.setError(Messages.format((String)NewWizardMessages.NewPackageWizardPage_error_InvalidPackageName, (Object)iStatus.getMessage()));
                return statusInfo;
            }
            if (iStatus.getSeverity() == 2) {
                statusInfo.setWarning(Messages.format((String)NewWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, (Object)iStatus.getMessage()));
            }
        } else {
            statusInfo.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
            return statusInfo;
        }
        iStatus = this.getPackageFragmentRoot();
        if (iStatus != null && iStatus.getJavaProject().exists()) {
            IPackageFragment iPackageFragment = iStatus.getPackageFragment(string);
            try {
                Object object;
                IPath iPath = iStatus.getPath();
                IPath iPath2 = iStatus.getJavaProject().getOutputLocation();
                if (iPath.isPrefixOf(iPath2) && !iPath.equals((Object)iPath2) && iPath2.isPrefixOf(object = iPackageFragment.getPath())) {
                    statusInfo.setError(NewWizardMessages.NewPackageWizardPage_error_IsOutputFolder);
                    return statusInfo;
                }
                if (iPackageFragment.exists()) {
                    if (iPackageFragment.containsJavaResources() || !iPackageFragment.hasSubpackages()) {
                        statusInfo.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExists);
                    } else {
                        statusInfo.setError(NewWizardMessages.NewPackageWizardPage_error_PackageNotShown);
                    }
                } else {
                    IFileStore iFileStore;
                    object = iPackageFragment.getResource().getLocationURI();
                    if (object != null && (iFileStore = EFS.getStore((URI)object)).fetchInfo().exists()) {
                        statusInfo.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase);
                    }
                }
            }
            catch (CoreException coreException) {
                JavaPlugin.log((Throwable)coreException);
            }
        }
        return statusInfo;
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public void setPackageText(String string, boolean bl) {
        this.fPackageDialogField.setText(string);
        this.fPackageDialogField.setEnabled(bl);
    }

    public IResource getModifiedResource() {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot != null) {
            return iPackageFragmentRoot.getPackageFragment(this.getPackageText()).getResource();
        }
        return null;
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    NewLitePackageWizardPage.this.createPackage(iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    public IPackageFragment getNewPackageFragment() {
        return this.fCreatedPackageFragment;
    }

    public void createPackage(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        String string = this.getPackageText();
        this.fCreatedPackageFragment = iPackageFragmentRoot.createPackageFragment(string, true, iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private class PackageFieldAdapter
    implements IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewLitePackageWizardPage.this.fPackageStatus = NewLitePackageWizardPage.this.packageChanged();
            NewLitePackageWizardPage.this.handleFieldChanged(NewLitePackageWizardPage.PACKAGE);
        }
    }
}

