/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.util.NLS;

public class FileDownloadRequest
extends ArtifactRequest {
    public static final FileDownloadRequest[] NO_REQUEST = new FileDownloadRequest[0];
    private File destination;

    public FileDownloadRequest(IArtifactKey downloadKey, IPath downloadPath) {
        super(downloadKey);
        this.destination = downloadPath.toFile();
    }

    public void perform(IProgressMonitor monitor) {
        try {
            OutputStream destinationStream = null;
            try {
                destinationStream = new BufferedOutputStream(new FileOutputStream(this.destination));
                this.setResult(this.source.getArtifact(this.descriptor, destinationStream, null));
            }
            finally {
                if (destinationStream != null) {
                    destinationStream.close();
                }
            }
        }
        catch (IOException e) {
            this.setResult((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.FileDownloadError, (Object)this.descriptor, (Object)this.destination), (Throwable)e));
        }
    }
}

