/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.Arrays;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class SignatureUtil {
    private static final String NULL_TYPE_SIGNATURE = "Tnull;";
    private static final char[] NULL_TYPE_SIGNATURE_ARRAY = "Tnull;".toCharArray();
    private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
    private static final char[] OBJECT_SIGNATURE_ARRAY = "Ljava.lang.Object;".toCharArray();

    private SignatureUtil() {
    }

    public static boolean isJavaLangObject(String signature) {
        return OBJECT_SIGNATURE.equals(signature);
    }

    public static String getUpperBound(String signature) {
        return String.valueOf(SignatureUtil.getUpperBound(signature.toCharArray()));
    }

    public static char[] getUpperBound(char[] signature) {
        if (signature.length < 1) {
            return signature;
        }
        if (signature[0] == '*') {
            return OBJECT_SIGNATURE_ARRAY;
        }
        int superIndex = SignatureUtil.indexOf(signature, '-');
        if (superIndex == 0) {
            return OBJECT_SIGNATURE_ARRAY;
        }
        if (superIndex != -1) {
            char afterSuper = signature[superIndex + 1];
            if (afterSuper == '*') {
                char[] type = new char[signature.length - 1];
                System.arraycopy(signature, 0, type, 0, superIndex);
                type[superIndex] = 42;
                System.arraycopy(signature, superIndex + 2, type, superIndex + 1, signature.length - superIndex - 2);
                return SignatureUtil.getUpperBound(type);
            }
            if (afterSuper == '+') {
                int typeEnd = SignatureUtil.typeEnd(signature, superIndex + 1);
                char[] type = new char[signature.length - (typeEnd - superIndex - 1)];
                System.arraycopy(signature, 0, type, 0, superIndex);
                type[superIndex] = 42;
                System.arraycopy(signature, typeEnd, type, superIndex + 1, signature.length - typeEnd);
                return SignatureUtil.getUpperBound(type);
            }
        }
        if (signature[0] == '+') {
            char[] type = new char[signature.length - 1];
            System.arraycopy(signature, 1, type, 0, signature.length - 1);
            return type;
        }
        return signature;
    }

    public static String getLowerBound(String signature) {
        return String.valueOf(SignatureUtil.getLowerBound(signature.toCharArray()));
    }

    public static char[] getLowerBound(char[] signature) {
        char afterSuper;
        if (signature.length < 1) {
            return signature;
        }
        if (signature.length == 1 && signature[0] == '*') {
            return signature;
        }
        int superIndex = SignatureUtil.indexOf(signature, '+');
        if (superIndex == 0) {
            return NULL_TYPE_SIGNATURE_ARRAY;
        }
        if (superIndex != -1 && ((afterSuper = signature[superIndex + 1]) == '*' || afterSuper == '+')) {
            return NULL_TYPE_SIGNATURE_ARRAY;
        }
        char[][] typeArguments = Signature.getTypeArguments((char[])signature);
        int i = 0;
        while (i < typeArguments.length) {
            if (Arrays.equals(typeArguments[i], NULL_TYPE_SIGNATURE_ARRAY)) {
                return NULL_TYPE_SIGNATURE_ARRAY;
            }
            ++i;
        }
        if (signature[0] == '-') {
            char[] type = new char[signature.length - 1];
            System.arraycopy(signature, 1, type, 0, signature.length - 1);
            return type;
        }
        return signature;
    }

    private static int indexOf(char[] signature, char ch) {
        int i = 0;
        while (i < signature.length) {
            if (signature[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String stripSignatureToFQN(String signature) throws IllegalArgumentException {
        signature = Signature.getTypeErasure((String)signature);
        signature = Signature.getElementType((String)signature);
        return Signature.toString((String)signature);
    }

    public static String qualifySignature(String signature, IType context) {
        if (context == null) {
            return signature;
        }
        String qualifier = Signature.getSignatureQualifier((String)signature);
        if (qualifier.length() > 0) {
            return signature;
        }
        String elementType = Signature.getElementType((String)signature);
        String erasure = Signature.getTypeErasure((String)elementType);
        String simpleName = Signature.getSignatureSimpleName((String)erasure);
        String genericSimpleName = Signature.getSignatureSimpleName((String)elementType);
        int dim = Signature.getArrayCount((String)signature);
        try {
            String[][] strings = context.resolveType(simpleName);
            if (strings != null && strings.length > 0) {
                qualifier = strings[0][0];
            }
        }
        catch (JavaModelException javaModelException) {}
        if (qualifier.length() == 0) {
            return signature;
        }
        String qualifiedType = Signature.toQualifiedName((String[])new String[]{qualifier, genericSimpleName});
        String qualifiedSignature = Signature.createTypeSignature((String)qualifiedType, (boolean)true);
        String newSignature = Signature.createArraySignature((String)qualifiedSignature, (int)dim);
        return newSignature;
    }

    public static char[] unboundedSignature(char[] signature) {
        if (signature == null || signature.length < 2) {
            return signature;
        }
        signature = SignatureUtil.fix83600(signature);
        StringBuffer res = new StringBuffer("(");
        char[][] parameters = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameters.length) {
            char[] param = parameters[i];
            res.append(SignatureUtil.getLowerBound(param));
            ++i;
        }
        res.append(')');
        res.append(SignatureUtil.getUpperBound(Signature.getReturnType((char[])signature)));
        return res.toString().toCharArray();
    }

    public static char[] fix83600(char[] signature) {
        if (signature == null || signature.length < 2) {
            return signature;
        }
        return Signature.removeCapture((char[])signature);
    }

    private static int typeEnd(char[] signature, int pos) {
        int depth = 0;
        while (pos < signature.length) {
            switch (signature[pos]) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    --depth;
                    break;
                }
                case ';': {
                    if (depth != 0) break;
                    return pos + 1;
                }
            }
            ++pos;
        }
        return pos + 1;
    }
}

