/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.javadocexport.ContributedJavadocWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocSpecificsWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocStandardWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fTreeWizardPage;
    private JavadocSpecificsWizardPage fLastWizardPage;
    private JavadocStandardWizardPage fStandardDocletWizardPage;
    private ContributedJavadocWizardPage[] fContributedJavadocWizardPages;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private final String JAVADOC_ANT_INFORMATION_DIALOG = "javadocAntInformationDialog";
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.jdt.ui.javadocProcess";

    public static void openJavadocWizard(JavadocWizard wizard, Shell shell, IStructuredSelection selection) {
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard){

            protected IDialogSettings getDialogBoundsSettings() {
                return JavaPlugin.getDefault().getDialogSettingsSection("JavadocWizardDialog");
            }
        };
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(100), converter.convertHeightInCharsToPixels(20));
        dialog.open();
    }

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXPORT_JAVADOC);
        this.setWindowTitle(JavadocExportMessages.JavadocWizard_javadocwizard_title);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        this.updateStore();
        IJavaProject[] checkedProjects = this.fTreeWizardPage.getCheckedProjects();
        this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        if (!new RefactoringSaveHelper(1).saveEditors(this.getShell())) {
            return false;
        }
        this.fDestination = Path.fromOSString((String)this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURI().toURL();
                ArrayList<IJavaProject> projs = new ArrayList<IJavaProject>();
                int i = 0;
                while (i < checkedProjects.length) {
                    IJavaProject curr = checkedProjects[i];
                    URL currURL = JavaUI.getProjectJavadocLocation(curr);
                    if (!newURL.equals(currURL)) {
                        projs.add(curr);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        if (this.fLastWizardPage.generateAnt()) {
            OptionalMessageDialog.open("javadocAntInformationDialog", this.getShell(), JavadocExportMessages.JavadocWizard_antInformationDialog_title, null, JavadocExportMessages.JavadocWizard_antInformationDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            try {
                Element javadocXMLElement = this.fStore.createXML(checkedProjects);
                if (javadocXMLElement != null) {
                    File file;
                    IFile[] files;
                    if (!this.fTreeWizardPage.getCustom()) {
                        int i = 0;
                        while (i < this.fContributedJavadocWizardPages.length) {
                            this.fContributedJavadocWizardPages[i].updateAntScript(javadocXMLElement);
                            ++i;
                        }
                    }
                    if ((files = this.fRoot.findFilesForLocation(Path.fromOSString((String)(file = this.fStore.writeXML(javadocXMLElement)).getPath()))) != null) {
                        int i = 0;
                        while (i < files.length) {
                            files[i].refreshLocal(1, null);
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), JavadocExportMessages.JavadocWizard_error_writeANT_title, JavadocExportMessages.JavadocWizard_error_writeANT_message);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore() {
        this.fTreeWizardPage.updateStore();
        if (!this.fTreeWizardPage.getCustom()) {
            this.fStandardDocletWizardPage.updateStore();
        }
        this.fLastWizardPage.updateStore();
    }

    public boolean performCancel() {
        this.updateStore();
        if (this.fXmlJavadocFile == null) {
            IJavaProject[] checkedProjects = this.fTreeWizardPage.getCheckedProjects();
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] projects, URL newURL) {
        Shell shell = this.getShell();
        String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int j = 0;
        while (j < projects.length) {
            IJavaProject iJavaProject = projects[j];
            String message = Messages.format(JavadocExportMessages.JavadocWizard_updatejavadoclocation_message, new String[]{BasicElementLabels.getJavaElementName(iJavaProject.getElementName()), BasicElementLabels.getPathLabel(this.fDestination, true)});
            MessageDialog dialog = new MessageDialog(shell, JavadocExportMessages.JavadocWizard_updatejavadocdialog_label, null, message, 3, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    private boolean executeJavadocGeneration() {
        block13: {
            Process process = null;
            try {
                ArrayList<String> vmArgs = new ArrayList<String>();
                ArrayList progArgs = new ArrayList();
                IStatus status = this.fStore.getArgumentArray(vmArgs, vmArgs);
                if (!status.isOK()) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)JavadocExportMessages.JavadocWizard_error_title, (String)JavadocExportMessages.JavadocWizard_warning_starting_message, (IStatus)status);
                }
                if (!this.fTreeWizardPage.getCustom()) {
                    int i = 0;
                    while (i < this.fContributedJavadocWizardPages.length) {
                        this.fContributedJavadocWizardPages[i].updateArguments(vmArgs, vmArgs);
                        ++i;
                    }
                }
                File file = File.createTempFile("javadoc-arguments", ".tmp");
                vmArgs.add(String.valueOf('@') + file.getAbsolutePath());
                FileWriter writer = new FileWriter(file);
                try {
                    int i = 0;
                    while (i < progArgs.size()) {
                        String curr = (String)progArgs.get(i);
                        curr = this.checkForSpaces(curr);
                        writer.write(curr);
                        writer.write(32);
                        ++i;
                    }
                }
                finally {
                    writer.close();
                }
                String[] args = vmArgs.toArray(new String[vmArgs.size()]);
                process = Runtime.getRuntime().exec(args);
                if (process == null) break block13;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < args.length) {
                    buf.append(args[i]);
                    buf.append(' ');
                    ++i;
                }
                JavadocDebugEventListener listener = new JavadocDebugEventListener(this.getShell().getDisplay(), file);
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)listener);
                ILaunchConfigurationWorkingCopy wc = null;
                try {
                    ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                    String name = JavadocExportMessages.JavadocWizard_launchconfig_name;
                    wc = lcType.newInstance(null, name);
                    wc.setAttribute("org.eclipse.debug.ui.private", true);
                    Launch newLaunch = new Launch((ILaunchConfiguration)wc, "run", null);
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)newLaunch, (Process)process, (String)JavadocExportMessages.JavadocWizard_javadocprocess_label);
                    iprocess.setAttribute(IProcess.ATTR_CMDLINE, buf.toString());
                    iprocess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                    DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)newLaunch);
                }
                catch (CoreException e) {
                    String title = JavadocExportMessages.JavadocWizard_error_title;
                    String message = JavadocExportMessages.JavadocWizard_launch_error_message;
                    ExceptionHandler.handle(e, this.getShell(), title, message);
                }
                return true;
            }
            catch (IOException e) {
                String title = JavadocExportMessages.JavadocWizard_error_title;
                String message = JavadocExportMessages.JavadocWizard_exec_error_message;
                Status status = new Status(4, "org.eclipse.jdt.ui", 4, e.getMessage(), (Throwable)e);
                ExceptionHandler.handle(new CoreException((IStatus)status), this.getShell(), title, message);
                return false;
            }
        }
        return false;
    }

    private String checkForSpaces(String curr) {
        if (curr.indexOf(32) == -1) {
            return curr;
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int i = 0;
        while (i < curr.length()) {
            char ch = curr.charAt(i);
            if (ch == '\\' || ch == '\'') {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        buf.append('\'');
        return buf.toString();
    }

    public void addPages() {
        this.fContributedJavadocWizardPages = ContributedJavadocWizardPage.getContributedPages(this.fStore);
        this.fTreeWizardPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fLastWizardPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fTreeWizardPage, this.fStore);
        this.fStandardDocletWizardPage = new JavadocStandardWizardPage("JavadocStandardPage", this.fTreeWizardPage, this.fStore);
        super.addPage((IWizardPage)this.fTreeWizardPage);
        super.addPage((IWizardPage)this.fStandardDocletWizardPage);
        int i = 0;
        while (i < this.fContributedJavadocWizardPages.length) {
            super.addPage((IWizardPage)this.fContributedJavadocWizardPages[i]);
            ++i;
        }
        super.addPage((IWizardPage)this.fLastWizardPage);
        this.fTreeWizardPage.init();
        this.fStandardDocletWizardPage.init();
        this.fLastWizardPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ArrayList<IJavaElement> selected = Collections.EMPTY_LIST;
        if (window != null) {
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                selected = ((IStructuredSelection)selection).toList();
            } else {
                IJavaElement element = EditorUtility.getActiveEditorJavaInput();
                if (element != null) {
                    selected = new ArrayList<IJavaElement>();
                    selected.add(element);
                }
            }
        }
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), selected);
    }

    private void refresh(IPath path) {
        if (this.fRoot.findContainersForLocation(path).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURI().toURL();
                OpenBrowserUtil.open(url, display, this.getWindowTitle());
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fTreeWizardPage && this.fTreeWizardPage.getCustom()) {
            return this.fLastWizardPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fLastWizardPage && this.fTreeWizardPage.getCustom()) {
            return this.fTreeWizardPage;
        }
        return super.getPreviousPage(page);
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        private Display fDisplay;
        private File fFile;

        public JavadocDebugEventListener(Display display, File file) {
            this.fDisplay = display;
            this.fFile = file;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getKind() == 8) {
                    try {
                        if (!JavadocWizard.this.fWriteCustom) {
                            this.fFile.delete();
                            JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                            JavadocWizard.this.spawnInBrowser(this.fDisplay);
                        }
                    }
                    finally {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    return;
                }
                ++i;
            }
        }
    }
}

