/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public abstract class AbstractWorkingSetWizardPage
extends WizardPage
implements IWorkingSetPage {
    private Text fWorkingSetName;
    private TreeViewer fTree;
    private TableViewer fTable;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck = true;
    private final HashSet fSelectedElements = new HashSet();
    private IWorkingSet fWorkingSet;
    static /* synthetic */ Class class$0;

    protected AbstractWorkingSetWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected abstract String getPageId();

    protected abstract void configureTree(TreeViewer var1);

    protected abstract void configureTable(TableViewer var1);

    protected abstract Object[] getInitialWorkingSetElements(IWorkingSet var1);

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractWorkingSetWizardPage.this.validateInput();
            }
        });
        Composite leftCenterRightComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        leftCenterRightComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftCenterRightComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(leftCenterRightComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        this.createTree(leftComposite);
        this.createTable(rightComposite);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeSelectedElements();
        this.validateInput();
        this.fTable.setInput((Object)this.fSelectedElements);
        this.fTable.refresh(true);
        this.fTree.refresh(true);
        this.createButtonBar(centerComposite);
        this.fWorkingSetName.setFocus();
        this.fWorkingSetName.setSelection(0, this.fWorkingSetName.getText().length());
        Dialog.applyDialogFont((Control)composite);
    }

    private void createTree(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workspace_content);
        this.fTree = new TreeViewer(parent, 2818);
        this.fTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.addFilter((ViewerFilter)new AddedElementsFilter());
        this.fTree.setUseHashlookup(true);
        this.configureTree(this.fTree);
        this.fTreeContentProvider = (ITreeContentProvider)this.fTree.getContentProvider();
    }

    private void createButtonBar(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        final Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText(WorkingSetMessages.JavaWorkingSetPage_add_button);
        addButton.setEnabled(!this.fTree.getSelection().isEmpty());
        final Button addAllButton = new Button(parent, 8);
        addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addAllButton.setText(WorkingSetMessages.JavaWorkingSetPage_addAll_button);
        addAllButton.setEnabled(this.fTree.getTree().getItems().length > 0);
        final Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(WorkingSetMessages.JavaWorkingSetPage_remove_button);
        removeButton.setEnabled(!this.fTable.getSelection().isEmpty());
        final Button removeAllButton = new Button(parent, 8);
        removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        removeAllButton.setText(WorkingSetMessages.JavaWorkingSetPage_removeAll_button);
        removeAllButton.setEnabled(!this.fSelectedElements.isEmpty());
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetWizardPage.this.addTreeSelection();
                removeAllButton.setEnabled(true);
                addAllButton.setEnabled(AbstractWorkingSetWizardPage.this.fTree.getTree().getItems().length > 0);
            }
        });
        this.fTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractWorkingSetWizardPage.this.addTreeSelection();
                removeAllButton.setEnabled(true);
                addAllButton.setEnabled(AbstractWorkingSetWizardPage.this.fTree.getTree().getItems().length > 0);
            }
        });
        this.fTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetWizardPage.this.removeTableSelection();
                addAllButton.setEnabled(true);
                removeAllButton.setEnabled(!AbstractWorkingSetWizardPage.this.fSelectedElements.isEmpty());
            }
        });
        this.fTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractWorkingSetWizardPage.this.removeTableSelection();
                addAllButton.setEnabled(true);
                removeAllButton.setEnabled(!AbstractWorkingSetWizardPage.this.fSelectedElements.isEmpty());
            }
        });
        addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = AbstractWorkingSetWizardPage.this.fTree.getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    AbstractWorkingSetWizardPage.this.fSelectedElements.add(items[i].getData());
                    ++i;
                }
                AbstractWorkingSetWizardPage.this.fTable.refresh();
                AbstractWorkingSetWizardPage.this.fTree.refresh();
                addAllButton.setEnabled(false);
                removeAllButton.setEnabled(true);
            }
        });
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWorkingSetWizardPage.this.fSelectedElements.clear();
                AbstractWorkingSetWizardPage.this.fTable.refresh();
                AbstractWorkingSetWizardPage.this.fTree.refresh();
                removeAllButton.setEnabled(false);
                addAllButton.setEnabled(true);
            }
        });
    }

    private void addTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        this.fSelectedElements.addAll(selection.toList());
        Object[] selectedElements = selection.toArray();
        this.fTable.add(selectedElements);
        this.fTree.remove(selectedElements);
        this.fTable.setSelection((ISelection)selection);
        this.fTable.getControl().setFocus();
        this.validateInput();
    }

    private void removeTableSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.fTable.getSelection();
        this.fSelectedElements.removeAll(selection.toList());
        Object[] selectedElements = selection.toArray();
        this.fTable.remove(selectedElements);
        try {
            this.fTree.getTree().setRedraw(false);
            int i = 0;
            while (i < selectedElements.length) {
                this.fTree.refresh(this.fTreeContentProvider.getParent(selectedElements[i]), true);
                ++i;
            }
        }
        finally {
            this.fTree.getTree().setRedraw(true);
        }
        this.fTree.setSelection((ISelection)selection);
        this.fTree.getControl().setFocus();
        this.validateInput();
    }

    private void createTable(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_content);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fTable = new TableViewer(parent, 2818);
        GridData gd = new GridData(4, 4, true, true);
        this.fTable.getControl().setLayoutData((Object)gd);
        this.fTable.setUseHashlookup(true);
        this.configureTable(this.fTable);
        this.fTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return AbstractWorkingSetWizardPage.this.fSelectedElements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeSelectedElements();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        HashSet elements = this.fSelectedElements;
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
            this.fWorkingSet.setId(this.getPageId());
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            HashSet<IProject> closedWithChildren = new HashSet<IProject>(elements.size());
            int i = 0;
            while (i < oldItems.length) {
                IProject project;
                IResource oldResource = null;
                if (oldItems[i] instanceof IResource) {
                    oldResource = (IResource)oldItems[i];
                } else {
                    IAdaptable iAdaptable = oldItems[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    oldResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (oldResource != null && !oldResource.isAccessible() && (closedWithChildren.contains(project = oldResource.getProject()) || elements.contains(project))) {
                    elements.add(oldItems[i]);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++i;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.JavaWorkingSetPage_warning_workingSetExists;
                }
                ++i;
            }
        }
        if (!this.hasSelectedElement()) {
            infoMessage = WorkingSetMessages.JavaWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasSelectedElement() {
        return !this.fSelectedElements.isEmpty();
    }

    private void initializeSelectedElements() {
        this.fSelectedElements.addAll(Arrays.asList(this.getInitialWorkingSetElements(this.fWorkingSet)));
    }

    private final class AddedElementsFilter
    extends ViewerFilter {
        private AddedElementsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !AbstractWorkingSetWizardPage.this.fSelectedElements.contains(element);
        }
    }
}

