/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import org.eclipse.epp.usagedata.internal.gathering.UsageDataCaptureActivator;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class BundleUsageMonitor
implements UsageMonitor {
    private BundleListener bundleUsageListener;

    public void startMonitoring(final UsageDataService usageDataService) {
        this.recordCurrentlyActiveBundles(usageDataService);
        this.bundleUsageListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                usageDataService.recordEvent(BundleUsageMonitor.this.getWhatHappenedString(event), "bundle", event.getBundle().getSymbolicName(), event.getBundle().getSymbolicName(), BundleUsageMonitor.this.getBundleVersion(event));
            }
        };
        this.getBundleContext().addBundleListener(this.bundleUsageListener);
    }

    private void recordCurrentlyActiveBundles(UsageDataService usageDataService) {
        Bundle[] bundleArray = this.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 32) {
                String bundleId = bundle.getSymbolicName();
                usageDataService.recordEvent("started", "bundle", bundleId, bundleId, this.getBundleVersion(bundle));
            }
            ++n2;
        }
    }

    protected String getWhatHappenedString(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                return "installed";
            }
            case 512: {
                return "lazy_activation";
            }
            case 32: {
                return "resolved";
            }
            case 2: {
                return "started";
            }
            case 128: {
                return "starting";
            }
            case 4: {
                return "stopped";
            }
            case 256: {
                return "stopping";
            }
            case 16: {
                return "uninstalled";
            }
            case 64: {
                return "unresolved";
            }
            case 8: {
                return "updated";
            }
        }
        return "unknown";
    }

    protected String getBundleVersion(BundleEvent event) {
        return this.getBundleVersion(event.getBundle());
    }

    private String getBundleVersion(Bundle bundle) {
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public void stopMonitoring() {
        this.getBundleContext().removeBundleListener(this.bundleUsageListener);
    }

    private BundleContext getBundleContext() {
        return UsageDataCaptureActivator.getDefault().getBundle().getBundleContext();
    }
}

