/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.epp.usagedata.internal.gathering.monitors.ExtensionIdToBundleMapper;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class CommandUsageMonitor
implements UsageMonitor {
    private IExecutionListener executionListener;
    private ExtensionIdToBundleMapper commandToBundleIdMapper;

    public void startMonitoring(final UsageDataService usageDataService) {
        this.executionListener = new IExecutionListener(){

            public void notHandled(String commandId, NotHandledException exception) {
                CommandUsageMonitor.this.recordEvent("no handler", usageDataService, commandId);
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
                CommandUsageMonitor.this.recordEvent("failed", usageDataService, commandId);
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                CommandUsageMonitor.this.recordEvent("executed", usageDataService, commandId);
            }

            public void preExecute(String commandId, ExecutionEvent event) {
            }
        };
        this.getCommandService().addExecutionListener(this.executionListener);
        this.commandToBundleIdMapper = new ExtensionIdToBundleMapper("org.eclipse.ui.commands");
    }

    private ICommandService getCommandService() {
        return (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
    }

    public void stopMonitoring() {
        ICommandService commandService = this.getCommandService();
        if (commandService != null) {
            commandService.removeExecutionListener(this.executionListener);
        }
        this.commandToBundleIdMapper.dispose();
    }

    private void recordEvent(String what, UsageDataService usageDataService, String commandId) {
        usageDataService.recordEvent(what, "command", commandId, this.getBundleId(commandId));
    }

    protected synchronized String getBundleId(String commandId) {
        return this.commandToBundleIdMapper.getBundleId(commandId);
    }
}

