/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soc.ide4edu.ui.view.NewJavaLiteProjectWizardPageOne;
import org.eclipse.soc.ide4edu.ui.view.NewJavaLiteProjectWizardPageTwo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavaLiteProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewJavaLiteProjectWizardPageOne fFirstPage;
    private NewJavaLiteProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaLiteProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
        this.fFirstPage = null;
        this.fSecondPage = null;
    }

    public void addPages() {
        this.fFirstPage = new NewJavaLiteProjectWizardPageOne();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new NewJavaLiteProjectWizardPageTwo(this.fFirstPage);
        this.fFirstPage.init(this.getSelection(), this.getActivePart());
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(iProgressMonitor);
    }

    public boolean performFinish() {
        boolean bl = super.performFinish();
        if (bl) {
            final IJavaElement iJavaElement = this.getCreatedElement();
            IWorkingSet[] iWorkingSetArray = this.fFirstPage.getWorkingSets();
            if (iWorkingSetArray.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)iJavaElement, iWorkingSetArray);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPart iWorkbenchPart = JavaLiteProjectWizard.this.getActivePart();
                    if (iWorkbenchPart instanceof IPackagesViewPart) {
                        new ShowInPackageViewAction((IWorkbenchSite)iWorkbenchPart.getSite()).run(iJavaElement);
                    }
                }
            });
        }
        return bl;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActivePart();
        }
        return null;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = NewWizardMessages.JavaProjectWizard_op_error_title;
        String string2 = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (Shell)this.getShell(), (String)string, (String)string2);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.fConfigElement = iConfigurationElement;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }
}

