/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public class NewJavaLiteProjectWizardPageOne
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageOne";
    private final NameGroup fNameGroup;
    private final LocationGroup fLocationGroup;
    private final LayoutGroup fLayoutGroup;
    private final JREGroup fJREGroup;
    private final DetectGroup fDetectGroup;
    private final Validator fValidator;
    private final WorkingSetGroup fWorkingSetGroup;
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    public NewJavaLiteProjectWizardPageOne() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.NewJavaProjectWizardPageOne_page_title);
        this.setDescription(NewWizardMessages.NewJavaProjectWizardPageOne_page_description);
        this.fNameGroup = new NameGroup();
        this.fLocationGroup = new LocationGroup();
        this.fJREGroup = new JREGroup();
        this.fLayoutGroup = new LayoutGroup();
        this.fWorkingSetGroup = new WorkingSetGroup();
        this.fDetectGroup = new DetectGroup();
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        this.setWorkingSets(new IWorkingSet[0]);
        this.initializeDefaultVM();
    }

    public void init(IStructuredSelection iStructuredSelection, IWorkbenchPart iWorkbenchPart) {
        this.setWorkingSets(this.getSelectedWorkingSet(iStructuredSelection, iWorkbenchPart));
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite2.setLayoutData((Object)new GridData(256));
        Control control = this.createNameControl(composite2);
        control.setLayoutData((Object)new GridData(768));
        Control control2 = this.createLocationControl(composite2);
        control2.setLayoutData((Object)new GridData(768));
        Control control3 = this.createJRESelectionControl(composite2);
        control3.setLayoutData((Object)new GridData(768));
        Control control4 = this.createProjectLayoutControl(composite2);
        control4.setLayoutData((Object)new GridData(768));
        Control control5 = this.createWorkingSetControl(composite2);
        control5.setLayoutData((Object)new GridData(768));
        Control control6 = this.createInfoControl(composite2);
        control6.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite2);
    }

    protected void setControl(Control control) {
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        super.setControl(control);
    }

    protected Control createNameControl(Composite composite) {
        return this.fNameGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.fLocationGroup.createControl(composite);
    }

    protected Control createJRESelectionControl(Composite composite) {
        return this.fJREGroup.createControl(composite);
    }

    protected Control createProjectLayoutControl(Composite composite) {
        return this.fLayoutGroup.createContent(composite);
    }

    protected Control createWorkingSetControl(Composite composite) {
        return this.fWorkingSetGroup.createControl(composite);
    }

    protected Control createInfoControl(Composite composite) {
        return this.fDetectGroup.createControl(composite);
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public void setProjectName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.fNameGroup.setName(string);
    }

    public URI getProjectLocationURI() {
        if (this.fLocationGroup.isLocationInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fLocationGroup.getLocation());
    }

    public void setProjectLocationURI(URI uRI) {
        IPath iPath = uRI != null ? URIUtil.toPath((URI)uRI) : null;
        this.fLocationGroup.setLocation(iPath);
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public IClasspathEntry[] getDefaultClasspathEntries() {
        IClasspathEntry[] iClasspathEntryArray = PreferenceConstants.getDefaultJRELibrary();
        String string = this.getCompilerCompliance();
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        if (string == null || iClasspathEntryArray.length > 1 || !path.isPrefixOf(iClasspathEntryArray[0].getPath())) {
            return iClasspathEntryArray;
        }
        IPath iPath = this.fJREGroup.getJREContainerPath();
        if (iPath != null) {
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)iPath)};
        }
        return iClasspathEntryArray;
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        Path path;
        IPath iPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (path = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"))).segmentCount() > 0) {
            iPath = iPath.append((IPath)path);
        }
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)iPath)};
    }

    public IPath getOutputLocation() {
        Path path;
        IPath iPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (path = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"))).segmentCount() > 0) {
            iPath = iPath.append((IPath)path);
        }
        return iPath;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingSetGroup.setWorkingSets(iWorkingSetArray);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.fNameGroup.postSetFocus();
        }
    }

    private GridLayout initGridLayout(GridLayout gridLayout, boolean bl) {
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (bl) {
            gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        return gridLayout;
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection iStructuredSelection, IWorkbenchPart iWorkbenchPart) {
        IWorkingSet[] iWorkingSetArray = this.getSelectedWorkingSet(iStructuredSelection);
        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (!NewJavaLiteProjectWizardPageOne.isValidWorkingSet(iWorkingSetArray[n])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++n;
            }
            return iWorkingSetArray;
        }
        if (!(iWorkbenchPart instanceof PackageExplorerPart)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        PackageExplorerPart packageExplorerPart = (PackageExplorerPart)iWorkbenchPart;
        if (packageExplorerPart.getRootMode() == 1) {
            IWorkingSet iWorkingSet = packageExplorerPart.getFilterWorkingSet();
            if (iWorkingSet == null) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            if (!NewJavaLiteProjectWizardPageOne.isValidWorkingSet(iWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            return new IWorkingSet[]{iWorkingSet};
        }
        Object object = packageExplorerPart.getViewPartInput();
        if (!(object instanceof IWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        IWorkingSet iWorkingSet = (IWorkingSet)object;
        if (!NewJavaLiteProjectWizardPageOne.isValidWorkingSet(iWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return new IWorkingSet[]{iWorkingSet};
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection iStructuredSelection) {
        if (!(iStructuredSelection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection iTreeSelection = (ITreeSelection)iStructuredSelection;
        if (iTreeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List list = iTreeSelection.toList();
        if (list.size() == 1) {
            Object e = list.get(0);
            TreePath[] treePathArray = iTreeSelection.getPathsFor(e);
            if (treePathArray.length != 1) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            TreePath treePath = treePathArray[0];
            if (treePath.getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object object = treePath.getSegment(0);
            if (!(object instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            if (NewJavaLiteProjectWizardPageOne.isValidWorkingSet(iWorkingSet)) {
                return new IWorkingSet[]{iWorkingSet};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IWorkingSet) || !NewJavaLiteProjectWizardPageOne.isValidWorkingSet((IWorkingSet)e)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    private static boolean isValidWorkingSet(IWorkingSet iWorkingSet) {
        String string = iWorkingSet.getId();
        if (!"org.eclipse.jdt.ui.JavaWorkingSetPage".equals(string) && !"org.eclipse.ui.resourceWorkingSetPage".equals(string)) {
            return false;
        }
        return !iWorkingSet.isAggregateWorkingSet();
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private Link fHintText;
        private Label fIcon;
        private boolean fDetect = false;

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.horizontalSpacing = 10;
            composite2.setLayout((Layout)gridLayout);
            this.fIcon = new Label(composite2, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite2, 64);
            this.fHintText.setFont(composite2.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = NewJavaLiteProjectWizardPageOne.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = NewJavaLiteProjectWizardPageOne.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
            this.handlePossibleJVMChange();
            composite2.setVisible(false);
            return composite2;
        }

        public void handlePossibleJVMChange() {
            if (JavaRuntime.getDefaultVMInstall() == null) {
                this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_NoJREFound_link);
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
                return;
            }
            String string = NewJavaLiteProjectWizardPageOne.this.fJREGroup.getSelectedCompilerCompliance();
            if (string != null) {
                String string2 = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                if (string.equals(string2)) {
                    this.fHintText.setVisible(false);
                    this.fIcon.setVisible(false);
                } else {
                    this.fHintText.setText(Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_differendWorkspaceCC_message, (Object[])new String[]{BasicElementLabels.getVersionName((String)string2), BasicElementLabels.getVersionName((String)string)}));
                    this.fHintText.setVisible(true);
                    this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    this.fIcon.setVisible(true);
                }
                return;
            }
            string = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            IVMInstall iVMInstall = NewJavaLiteProjectWizardPageOne.this.fJREGroup.getSelectedJVM();
            if (iVMInstall == null) {
                iVMInstall = JavaRuntime.getDefaultVMInstall();
            }
            String string3 = "1.4";
            if (iVMInstall instanceof IVMInstall2) {
                string3 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)iVMInstall), (String)"1.4");
            }
            if (!string.equals(string3) && (JavaModelUtil.is50OrHigher((String)string) || JavaModelUtil.is50OrHigher((String)string3))) {
                if (string.equals("1.5")) {
                    string = "5.0";
                } else if (string.equals("1.6")) {
                    string = "6.0";
                }
                this.fHintText.setText(Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_jre_message, (Object[])new String[]{BasicElementLabels.getVersionName((String)string), BasicElementLabels.getVersionName((String)string3)}));
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
                this.fIcon.setVisible(false);
            }
        }

        private boolean computeDetectState() {
            if (NewJavaLiteProjectWizardPageOne.this.fLocationGroup.isWorkspaceRadioSelected()) {
                String string = NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName();
                if (string.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(string) != null) {
                    return false;
                }
                File file = NewJavaLiteProjectWizardPageOne.this.fLocationGroup.getLocation().append(string).toFile();
                return file.isDirectory();
            }
            File file = NewJavaLiteProjectWizardPageOne.this.fLocationGroup.getLocation().toFile();
            return file.isDirectory();
        }

        public void update(Observable observable, Object object) {
            if (observable instanceof LocationGroup) {
                boolean bl = this.fDetect;
                this.fDetect = this.computeDetectState();
                if (bl != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetDefaultSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String string2 = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String string3 = "JRE".equals(selectionEvent.text) ? string : string2;
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaLiteProjectWizardPageOne.this.getShell(), (String)string3, (String[])new String[]{string, string2}, hashMap).open();
            NewJavaLiteProjectWizardPageOne.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
        private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
        private static final String LAST_SELECTED_JRE_KIND = "org.eclipse.jdt.ui.last.selected.jre.kind";
        private static final int DEFAULT_JRE = 0;
        private static final int PROJECT_JRE = 1;
        private static final int EE_JRE = 2;
        private final SelectionButtonDialogField fUseDefaultJRE = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fUseProjectJRE;
        private final SelectionButtonDialogField fUseEEJRE;
        private final ComboDialogField fJRECombo;
        private final ComboDialogField fEECombo;
        private Group fGroup;
        private Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;
        private String[] fJRECompliance;
        private IExecutionEnvironment[] fInstalledEEs;
        private String[] fEECompliance;

        public JREGroup() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_compliance);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseEEJRE = new SelectionButtonDialogField(16);
            this.fUseEEJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_EE);
            this.fEECombo = new ComboDialogField(8);
            this.fillExecutionEnvironments(this.fEECombo);
            this.fEECombo.setDialogFieldListener((IDialogFieldListener)this);
            switch (this.getLastSelectedJREKind()) {
                case 0: {
                    this.fUseDefaultJRE.setSelection(true);
                    break;
                }
                case 1: {
                    this.fUseProjectJRE.setSelection(true);
                    break;
                }
                case 2: {
                    this.fUseEEJRE.setSelection(true);
                }
            }
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(this.fUseEEJRE.isSelected());
            this.fUseDefaultJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseProjectJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseEEJRE.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaLiteProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), true));
            this.fGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_title);
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            Composite composite2 = new Composite((Composite)this.fGroup, 0);
            composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            this.fUseProjectJRE.doFillIntoGrid(composite2, 1);
            Combo combo = this.fJRECombo.getComboControl(composite2);
            combo.setLayoutData((Object)new GridData(4, 2, true, false));
            combo.setVisibleItemCount(30);
            this.fUseEEJRE.doFillIntoGrid(composite2, 1);
            Combo combo2 = this.fEECombo.getComboControl(composite2);
            combo2.setLayoutData((Object)new GridData(4, 2, true, false));
            combo2.setVisibleItemCount(30);
            this.updateEnableState();
            this.fGroup.setVisible(false);
            return this.fGroup;
        }

        private void fillInstalledJREs(ComboDialogField comboDialogField) {
            String string = this.getLastSelectedJRE();
            int n = -1;
            if (this.fUseProjectJRE.isSelected() && (n = comboDialogField.getSelectionIndex()) != -1) {
                string = comboDialogField.getItems()[n];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object object, Object object2) {
                    IVMInstall iVMInstall = (IVMInstall)object;
                    IVMInstall iVMInstall2 = (IVMInstall)object2;
                    if (iVMInstall2 instanceof IVMInstall2 && iVMInstall instanceof IVMInstall2) {
                        String string = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)iVMInstall), (String)"1.4");
                        String string2 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)iVMInstall2), (String)"1.4");
                        int n = string2.compareTo(string);
                        if (n != 0) {
                            return n;
                        }
                    }
                    return Policy.getComparator().compare(iVMInstall.getName(), iVMInstall2.getName());
                }
            });
            n = -1;
            String[] stringArray = new String[this.fInstalledJVMs.length];
            this.fJRECompliance = new String[this.fInstalledJVMs.length];
            int n2 = 0;
            while (n2 < this.fInstalledJVMs.length) {
                stringArray[n2] = this.fInstalledJVMs[n2].getName();
                if (string != null && stringArray[n2].equals(string)) {
                    n = n2;
                }
                this.fJRECompliance[n2] = this.fInstalledJVMs[n2] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)this.fInstalledJVMs[n2]), (String)"1.4") : "1.4";
                ++n2;
            }
            comboDialogField.setItems(stringArray);
            if (n == -1) {
                comboDialogField.selectItem(this.getDefaultJVMName());
            } else {
                comboDialogField.selectItem(string);
            }
        }

        private void fillExecutionEnvironments(ComboDialogField comboDialogField) {
            String string = this.getLastSelectedEE();
            int n = -1;
            if (this.fUseEEJRE.isSelected() && (n = comboDialogField.getSelectionIndex()) != -1) {
                string = comboDialogField.getItems()[n];
            }
            this.fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            Arrays.sort(this.fInstalledEEs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object object, Object object2) {
                    return Policy.getComparator().compare(((IExecutionEnvironment)object).getId(), ((IExecutionEnvironment)object2).getId());
                }
            });
            n = -1;
            String[] stringArray = new String[this.fInstalledEEs.length];
            this.fEECompliance = new String[this.fInstalledEEs.length];
            int n2 = 0;
            while (n2 < this.fInstalledEEs.length) {
                stringArray[n2] = this.fInstalledEEs[n2].getId();
                if (string != null && stringArray[n2].equals(string)) {
                    n = n2;
                }
                this.fEECompliance[n2] = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)this.fInstalledEEs[n2]);
                ++n2;
            }
            comboDialogField.setItems(stringArray);
            if (n == -1) {
                comboDialogField.selectItem(this.getDefaultEEName());
            } else {
                comboDialogField.selectItem(string);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> arrayList = new ArrayList<VMStandin>();
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = 0;
            while (n < iVMInstallTypeArray.length) {
                IVMInstallType iVMInstallType = iVMInstallTypeArray[n];
                IVMInstall[] iVMInstallArray = iVMInstallType.getVMInstalls();
                int n2 = 0;
                while (n2 < iVMInstallArray.length) {
                    IVMInstall iVMInstall = iVMInstallArray[n2];
                    arrayList.add(new VMStandin(iVMInstall));
                    ++n2;
                }
                ++n;
            }
            return arrayList.toArray(new IVMInstall[arrayList.size()]);
        }

        private String getDefaultJVMName() {
            IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
            if (iVMInstall != null) {
                return iVMInstall.getName();
            }
            return NewWizardMessages.NewJavaProjectWizardPageOne_UnknownDefaultJRE_name;
        }

        private String getDefaultEEName() {
            IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
            IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            if (iVMInstall != null) {
                int n = 0;
                while (n < iExecutionEnvironmentArray.length) {
                    IVMInstall iVMInstall2 = iExecutionEnvironmentArray[n].getDefaultVM();
                    if (iVMInstall2 != null && iVMInstall.getId().equals(iVMInstall2.getId())) {
                        return iExecutionEnvironmentArray[n].getId();
                    }
                    ++n;
                }
            }
            String string = iVMInstall instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)iVMInstall), (String)"1.4") : "1.4";
            int n = 0;
            while (n < iExecutionEnvironmentArray.length) {
                String string2 = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)iExecutionEnvironmentArray[n]);
                if (string.endsWith(string2)) {
                    return iExecutionEnvironmentArray[n].getId();
                }
                ++n;
            }
            return "J2SE-1.5";
        }

        private String getDefaultJVMLabel() {
            return Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_default_compliance, (Object)this.getDefaultJVMName());
        }

        public void update(Observable observable, Object object) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean bl = NewJavaLiteProjectWizardPageOne.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!bl);
            this.fUseProjectJRE.setEnabled(!bl);
            this.fUseEEJRE.setEnabled(!bl);
            this.fJRECombo.setEnabled(!bl && this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(!bl && this.fUseEEJRE.isSelected());
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!bl);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!bl);
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetDefaultSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String string2 = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaLiteProjectWizardPageOne.this.getShell(), (String)string, (String[])new String[]{string, string2}, hashMap).open();
            this.handlePossibleJVMChange();
            NewJavaLiteProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
            this.fillExecutionEnvironments(this.fEECombo);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.updateEnableState();
            NewJavaLiteProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
            if (dialogField == this.fJRECombo) {
                if (this.fUseProjectJRE.isSelected()) {
                    this.storeSelectionValue(this.fJRECombo, LAST_SELECTED_JRE_SETTINGS_KEY);
                }
            } else if (dialogField == this.fEECombo) {
                if (this.fUseEEJRE.isSelected()) {
                    this.storeSelectionValue(this.fEECombo, LAST_SELECTED_EE_SETTINGS_KEY);
                }
            } else if (dialogField == this.fUseDefaultJRE) {
                if (this.fUseDefaultJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 0);
                    this.fUseProjectJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (dialogField == this.fUseProjectJRE) {
                if (this.fUseProjectJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 1);
                    this.fUseDefaultJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (dialogField == this.fUseEEJRE && this.fUseEEJRE.isSelected()) {
                JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 2);
                this.fUseDefaultJRE.setSelection(false);
                this.fUseProjectJRE.setSelection(false);
            }
        }

        private void storeSelectionValue(ComboDialogField comboDialogField, String string) {
            int n = comboDialogField.getSelectionIndex();
            if (n == -1) {
                return;
            }
            String string2 = comboDialogField.getItems()[n];
            JavaPlugin.getDefault().getDialogSettings().put(string, string2);
        }

        private int getLastSelectedJREKind() {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            if (iDialogSettings.get(LAST_SELECTED_JRE_KIND) == null) {
                return 0;
            }
            return iDialogSettings.getInt(LAST_SELECTED_JRE_KIND);
        }

        private String getLastSelectedEE() {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            return iDialogSettings.get(LAST_SELECTED_EE_SETTINGS_KEY);
        }

        private String getLastSelectedJRE() {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            return iDialogSettings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
        }

        public IVMInstall getSelectedJVM() {
            if (this.fUseProjectJRE.isSelected()) {
                int n = this.fJRECombo.getSelectionIndex();
                if (n >= 0 && n < this.fInstalledJVMs.length) {
                    return this.fInstalledJVMs[n];
                }
            } else {
                this.fUseEEJRE.isSelected();
            }
            return null;
        }

        public IPath getJREContainerPath() {
            int n;
            if (this.fUseProjectJRE.isSelected()) {
                int n2 = this.fJRECombo.getSelectionIndex();
                if (n2 >= 0 && n2 < this.fInstalledJVMs.length) {
                    return JavaRuntime.newJREContainerPath((IVMInstall)this.fInstalledJVMs[n2]);
                }
            } else if (this.fUseEEJRE.isSelected() && (n = this.fEECombo.getSelectionIndex()) >= 0 && n < this.fInstalledEEs.length) {
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.fInstalledEEs[n]);
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int n;
            if (this.fUseProjectJRE.isSelected()) {
                int n2 = this.fJRECombo.getSelectionIndex();
                if (n2 >= 0 && n2 < this.fJRECompliance.length) {
                    return this.fJRECompliance[n2];
                }
            } else if (this.fUseEEJRE.isSelected() && (n = this.fEECombo.getSelectionIndex()) >= 0 && n < this.fEECompliance.length) {
                return this.fEECompliance[n];
            }
            return null;
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fSrcBinRadio;
        private Group fGroup;
        private Link fPreferenceLink;

        public LayoutGroup() {
            this.fStdRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_option_separateFolders);
            boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(bl);
            this.fStdRadio.setSelection(!bl);
        }

        public Control createContent(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaLiteProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_title);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.updateEnableState();
            this.fGroup.setVisible(false);
            return this.fGroup;
        }

        public void update(Observable observable, Object object) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean bl = NewJavaLiteProjectWizardPageOne.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!bl);
            this.fSrcBinRadio.setEnabled(!bl);
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!bl);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!bl);
            }
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetDefaultSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaLiteProjectWizardPageOne.this.getShell(), (String)string, (String[])new String[]{string}, null).open();
            NewJavaLiteProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
            NewJavaLiteProjectWizardPageOne.this.fJREGroup.handlePossibleJVMChange();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup() {
            this.fWorkspaceRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
            this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
            this.fLocation.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField((DialogField)this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewJavaLiteProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_title);
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            group.setVisible(false);
            return group;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String string) {
            IPath iPath = Platform.getLocation().append(string);
            return iPath.toOSString();
        }

        public void update(Observable observable, Object object) {
            if (this.isWorkspaceRadioSelected()) {
                this.fLocation.setText(this.getDefaultPath(NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isWorkspaceRadioSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isWorkspaceRadioSelected() {
            return this.fWorkspaceRadio.isSelected();
        }

        public boolean isLocationInWorkspace() {
            String string = NewJavaLiteProjectWizardPageOne.this.fLocationGroup.getLocation().toOSString();
            IPath iPath = Path.fromOSString((String)string);
            return Platform.getLocation().isPrefixOf(iPath);
        }

        public void setLocation(IPath iPath) {
            this.fWorkspaceRadio.setSelection(iPath == null);
            if (iPath != null) {
                this.fLocation.setText(iPath.toOSString());
            } else {
                this.fLocation.setText(this.getDefaultPath(NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public void changeControlPressed(DialogField dialogField) {
            Object object;
            DirectoryDialog directoryDialog = new DirectoryDialog(NewJavaLiteProjectWizardPageOne.this.getShell());
            directoryDialog.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_directory_message);
            String string = this.fLocation.getText().trim();
            if (string.length() == 0 && (object = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                string = object;
            }
            if (string.length() > 0 && ((File)(object = new File(string))).exists()) {
                directoryDialog.setFilterPath(string);
            }
            if ((object = directoryDialog.open()) != null) {
                this.fLocation.setText((String)object);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, (String)object);
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.fWorkspaceRadio) {
                boolean bl = this.fWorkspaceRadio.isSelected();
                if (bl) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField = new StringDialogField();

        public NameGroup() {
            this.fNameField.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_NameGroup_label_text);
            this.fNameField.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            composite2.setLayout((Layout)NewJavaLiteProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), false));
            this.fNameField.doFillIntoGrid(composite2, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
            return composite2;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(NewJavaLiteProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setName(String string) {
            this.fNameField.setText(string);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable observable, Object object) {
            String string;
            IWorkspace iWorkspace = JavaPlugin.getWorkspace();
            String string2 = NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName();
            if (string2.length() == 0) {
                NewJavaLiteProjectWizardPageOne.this.setErrorMessage(null);
                NewJavaLiteProjectWizardPageOne.this.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterProjectName);
                NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IStatus iStatus = iWorkspace.validateName(string2, 4);
            if (!iStatus.isOK()) {
                NewJavaLiteProjectWizardPageOne.this.setErrorMessage(iStatus.getMessage());
                NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IProject iProject = iWorkspace.getRoot().getProject(string2);
            if (iProject.exists()) {
                NewJavaLiteProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_projectAlreadyExists);
                NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(string2);
            if (iPath.toFile().exists()) {
                try {
                    string = iPath.toFile().getCanonicalPath();
                    iPath = new Path(string);
                }
                catch (IOException iOException) {
                    JavaPlugin.log((Throwable)iOException);
                }
                string = iPath.lastSegment();
                if (!string.equals(NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName())) {
                    NewJavaLiteProjectWizardPageOne.this.setErrorMessage(Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidProjectNameForWorkspaceRoot, (Object)BasicElementLabels.getResourceName((String)string)));
                    NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if ((string = NewJavaLiteProjectWizardPageOne.this.fLocationGroup.getLocation().toOSString()).length() == 0) {
                NewJavaLiteProjectWizardPageOne.this.setErrorMessage(null);
                NewJavaLiteProjectWizardPageOne.this.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterLocation);
                NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(string)) {
                NewJavaLiteProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidDirectory);
                NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath iPath2 = Path.fromOSString((String)string);
            if (NewJavaLiteProjectWizardPageOne.this.fLocationGroup.isWorkspaceRadioSelected()) {
                iPath2 = iPath2.append(NewJavaLiteProjectWizardPageOne.this.fNameGroup.getName());
            }
            if (iPath2.toFile().exists()) {
                if (Platform.getLocation().isPrefixOf(iPath2)) {
                    if (!Platform.getLocation().equals((Object)iPath2.removeLastSegments(1))) {
                        NewJavaLiteProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_notOnWorkspaceRoot);
                        NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                    if (!iPath2.toFile().exists()) {
                        NewJavaLiteProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_notExisingProjectOnWorkspaceRoot);
                        NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                }
            } else if (!NewJavaLiteProjectWizardPageOne.this.fLocationGroup.isWorkspaceRadioSelected()) {
                if (!this.canCreate(iPath2.toFile())) {
                    NewJavaLiteProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation);
                    NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
                IStatus iStatus2 = iWorkspace.validateProjectLocation(iProject, iPath2);
                if (!iStatus2.isOK()) {
                    NewJavaLiteProjectWizardPageOne.this.setErrorMessage(iStatus2.getMessage());
                    NewJavaLiteProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            NewJavaLiteProjectWizardPageOne.this.setPageComplete(true);
            NewJavaLiteProjectWizardPageOne.this.setErrorMessage(null);
            NewJavaLiteProjectWizardPageOne.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup() {
            String[] stringArray = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(stringArray, JavaPlugin.getDefault().getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setFont(composite.getFont());
            group.setText(NewWizardMessages.NewJavaProjectWizardPageOne_WorkingSets_group);
            group.setLayout((Layout)new GridLayout(1, false));
            this.fWorkingSetBlock.createContent((Composite)group);
            group.setVisible(false);
            return group;
        }

        public void setWorkingSets(IWorkingSet[] iWorkingSetArray) {
            this.fWorkingSetBlock.setWorkingSets(iWorkingSetArray);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

