/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewLiteClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATEMAIN = "create_main";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewLiteClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle("New Java Class");
        this.setDescription("Create a new Java class.");
        String[] stringArray = new String[]{NewWizardMessages.NewClassWizardPage_methods_main, NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, stringArray, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection iStructuredSelection) {
        IDialogSettings iDialogSettings;
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        this.initTypePage(iJavaElement);
        this.doStatusUpdate();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        IDialogSettings iDialogSettings2 = this.getDialogSettings();
        if (iDialogSettings2 != null && (iDialogSettings = iDialogSettings2.getSection(PAGE_NAME)) != null) {
            bl = iDialogSettings.getBoolean(SETTINGS_CREATEMAIN);
            bl2 = iDialogSettings.getBoolean(SETTINGS_CREATECONSTR);
            bl3 = iDialogSettings.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(bl, bl2, bl3, true);
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(iStatusArray);
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.doStatusUpdate();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createTypeNameControls(composite2, n);
        this.createModifierControls(composite2, n);
        this.createSuperClassControls(composite2, n);
        this.createSuperInterfacesControls(composite2, n);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setFocus();
        } else {
            IDialogSettings iDialogSettings = this.getDialogSettings();
            if (iDialogSettings != null) {
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_NAME);
                if (iDialogSettings2 == null) {
                    iDialogSettings2 = iDialogSettings.addNewSection(PAGE_NAME);
                }
                iDialogSettings2.put(SETTINGS_CREATEMAIN, this.isCreateMain());
                iDialogSettings2.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
                iDialogSettings2.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
            }
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int n) {
        Label label = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)label, (int)n);
        DialogField.createEmptySpace((Composite)composite);
        Composite composite2 = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)composite2, (int)(n - 1));
    }

    public boolean isCreateMain() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    public void setMethodStubSelection(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fMethodStubsButtons.setSelection(0, bl);
        this.fMethodStubsButtons.setSelection(1, bl2);
        this.fMethodStubsButtons.setSelection(2, bl3);
        this.fMethodStubsButtons.setEnabled(bl4);
    }

    protected void createTypeMembers(IType iType, NewTypeWizardPage.ImportsManager importsManager, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = this.isCreateMain();
        boolean bl2 = this.isCreateConstructors();
        boolean bl3 = this.isCreateInherited();
        this.createInheritedMethods(iType, bl2, bl3, importsManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = CodeGeneration.getMethodComment((ICompilationUnit)iType.getCompilationUnit(), (String)iType.getTypeQualifiedName('.'), (String)"main", (String[])new String[]{"args"}, (String[])new String[0], (String)Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            stringBuffer.append("public static void main(");
            stringBuffer.append(importsManager.addImport("java.lang.String"));
            stringBuffer.append("[] args) {");
            stringBuffer.append("\n");
            String string2 = CodeGeneration.getMethodBodyContent((ICompilationUnit)iType.getCompilationUnit(), (String)iType.getTypeQualifiedName('.'), (String)"main", (boolean)false, (String)"", (String)"\n");
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\n");
            stringBuffer.append("}");
            iType.createMethod(stringBuffer.toString(), null, false, null);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }
}

