/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.equinox.internal.p2.artifact.repository.AbstractRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.FileDownloadRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.IArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ArtifactRepositoryManager
extends AbstractRepositoryManager
implements IArtifactRepositoryManager,
ProvisioningListener {
    private static final String ATTR_SUFFIX = "suffix";
    private static final String DEFAULT_SUFFIX = "artifacts.xml";
    private static final String EL_FACTORY = "factory";
    private static final String EL_FILTER = "filter";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_NAME = "name";
    private static final String KEY_PROVIDER = "provider";
    private static final String KEY_SUFFIX = "suffix";
    private static final String KEY_SYSTEM = "isSystem";
    private static final String KEY_TYPE = "type";
    private static final String KEY_URL = "url";
    private static final String KEY_VERSION = "version";
    private static final String NODE_REPOSITORIES = "repositories";
    private Map repositories = null;
    private final Object repositoryLock = new Object();
    private SoftReference unavailableRepositories;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ArtifactRepositoryManager() {
        IProvisioningEventBus bus;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            bus.addListener((ProvisioningListener)this);
        }
    }

    public void addRepository(IArtifactRepository repository) {
        this.addRepository(repository, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepository(IArtifactRepository repository, boolean signalAdd, String suffix) {
        boolean added = true;
        Object object = this.repositoryLock;
        synchronized (object) {
            String key;
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(key = this.getKey(repository))) == null) {
                info = new RepositoryInfo();
            }
            info.repository = new SoftReference<IArtifactRepository>(repository);
            info.name = repository.getName();
            info.description = repository.getDescription();
            info.location = repository.getLocation();
            String value = (String)repository.getProperties().get("p2.system");
            info.isSystem = value == null ? false : Boolean.valueOf(value);
            info.suffix = suffix;
            added = this.repositories.put(this.getKey(repository), info) == null;
        }
        this.remember(repository, suffix);
        if (added && signalAdd) {
            this.broadcastChangeEvent(repository.getLocation(), 1, 0, true);
        }
    }

    public void addRepository(URL location) {
        this.addRepository(location, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepository(URL location, boolean isEnabled) {
        Assert.isNotNull((Object)location);
        RepositoryInfo info = new RepositoryInfo();
        info.location = location;
        info.isEnabled = isEnabled;
        boolean added = true;
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if (this.contains(location)) {
                return;
            }
            added = this.repositories.put(this.getKey(location), info) == null;
        }
        this.remember(info);
        if (added) {
            this.broadcastChangeEvent(location, 1, 0, isEnabled);
        }
    }

    private boolean checkNotFound(URL location) {
        if (this.unavailableRepositories == null) {
            return false;
        }
        List badRepos = (List)this.unavailableRepositories.get();
        if (badRepos == null) {
            return false;
        }
        return badRepos.contains(location);
    }

    private void clearNotFound(URL location) {
        List badRepos;
        if (this.unavailableRepositories != null && (badRepos = (List)this.unavailableRepositories.get()) != null) {
            badRepos.remove(location);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            String key;
            block5: {
                if (this.repositories == null) {
                    this.restoreRepositories();
                }
                if (!this.repositories.containsKey(key = this.getKey(location))) break block5;
                return true;
            }
            int len = key.length();
            key = key.charAt(len - 1) == '_' ? key.substring(0, len - 1) : String.valueOf(key) + '_';
            return this.repositories.containsKey(key);
        }
    }

    public IArtifactRequest createDownloadRequest(IArtifactKey key, IPath destination) {
        return new FileDownloadRequest(key, destination);
    }

    private Object createExecutableExtension(IExtension extension, String element) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals(element)) {
                try {
                    return elements[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    this.log("Error loading repository extension: " + extension.getUniqueIdentifier(), e);
                    return null;
                }
            }
            ++i;
        }
        this.log("Malformed repository extension: " + extension.getUniqueIdentifier(), null);
        return null;
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination) {
        return this.createMirrorRequest(key, destination, null, null);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Properties destinationDescriptorProperties, Properties destinationRepositoryProperties) {
        return new MirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties);
    }

    public IArtifactRepository createRepository(URL location, String name, String type, Map properties) throws ProvisionException {
        IArtifactRepository result;
        IArtifactRepositoryFactory factory;
        IExtension extension;
        boolean loaded = false;
        try {
            this.loadRepository(location, null, type, true);
            loaded = true;
        }
        catch (ProvisionException provisionException) {}
        if (loaded) {
            this.fail(location, 1001);
        }
        if ((extension = RegistryFactory.getRegistry().getExtension("org.eclipse.equinox.p2.artifact.repository.artifactRepositories", type)) == null) {
            this.fail(location, 1005);
        }
        if ((factory = (IArtifactRepositoryFactory)this.createExecutableExtension(extension, EL_FACTORY)) == null) {
            this.fail(location, 1002);
        }
        if ((result = factory.create(location, name, type, properties)) == null) {
            this.fail(location, 1002);
        }
        this.clearNotFound(result.getLocation());
        this.addRepository(result);
        return result;
    }

    private void fail(URL location, int code) throws ProvisionException {
        String msg = null;
        switch (code) {
            case 1001: {
                msg = NLS.bind((String)Messages.repoMan_exists, (Object)location);
                break;
            }
            case 1005: {
                msg = NLS.bind((String)Messages.repoMan_unknownType, (Object)location);
                break;
            }
            case 1002: {
                msg = NLS.bind((String)Messages.repoMan_failedRead, (Object)location);
                break;
            }
            case 1000: {
                msg = NLS.bind((String)Messages.repoMan_notExists, (Object)location);
            }
        }
        if (msg == null) {
            msg = Messages.repoMan_internalError;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", code, msg, null));
    }

    private IExtension[] findMatchingRepositoryExtensions(String suffix, String type) {
        IExtension ext;
        IConfigurationElement[] elt = null;
        elt = type != null && type.length() > 0 ? ((ext = RegistryFactory.getRegistry().getExtension("org.eclipse.equinox.p2.artifact.repository.artifactRepositories", type)) != null ? ext.getConfigurationElements() : new IConfigurationElement[]{}) : RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.artifact.repository.artifactRepositories");
        int count = 0;
        int i = 0;
        while (i < elt.length) {
            if (EL_FILTER.equals(elt[i].getName())) {
                if (!suffix.equals(elt[i].getAttribute("suffix"))) {
                    elt[i] = null;
                } else {
                    ++count;
                }
            } else {
                elt[i] = null;
            }
            ++i;
        }
        IExtension[] results = new IExtension[count];
        int i2 = 0;
        while (i2 < elt.length) {
            if (elt[i2] != null) {
                results[--count] = elt[i2].getDeclaringExtension();
            }
            ++i2;
        }
        return results;
    }

    private String[] getAllSuffixes() {
        IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.artifact.repository.artifactRepositories");
        ArrayList<String> result = new ArrayList<String>(elements.length);
        result.add(DEFAULT_SUFFIX);
        int i = 0;
        while (i < elements.length) {
            String suffix;
            if (elements[i].getName().equals(EL_FILTER) && !result.contains(suffix = elements[i].getAttribute("suffix"))) {
                result.add(suffix);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String getKey(IArtifactRepository repository) {
        return this.getKey(repository.getLocation());
    }

    private String getKey(URL location) {
        return location.toExternalForm().replace('/', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getKnownRepositories(int flags) {
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            ArrayList<URL> result = new ArrayList<URL>();
            int i = 0;
            Iterator it = this.repositories.values().iterator();
            while (it.hasNext()) {
                RepositoryInfo info = (RepositoryInfo)it.next();
                if (this.matchesFlags(info, flags)) {
                    result.add(info.location);
                }
                ++i;
            }
            return result.toArray(new URL[result.size()]);
        }
    }

    private Preferences getPreferences() {
        return new ConfigurationScope().getNode("org.eclipse.equinox.p2.artifact.repository").node(NODE_REPOSITORIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IArtifactRepository getRepository(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            do {
                if (!it.hasNext()) {
                    return null;
                }
                info = (RepositoryInfo)it.next();
            } while (!URLUtil.sameURL((URL)info.location, (URL)location));
            if (info.repository == null) {
                return null;
            }
            IArtifactRepository repo = (IArtifactRepository)info.repository.get();
            if (repo != null) {
                this.addRepository(repo);
            }
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRepositoryProperty(URL location, String key) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            do {
                if (!it.hasNext()) {
                    return null;
                }
                info = (RepositoryInfo)it.next();
            } while (!URLUtil.sameURL((URL)info.location, (URL)location));
            if (KEY_DESCRIPTION.equals(key)) {
                return info.description;
            }
            if (KEY_NAME.equals(key)) {
                return info.name;
            }
            if ("p2.system".equals(key)) {
                return Boolean.toString(info.isSystem);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            Iterator it = this.repositories.values().iterator();
            while (it.hasNext()) {
                RepositoryInfo info = (RepositoryInfo)it.next();
                if (!URLUtil.sameURL((URL)info.location, (URL)location)) continue;
                return info.isEnabled;
            }
            return false;
        }
    }

    public IArtifactRepository loadRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        return this.loadRepository(location, monitor, null, true);
    }

    private IArtifactRepository loadRepository(URL location, IProgressMonitor monitor, String type, boolean signalAdd) throws ProvisionException {
        IArtifactRepository result = this.getRepository(location);
        if (result != null) {
            return result;
        }
        if (this.checkNotFound(location)) {
            this.fail(location, 1000);
        }
        String[] suffixes = this.sortSuffixes(this.getAllSuffixes(), location);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(suffixes.length * 100));
        int i = 0;
        while (i < suffixes.length) {
            result = this.loadRepository(location, suffixes[i], type, sub.newChild(100));
            if (result != null) {
                this.addRepository(result, signalAdd, suffixes[i]);
                return result;
            }
            ++i;
        }
        if (Boolean.valueOf(this.getRepositoryProperty(location, "p2.system")).booleanValue()) {
            this.removeRepository(location);
        } else {
            this.rememberNotFound(location);
        }
        this.fail(location, 1000);
        return null;
    }

    private IArtifactRepository loadRepository(URL location, String suffix, String type, SubMonitor monitor) {
        IExtension[] providers = this.findMatchingRepositoryExtensions(suffix, type);
        monitor.beginTask("", providers.length * 10);
        int i = 0;
        while (i < providers.length) {
            block4: {
                try {
                    IArtifactRepositoryFactory factory = (IArtifactRepositoryFactory)this.createExecutableExtension(providers[i], EL_FACTORY);
                    if (factory != null) {
                        return factory.load(location, (IProgressMonitor)monitor.newChild(10));
                    }
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 1000) break block4;
                    this.log("Unable to load repository: " + location, e);
                }
            }
            ++i;
        }
        return null;
    }

    protected void log(String message, Throwable t) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", message, t));
    }

    private boolean matchesFlags(RepositoryInfo info, int flags) {
        if ((flags & 1) == 1 && !info.isSystem) {
            return false;
        }
        if ((flags & 2) == 2 && info.isSystem) {
            return false;
        }
        if ((flags & 8) == 8 ? info.isEnabled : !info.isEnabled) {
            return false;
        }
        if ((flags & 4) == 4) {
            return "file".equals(info.location.getProtocol());
        }
        return true;
    }

    public void notify(EventObject o) {
        RepositoryEvent event;
        if (o instanceof RepositoryEvent && (event = (RepositoryEvent)o).getKind() == 4 && event.getRepositoryType() == 1) {
            this.addRepository(event.getRepositoryLocation(), event.isRepositoryEnabled());
        }
    }

    private boolean putValue(Preferences node, String key, String newValue) {
        String oldValue = node.get(key, null);
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        if (newValue == null) {
            node.remove(key);
        } else {
            node.put(key, newValue);
        }
        return true;
    }

    public IArtifactRepository refreshRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        this.clearNotFound(location);
        boolean wasEnabled = this.isEnabled(location);
        if (!this.removeRepository(location)) {
            this.fail(location, 1000);
        }
        try {
            IArtifactRepository result = this.loadRepository(location, monitor, null, true);
            if (!wasEnabled) {
                this.setEnabled(location, false);
            }
            return result;
        }
        catch (ProvisionException e) {
            this.addRepository(location);
            if (!wasEnabled) {
                this.setEnabled(location, false);
            }
            throw e;
        }
    }

    private void remember(IArtifactRepository repository, String suffix) {
        boolean changed = false;
        Preferences node = this.getPreferences().node(this.getKey(repository));
        changed |= this.putValue(node, KEY_URL, repository.getLocation().toExternalForm());
        changed |= this.putValue(node, KEY_DESCRIPTION, repository.getDescription());
        changed |= this.putValue(node, KEY_NAME, repository.getName());
        changed |= this.putValue(node, KEY_PROVIDER, repository.getProvider());
        changed |= this.putValue(node, KEY_TYPE, repository.getType());
        changed |= this.putValue(node, KEY_VERSION, repository.getVersion());
        changed |= this.putValue(node, KEY_SYSTEM, (String)repository.getProperties().get("p2.system"));
        if (changed |= this.putValue(node, "suffix", suffix)) {
            this.saveToPreferences();
        }
    }

    private void remember(RepositoryInfo info) {
        boolean changed = false;
        Preferences node = this.getPreferences().node(this.getKey(info.location));
        changed |= this.putValue(node, KEY_URL, info.location.toExternalForm());
        changed |= this.putValue(node, KEY_SYSTEM, Boolean.toString(info.isSystem));
        changed |= this.putValue(node, KEY_DESCRIPTION, info.description);
        changed |= this.putValue(node, KEY_NAME, info.name);
        changed |= this.putValue(node, KEY_ENABLED, Boolean.toString(info.isEnabled));
        if (changed |= this.putValue(node, "suffix", info.suffix)) {
            this.saveToPreferences();
        }
    }

    private void rememberNotFound(URL location) {
        List<URL> badRepos;
        if (this.unavailableRepositories != null && (badRepos = (List)this.unavailableRepositories.get()) != null) {
            badRepos.add(location);
            return;
        }
        badRepos = new ArrayList();
        badRepos.add(location);
        this.unavailableRepositories = new SoftReference(badRepos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRepository(URL toRemove) {
        Assert.isNotNull((Object)toRemove);
        String repoKey = this.getKey(toRemove);
        Object object = this.repositoryLock;
        synchronized (object) {
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if (this.repositories.remove(repoKey) == null) {
                return false;
            }
        }
        try {
            this.getPreferences().node(repoKey).removeNode();
            this.saveToPreferences();
        }
        catch (BackingStoreException e) {
            this.log("Error saving preferences", e);
        }
        this.broadcastChangeEvent(toRemove, 1, 1, true);
        return true;
    }

    private void restoreDownloadCache() {
        AgentLocation location;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((location = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        try {
            this.loadRepository(location.getArtifactRepositoryURL(), null);
            return;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", "Error occurred while loading download cache.", (Throwable)e));
            }
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                this.createRepository(location.getArtifactRepositoryURL(), "download cache", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            catch (ProvisionException e2) {
                LogHelper.log((ProvisionException)e2);
            }
            return;
        }
    }

    private void restoreFromPreferences() {
        String[] children;
        Preferences node = this.getPreferences();
        try {
            children = node.childrenNames();
        }
        catch (BackingStoreException e) {
            this.log("Error restoring repositories from preferences", e);
            return;
        }
        int i = 0;
        while (i < children.length) {
            Preferences child = node.node(children[i]);
            String locationString = child.get(KEY_URL, null);
            if (locationString != null) {
                try {
                    RepositoryInfo info = new RepositoryInfo();
                    info.location = new URL(locationString);
                    info.name = child.get(KEY_NAME, null);
                    info.description = child.get(KEY_DESCRIPTION, null);
                    info.isSystem = child.getBoolean(KEY_SYSTEM, false);
                    info.isEnabled = child.getBoolean(KEY_ENABLED, true);
                    info.suffix = child.get("suffix", null);
                    this.repositories.put(this.getKey(info.location), info);
                }
                catch (MalformedURLException e) {
                    this.log("Error while restoring repository: " + locationString, e);
                }
            }
            ++i;
        }
        this.saveToPreferences();
    }

    private void restoreFromSystemProperty() {
        String locationString = Activator.getContext().getProperty("eclipse.p2.artifactRepository");
        if (locationString != null) {
            StringTokenizer tokenizer = new StringTokenizer(locationString, ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    this.addRepository(new URL(tokenizer.nextToken()));
                }
                catch (MalformedURLException e) {
                    this.log("Error while restoring repository " + locationString, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreRepositories() {
        Object object = this.repositoryLock;
        synchronized (object) {
            this.repositories = new HashMap();
            this.restoreDownloadCache();
            this.restoreFromSystemProperty();
            this.restoreFromPreferences();
        }
    }

    private void saveToPreferences() {
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            this.log("Error while saving repositories in preferences", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(URL location, boolean enablement) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(this.getKey(location))) == null || info.isEnabled == enablement) {
                return;
            }
            info.isEnabled = enablement;
            this.remember(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] sortSuffixes(String[] suffixes, URL location) {
        Object object = this.repositoryLock;
        synchronized (object) {
            RepositoryInfo info;
            if (this.repositories == null) {
                this.restoreRepositories();
            }
            if ((info = (RepositoryInfo)this.repositories.get(this.getKey(location))) == null || info.suffix == null) {
                return suffixes;
            }
            String lastSuffix = info.suffix;
            int i = 0;
            while (i < suffixes.length) {
                if (lastSuffix.equals(suffixes[i])) {
                    System.arraycopy(suffixes, 0, suffixes, 1, i);
                    suffixes[0] = lastSuffix;
                    return suffixes;
                }
                ++i;
            }
        }
        return suffixes;
    }

    static class RepositoryInfo {
        String description;
        boolean isSystem = false;
        boolean isEnabled = true;
        URL location;
        String name;
        String suffix;
        SoftReference repository;

        RepositoryInfo() {
        }
    }
}

