/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.provisional.equinox.p2.jarprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipException;
import org.eclipse.equinox.internal.p2.jarprocessor.PackStep;
import org.eclipse.equinox.internal.p2.jarprocessor.PackUnpackStep;
import org.eclipse.equinox.internal.p2.jarprocessor.SignCommandStep;
import org.eclipse.equinox.internal.p2.jarprocessor.UnpackStep;
import org.eclipse.equinox.internal.p2.jarprocessor.Utils;
import org.eclipse.equinox.internal.p2.jarprocessor.ZipProcessor;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;

public class JarProcessorExecutor {
    public void runJarProcessor(Options options) {
        block18: {
            Properties properties;
            JarProcessor packProcessor;
            JarProcessor processor;
            block20: {
                File packProperties;
                if (options.input.isFile() && options.input.getName().endsWith(".zip")) {
                    ZipProcessor processor2 = new ZipProcessor();
                    processor2.setWorkingDirectory(options.outputDir);
                    processor2.setSignCommand(options.signCommand);
                    processor2.setPack(options.pack);
                    processor2.setRepack(options.repack || options.pack && options.signCommand != null);
                    processor2.setUnpack(options.unpack);
                    processor2.setVerbose(options.verbose);
                    processor2.setProcessAll(options.processAll);
                    try {
                        processor2.processZip(options.input);
                    }
                    catch (ZipException e) {
                        if (options.verbose) {
                            e.printStackTrace();
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        if (options.verbose) {
                            e.printStackTrace();
                        }
                        break block18;
                    }
                }
                processor = new JarProcessor();
                packProcessor = null;
                processor.setWorkingDirectory(options.outputDir);
                processor.setProcessAll(options.processAll);
                processor.setVerbose(options.verbose);
                properties = new Properties();
                if (options.input.isDirectory() && (packProperties = new File(options.input, "pack.properties")).exists() && packProperties.isFile()) {
                    BufferedInputStream in = null;
                    try {
                        try {
                            in = new BufferedInputStream(new FileInputStream(packProperties));
                            properties.load(in);
                        }
                        catch (IOException e) {
                            if (options.verbose) {
                                e.printStackTrace();
                            }
                            Utils.close(in);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.close(in);
                        throw throwable;
                    }
                    Utils.close(in);
                }
            }
            if (options.unpack) {
                this.addUnpackStep(processor, properties, options);
            }
            if (options.repack || options.pack && options.signCommand != null) {
                this.addPackUnpackStep(processor, properties, options);
            }
            if (options.signCommand != null) {
                this.addSignStep(processor, properties, options);
            }
            if (options.pack) {
                packProcessor = new JarProcessor();
                packProcessor.setWorkingDirectory(options.outputDir);
                packProcessor.setProcessAll(options.processAll);
                packProcessor.setVerbose(options.verbose);
                this.addPackStep(packProcessor, properties, options);
            }
            try {
                this.process(options.input, options.unpack ? Utils.PACK_GZ_FILTER : Utils.JAR_FILTER, options.verbose, processor, packProcessor);
            }
            catch (FileNotFoundException e) {
                if (!options.verbose) break block18;
                e.printStackTrace();
            }
        }
    }

    protected void process(File input, FileFilter filter, boolean verbose, JarProcessor processor, JarProcessor packProcessor) throws FileNotFoundException {
        if (!input.exists()) {
            throw new FileNotFoundException();
        }
        File[] files = null;
        if (input.isDirectory()) {
            files = input.listFiles();
        } else if (filter.accept(input)) {
            files = new File[]{input};
        } else {
            return;
        }
        int i = 0;
        while (i < files.length) {
            block14: {
                if (files[i].isDirectory()) {
                    String dir = processor.getWorkingDirectory();
                    processor.setWorkingDirectory(String.valueOf(dir) + "/" + files[i].getName());
                    if (packProcessor != null) {
                        packProcessor.setWorkingDirectory(String.valueOf(dir) + "/" + files[i].getName());
                    }
                    this.process(files[i], filter, verbose, processor, packProcessor);
                    processor.setWorkingDirectory(dir);
                    if (packProcessor != null) {
                        packProcessor.setWorkingDirectory(dir);
                    }
                } else if (filter.accept(files[i])) {
                    try {
                        File result = processor.processJar(files[i]);
                        if (packProcessor != null && result != null && result.exists()) {
                            packProcessor.processJar(result);
                        }
                    }
                    catch (IOException e) {
                        if (!verbose) break block14;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public void addPackUnpackStep(JarProcessor processor, Properties properties, Options options) {
        processor.addProcessStep(new PackUnpackStep(properties, options.verbose));
    }

    public void addSignStep(JarProcessor processor, Properties properties, Options options) {
        processor.addProcessStep(new SignCommandStep(properties, options.signCommand, options.verbose));
    }

    public void addPackStep(JarProcessor processor, Properties properties, Options options) {
        processor.addProcessStep(new PackStep(properties, options.verbose));
    }

    public void addUnpackStep(JarProcessor processor, Properties properties, Options options) {
        processor.addProcessStep(new UnpackStep(properties, options.verbose));
    }

    public static class Options {
        public String outputDir = ".";
        public String signCommand = null;
        public boolean pack = false;
        public boolean repack = false;
        public boolean unpack = false;
        public boolean verbose = false;
        public boolean processAll = false;
        public File input = null;
    }
}

