/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DefaultExpressionModelProxy;

public class ExpressionEventHandler
extends DebugEventHandler {
    public ExpressionEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    protected boolean handlesEvent(DebugEvent event) {
        return event.getKind() == 16;
    }

    protected void handleChange(DebugEvent event) {
        DefaultExpressionModelProxy proxy;
        AbstractModelProxy modelProxy;
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getExpressionManager(), 0);
        IExpression expression = null;
        if (event.getSource() instanceof IExpression) {
            expression = (IExpression)event.getSource();
            int flags = 0;
            if ((event.getDetail() & 0x100) != 0) {
                flags |= 0x800;
            }
            if ((event.getDetail() & 0x200) != 0) {
                flags |= 0x400;
            }
            delta.addNode(expression, flags);
            this.fireDelta(delta);
        } else if (event.getSource() instanceof IVariable && (modelProxy = this.getModelProxy()) instanceof DefaultExpressionModelProxy && (expression = (proxy = (DefaultExpressionModelProxy)modelProxy).getExpression()) instanceof IWatchExpression) {
            ((IWatchExpression)expression).evaluate();
        }
    }

    protected void refreshRoot(DebugEvent event) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getExpressionManager(), 1024);
        this.fireDelta(delta);
    }
}

