/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class ProcessProxy
extends EventHandlerModelProxy {
    private IProcess fProcess;
    private DebugEventHandler fProcessEventHandler = new DebugEventHandler(this){

        protected boolean handlesEvent(DebugEvent event) {
            return event.getSource().equals(ProcessProxy.this.fProcess);
        }

        protected void handleChange(DebugEvent event) {
            this.fireDelta(2048);
        }

        protected void handleCreate(DebugEvent event) {
        }

        protected void handleTerminate(DebugEvent event) {
            this.fireDelta(0x800800);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireDelta(int flags) {
            ModelDelta delta = null;
            ProcessProxy processProxy = ProcessProxy.this;
            synchronized (processProxy) {
                if (!this.isDisposed()) {
                    ModelDelta node = delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                    node = node.addNode(ProcessProxy.this.fProcess.getLaunch(), 0);
                    node.addNode(ProcessProxy.this.fProcess, flags);
                }
            }
            if (delta != null && !this.isDisposed()) {
                ProcessProxy.this.fireModelChanged(delta);
            }
        }
    };

    public synchronized void dispose() {
        super.dispose();
        this.fProcess = null;
    }

    public ProcessProxy(IProcess process) {
        this.fProcess = process;
    }

    protected synchronized boolean containsEvent(DebugEvent event) {
        return event.getSource().equals(this.fProcess);
    }

    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{this.fProcessEventHandler};
    }

    public void installed(Viewer viewer) {
        ILaunch launch;
        super.installed(viewer);
        IProcess process = this.fProcess;
        if (process != null && (launch = process.getLaunch()) != null && "run".equals(launch.getLaunchMode())) {
            ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
            ModelDelta node = delta.addNode(process.getLaunch(), 0);
            node = node.addNode(process, 0x200000);
            this.fireModelChanged(delta);
        }
    }
}

