/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items;
    int lastSelected = -1;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        int[] context = new int[1];
        OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
        OS.CGContextSaveGState(context[0]);
        CGRect rect = new CGRect();
        OS.HIViewGetBounds(this.handle, rect);
        OS.CGContextAddRect(context[0], rect);
        OS.CGContextClip(context[0]);
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        OS.CGContextRestoreGState(context[0]);
        return result;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (wHint == -1 && this.items.length > 0) {
            int width = 0;
            GC gc = new GC(this);
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    width += this.items[i].calculateWidth(gc);
                }
                ++i;
            }
            gc.dispose();
            Rectangle trim = this.computeTrim(0, 0, width, 0);
            size.x = Math.max(trim.width, size.x);
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        CGRect oldBounds;
        this.checkWidget();
        CGRect bounds = oldBounds = new CGRect();
        OS.HIViewGetFrame(this.handle, oldBounds);
        int MIN_SIZE = 100;
        if (oldBounds.width < (float)MIN_SIZE || oldBounds.height < (float)MIN_SIZE) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
            bounds = new CGRect();
            bounds.height = 100.0f;
            bounds.width = 100.0f;
            OS.HIViewSetFrame(this.handle, bounds);
        }
        Rect client = new Rect();
        OS.GetTabContentRect(this.handle, client);
        if (oldBounds.width < (float)MIN_SIZE || oldBounds.height < (float)MIN_SIZE) {
            OS.HIViewSetFrame(this.handle, oldBounds);
            OS.HIViewSetDrawingEnabled(this.handle, this.drawCount == 0);
        }
        x -= client.left;
        y -= client.top;
        width += (int)bounds.width - (client.right - client.left);
        height += (int)bounds.height - (client.bottom - client.top);
        Rect inset = this.getInset();
        x -= inset.left;
        y -= inset.top;
        return new Rectangle(-client.left, -client.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        short direction = (this.style & 0x400) != 0 ? (short)1 : 0;
        OS.CreateTabsControl(window, new Rect(), (short)0, direction, (short)0, 0, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void createItem(TabItem item, int index) {
        int count = OS.GetControl32BitMaximum(this.handle);
        if (index < 0 || index > count) {
            this.error(6);
        }
        OS.SetControl32BitMaximum(this.handle, count + 1);
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        if (count == 0) {
            OS.SetControl32BitValue(this.handle, 1);
            this.lastSelected = 0;
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem item) {
        int count = OS.GetControl32BitMaximum(this.handle);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        this.redrawWidget(this.handle, false);
        int selectionIndex = OS.GetControl32BitValue(this.handle) - 1;
        OS.SetControl32BitMaximum(this.handle, --count);
        System.arraycopy(this.items, index + 1, this.items, index, count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new TabItem[4];
        }
        int i = index;
        while (i < count) {
            this.items[i].update();
            ++i;
        }
        if (count > 0 && index == selectionIndex) {
            this.setSelection(Math.max(0, selectionIndex - 1), true, true);
        }
        this.invalidateVisibleRegion(this.handle);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect client = new Rect();
        if (OS.GetControlData(this.handle, (short)0, 1919247220, 8, client, null) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = Math.max(0, client.left);
        int y = Math.max(0, client.top);
        int width = Math.max(0, client.right - client.left);
        int height = Math.max(0, client.bottom - client.top);
        return new Rectangle(x, y, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum(this.handle);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int count = OS.GetControl32BitMaximum(this.handle);
        int index = 0;
        while (index < count) {
            TabItem item = this.items[index];
            Rectangle bounds = item.getBounds();
            if (bounds.contains(point)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.handle);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum(this.handle);
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.GetControl32BitValue(this.handle) - 1;
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.handle) - 1;
    }

    float getThemeAlpha() {
        return 0.25f * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.GetControl32BitMaximum(this.handle);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = OS.GetControl32BitMaximum(this.handle);
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    Rect getInset() {
        if (OS.VERSION >= 4128) {
            return super.getInset();
        }
        return (this.style & 0x400) != 0 ? this.display.tabFolderSouthInset : this.display.tabFolderNorthInset;
    }

    int kEventControlApplyBackground(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        Control control;
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int index = OS.GetControl32BitValue(this.handle) - 1;
        if (index == this.lastSelected) {
            return result;
        }
        this.lastSelected = index;
        int count = OS.GetControl32BitMaximum(this.handle);
        int i = 0;
        while (i < count) {
            if (i != index && (control = this.items[i].control) != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            ++i;
        }
        TabItem item = null;
        if (index != -1) {
            item = this.items[index];
        }
        if (item != null && (control = item.control) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        short[] part = new short[1];
        OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
        if (part[0] == 0 || part[0] == -1) {
            return super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TabItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int count = OS.GetControl32BitMaximum(this.handle);
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int index;
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x80) != 0 && (index = OS.GetControl32BitValue(this.handle) - 1) != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return result;
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = OS.GetControl32BitMaximum(this.handle);
        if (index < 0 || index >= count) {
            return;
        }
        this.setSelection(index, false, false);
    }

    void setSelection(int index, boolean notify, boolean force) {
        Control control;
        TabItem item;
        if (index >= OS.GetControl32BitMaximum(this.handle)) {
            return;
        }
        int currentIndex = OS.GetControl32BitValue(this.handle) - 1;
        if (!force && currentIndex == index) {
            return;
        }
        if (currentIndex != -1 && (item = this.items[currentIndex]) != null && (control = item.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        OS.SetControl32BitValue(this.handle, index + 1);
        index = OS.GetControl32BitValue(this.handle) - 1;
        if (this.hasFocus()) {
            int window = OS.GetControlOwner(this.handle);
            OS.SetKeyboardFocus(window, this.handle, (short)(index + 1));
        }
        this.lastSelected = index;
        if (index != -1 && (item = this.items[index]) != null) {
            control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true, false);
        return index == this.getSelectionIndex();
    }
}

