/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.LaunchConfigurationAction;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LiteLaunchShortcutsAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fCreatedMenu;
    private ILaunchGroup fGroup;
    private boolean fInitialized = false;

    public LiteLaunchShortcutsAction(String string) {
        this.fGroup = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(string);
        ILaunchMode iLaunchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.fGroup.getMode());
        this.setText(iLaunchMode.getLaunchAsLabel());
        this.setMenuCreator(this);
        this.setEnabled(this.existsConfigTypesForMode());
    }

    public void run() {
    }

    public void dispose() {
        if (this.fCreatedMenu != null) {
            this.fCreatedMenu.dispose();
        }
    }

    public Menu getMenu(Control control) {
        return null;
    }

    public Menu getMenu(Menu menu) {
        if (this.fCreatedMenu != null) {
            this.fCreatedMenu.dispose();
        }
        this.fCreatedMenu = new Menu(menu);
        this.initMenu();
        return this.fCreatedMenu;
    }

    private IEvaluationContext createContext() {
        IWorkbenchPage iWorkbenchPage;
        List<Object> list = null;
        IWorkbenchWindow iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            ISelection iSelection;
            ISelectionProvider iSelectionProvider;
            IWorkbenchPartSite iWorkbenchPartSite;
            IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
            if (iWorkbenchPart instanceof IEditorPart) {
                list = new ArrayList<IEditorInput>();
                list.add(((IEditorPart)iWorkbenchPart).getEditorInput());
            } else if (iWorkbenchPart != null && (iWorkbenchPartSite = iWorkbenchPart.getSite()) != null && (iSelectionProvider = iWorkbenchPartSite.getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof IStructuredSelection) {
                list = ((IStructuredSelection)iSelection).toList();
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        iWorkbenchPage = new EvaluationContext(null, (Object)list);
        iWorkbenchPage.setAllowPluginActivation(true);
        iWorkbenchPage.addVariable("selection", list);
        return iWorkbenchPage;
    }

    private void fillMenu() {
        ActionContributionItem actionContributionItem;
        Set set;
        Object object;
        IEvaluationContext iEvaluationContext = this.createContext();
        int n = 1;
        List list = this.getLaunchConfigurationManager().getLaunchShortcuts(this.fGroup.getCategory());
        Iterator iterator = list.iterator();
        ArrayList<LaunchShortcutExtension> arrayList = new ArrayList<LaunchShortcutExtension>(10);
        while (iterator.hasNext()) {
            object = (LaunchShortcutExtension)iterator.next();
            try {
                if (WorkbenchActivityHelper.filterItem((Object)object) || !this.isApplicable((LaunchShortcutExtension)object, iEvaluationContext) || !"org.eclipse.jdt.debug.ui.localJavaShortcut".equals(object.getId())) continue;
                arrayList.add((LaunchShortcutExtension)object);
            }
            catch (CoreException coreException) {}
        }
        try {
            object = this.getLaunchConfigurationManager().isSharedConfig(this.getSelection(iEvaluationContext));
            if (object != null && object.exists() && object.supportsMode(this.getMode())) {
                set = new LaunchConfigurationAction((ILaunchConfiguration)object, this.getMode(), object.getName(), DebugUITools.getDefaultImageDescriptor((Object)object), n++);
                actionContributionItem = new ActionContributionItem((IAction)set);
                actionContributionItem.fill(this.fCreatedMenu, -1);
                if (!arrayList.isEmpty()) {
                    new MenuItem(this.fCreatedMenu, 2);
                }
            }
        }
        catch (CoreException coreException) {
            DebugUIPlugin.log((Throwable)coreException);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (LaunchShortcutExtension)iterator.next();
            set = object.getModes();
            actionContributionItem = set.iterator();
            while (actionContributionItem.hasNext()) {
                String string = (String)actionContributionItem.next();
                if (!string.equals(this.getMode())) continue;
                this.populateMenuItem(string, (LaunchShortcutExtension)object, this.fCreatedMenu, n++);
            }
        }
        if (n == 1) {
            object = new Action(ActionMessages.LaunchShortcutsAction_1){};
            object.setEnabled(false);
            set = new ActionContributionItem((IAction)object);
            set.fill(this.fCreatedMenu, -1);
        }
    }

    private Object getSelection(IEvaluationContext iEvaluationContext) {
        List list = (List)iEvaluationContext.getVariable("selection");
        return list.isEmpty() ? null : list.get(0);
    }

    private void populateMenuItem(String string, LaunchShortcutExtension launchShortcutExtension, Menu menu, int n) {
        String string2;
        LaunchShortcutAction launchShortcutAction = new LaunchShortcutAction(string, launchShortcutExtension);
        launchShortcutAction.setActionDefinitionId(String.valueOf(launchShortcutExtension.getId()) + "." + string);
        String string3 = launchShortcutExtension.getHelpContextId();
        if (string3 != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)launchShortcutAction, string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0 && n < 10) {
            stringBuffer.append('&');
            stringBuffer.append(n);
            stringBuffer.append(' ');
        }
        stringBuffer.append((string2 = launchShortcutExtension.getContextLabel(string)) != null ? string2 : launchShortcutAction.getText());
        launchShortcutAction.setText(stringBuffer.toString());
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)launchShortcutAction);
        actionContributionItem.fill(menu, -1);
    }

    private boolean isApplicable(LaunchShortcutExtension launchShortcutExtension, IEvaluationContext iEvaluationContext) throws CoreException {
        Expression expression = launchShortcutExtension.getContextualLaunchEnablementExpression();
        return launchShortcutExtension.evalEnablementExpression(iEvaluationContext, expression);
    }

    private void initMenu() {
        this.fCreatedMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.widget;
                MenuItem[] menuItemArray = menu.getItems();
                int n = 0;
                while (n < menuItemArray.length) {
                    menuItemArray[n].dispose();
                    ++n;
                }
                LiteLaunchShortcutsAction.this.fillMenu();
            }
        });
    }

    protected String getMode() {
        return this.fGroup.getMode();
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (!this.fInitialized) {
            iAction.setEnabled(this.existsConfigTypesForMode());
            this.fInitialized = true;
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int n = 0;
        while (n < iLaunchConfigurationTypeArray.length) {
            ILaunchConfigurationType iLaunchConfigurationType = iLaunchConfigurationTypeArray[n];
            if (iLaunchConfigurationType.supportsMode(this.getMode())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

