/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.actions.NavigateActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.soc.ide4edu.ui.view.LiteLaunchShortcutsAction;
import org.eclipse.soc.ide4edu.ui.view.LitePackageExplorerContentProvider;
import org.eclipse.soc.ide4edu.ui.view.LitePackageExplorerProblemTreeViewer;
import org.eclipse.soc.ide4edu.ui.view.OpenNewLiteClassWizardAction;
import org.eclipse.soc.ide4edu.ui.view.OpenNewLiteJavaProjectWizardAction;
import org.eclipse.soc.ide4edu.ui.view.OpenNewLitePackageWizardAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class LitePackageExplorer
extends ViewPart
implements IPropertyChangeListener,
ISetSelectionTarget {
    private LitePackageExplorerProblemTreeViewer viewer;
    private Action newClassAction;
    private Action newPackageAction;
    private Action newProjectAction;
    private Action doubleClickAction;
    private Action deleteAction;
    private Action runAsAction;
    private Action runLastAction;
    private LitePackageExplorerContentProvider contentProvider;
    private PackageExplorerLabelProvider labelProvider;
    private NavigateActionGroup navigateActionGroup;
    public static String ID = "org.eclipse.soc.ide4edu.ui.view.LitePackageExplorer";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite composite) {
        this.viewer = new LitePackageExplorerProblemTreeViewer(composite, 770);
        this.contentProvider = new LitePackageExplorerContentProvider(false);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new PackageExplorerLabelProvider((PackageExplorerContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.viewer.setUseHashlookup(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.navigateActionGroup = new NavigateActionGroup((IViewPart)this);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.viewer.setInput(this.findInputElement());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                IAction iAction = LitePackageExplorer.this.navigateActionGroup.getOpenAction();
                if (iAction != null && iAction.isEnabled()) {
                    iAction.run();
                    return;
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = false;
                if (selectionChangedEvent.getSelection().isEmpty()) {
                    return;
                }
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    Object object;
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    if (iStructuredSelection instanceof TreeSelection) {
                        TreeSelection treeSelection = (TreeSelection)iStructuredSelection;
                        Object object2 = treeSelection.getFirstElement();
                        if (object2 instanceof CompilationUnit) {
                            bl = true;
                        }
                    } else if (iStructuredSelection instanceof StructuredSelection && (object = iStructuredSelection.getFirstElement()) instanceof CompilationUnit) {
                        bl = true;
                    }
                }
                LitePackageExplorer.this.runAsAction.setEnabled(bl);
            }
        });
        this.setPartName("Lite Java Project Explorer");
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                LitePackageExplorer.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.newClassAction);
        iMenuManager.add((IAction)this.newPackageAction);
        iMenuManager.add((IAction)this.newProjectAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.deleteAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.runAsAction);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.newClassAction);
        iMenuManager.add((IAction)this.newPackageAction);
        iMenuManager.add((IAction)this.newProjectAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.deleteAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.runAsAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.newClassAction);
        iToolBarManager.add((IAction)this.newPackageAction);
        iToolBarManager.add((IAction)this.newProjectAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.deleteAction);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.newClassAction = new OpenNewLiteClassWizardAction();
        this.newPackageAction = new OpenNewLitePackageWizardAction();
        this.newProjectAction = new OpenNewLiteJavaProjectWizardAction();
        this.deleteAction = new DeleteAction((IWorkbenchSite)this.getSite());
        this.runAsAction = new LiteLaunchShortcutsAction("org.eclipse.debug.ui.launchGroup.run");
        this.runAsAction.setEnabled(false);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                LitePackageExplorer.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String string) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)string);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.viewer == null) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                LitePackageExplorer.this.viewer.refresh();
            }
        });
    }

    private Object findInputElement() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)iAdaptable).getRoot());
        }
        if (iAdaptable instanceof IContainer) {
            IJavaElement iJavaElement = JavaCore.create((IResource)((IContainer)iAdaptable));
            if (iJavaElement != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            return iAdaptable;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public void selectReveal(ISelection iSelection) {
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.contentProvider.runPendingUpdates();
        this.viewer.setSelection(this.convertSelection(iSelection), true);
    }

    public ISelection convertSelection(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return iSelection;
        }
        Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            Object object = this.convertElement(objectArray[n]);
            bl = bl || object != objectArray[n];
            objectArray[n] = object;
            ++n;
        }
        if (bl) {
            return new StructuredSelection(objectArray);
        }
        return iSelection;
    }

    private Object convertElement(Object object) {
        if (object instanceof IJavaElement) {
            IResource iResource;
            ICompilationUnit iCompilationUnit;
            IJavaProject iJavaProject;
            if (object instanceof ICompilationUnit && (iJavaProject = (iCompilationUnit = (ICompilationUnit)object).getJavaProject()) != null && iJavaProject.exists() && !iJavaProject.isOnClasspath((IJavaElement)iCompilationUnit) && (iResource = iCompilationUnit.getResource()) != null) {
                return iResource;
            }
            return object;
        }
        if (object instanceof IResource) {
            IJavaProject iJavaProject;
            IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)object));
            if (iJavaElement != null && iJavaElement.exists() && (iJavaProject = iJavaElement.getJavaProject()) != null && iJavaProject.exists()) {
                return iJavaElement;
            }
        } else if (object instanceof IAdaptable) {
            IResource iResource;
            IJavaElement iJavaElement;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) != null) {
                iJavaElement = JavaCore.create((IResource)iResource);
                if (iJavaElement != null && iJavaElement.exists()) {
                    return iJavaElement;
                }
                return iResource;
            }
        }
        return object;
    }
}

