/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soc.ide4edu.ui.view;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soc.ide4edu.ui.view.NewLiteClassCreationWizard;
import org.eclipse.soc.ide4edu.ui.view.NewLiteClassWizardPage;
import org.eclipse.soc.ide4edu.ui.view.OpenNewLiteJavaProjectWizardAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class OpenNewLiteClassWizardAction
extends AbstractOpenWizardAction {
    private NewLiteClassWizardPage fPage;
    private boolean fOpenEditorOnFinish;

    public OpenNewLiteClassWizardAction() {
        this.setText("New Java Class");
        this.setDescription("Create a new Java class.");
        this.setToolTipText("New Java Class");
        this.setImageDescriptor(JavaPluginImages.DESC_TOOL_NEWCLASS);
        this.fPage = new NewLiteClassWizardPage();
        this.fOpenEditorOnFinish = true;
    }

    public void setConfiguredWizardPage(NewLiteClassWizardPage newLiteClassWizardPage) {
        this.fPage = newLiteClassWizardPage;
    }

    public void setOpenEditorOnFinish(boolean bl) {
        this.fOpenEditorOnFinish = bl;
    }

    protected final INewWizard createWizard() throws CoreException {
        return new NewLiteClassCreationWizard(this.fPage, this.fOpenEditorOnFinish);
    }

    protected boolean doCreateProjectFirstOnEmptyWorkspace(Shell shell) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot.getProjects().length == 0) {
            String string = NewWizardMessages.AbstractOpenWizardAction_noproject_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_noproject_message;
            if (MessageDialog.openQuestion((Shell)shell, (String)string, (String)string2)) {
                new OpenNewLiteJavaProjectWizardAction().run();
                return iWorkspaceRoot.getProjects().length != 0;
            }
            return false;
        }
        return true;
    }
}

