/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.preview;

import org.eclipse.epp.usagedata.internal.recording.filtering.FilterUtils;
import org.eclipse.epp.usagedata.internal.recording.filtering.PreferencesBasedFilter;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class AddFilterDialog {
    private final PreferencesBasedFilter filter;

    public AddFilterDialog(PreferencesBasedFilter filter) {
        this.filter = filter;
    }

    public void prompt(Shell shell, String suggestion) {
        InputDialog dialog = new InputDialog(shell, "New filter", "Provide a bundle name pattern. Bundles ids that match this pattern will not be uploaded.", suggestion, this.getValidator());
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        this.filter.addPattern(dialog.getValue().trim());
    }

    IInputValidator getValidator() {
        return new IInputValidator(){

            public String isValid(String pattern) {
                if (pattern == null) {
                    return null;
                }
                if ((pattern = pattern.trim()).length() == 0) {
                    return null;
                }
                if (AddFilterDialog.this.alreadyHasPattern(pattern)) {
                    return "You are already filtering this pattern.";
                }
                if (!FilterUtils.isValidBundleIdPattern((String)pattern)) {
                    return "The pattern is not valid.";
                }
                return null;
            }
        };
    }

    boolean alreadyHasPattern(String pattern) {
        return this.filter.includesPattern(pattern);
    }
}

