/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.provisional.p2.core.repository.IRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MirrorSelector {
    private static final double LOG2 = Math.log(2.0);
    URI baseURI;
    MirrorInfo[] mirrors;
    private final IRepository repository;
    private final Random random = new Random();

    public MirrorSelector(IRepository repository) {
        this.repository = repository;
        try {
            String base = (String)repository.getProperties().get("p2.mirrorsBaseURL");
            if (base != null) {
                this.baseURI = new URI(base);
            } else {
                URL repositoryURL = repository.getLocation();
                if (repositoryURL != null) {
                    this.baseURI = URLUtil.toURI((URL)repositoryURL);
                }
            }
        }
        catch (URISyntaxException e) {
            this.log("Error initializing mirrors for: " + repository.getLocation(), e);
        }
    }

    private MirrorInfo[] computeMirrors(String mirrorsURL) {
        Document document;
        block5: {
            String countryCode = Locale.getDefault().getCountry().toLowerCase();
            int timeZone = new GregorianCalendar().get(15) / 3600000;
            mirrorsURL = mirrorsURL.indexOf(63) != -1 ? String.valueOf(mirrorsURL) + '&' : String.valueOf(mirrorsURL) + '?';
            mirrorsURL = String.valueOf(mirrorsURL) + "countryCode=" + countryCode + "&timeZone=" + timeZone + "&responseType=xml";
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            document = builder.parse(mirrorsURL);
            if (document != null) break block5;
            return null;
        }
        try {
            NodeList mirrorNodes = document.getElementsByTagName("mirror");
            int mirrorCount = mirrorNodes.getLength();
            MirrorInfo[] infos = new MirrorInfo[mirrorCount + 1];
            int i = 0;
            while (i < mirrorCount) {
                Element mirrorNode = (Element)mirrorNodes.item(i);
                String infoURL = mirrorNode.getAttribute("url");
                infos[i] = new MirrorInfo(infoURL, i);
                ++i;
            }
            infos[mirrorCount] = new MirrorInfo(this.baseURI.toString(), mirrorCount);
            return infos;
        }
        catch (Exception e) {
            if (mirrorsURL != null && (mirrorsURL.startsWith("http://") || mirrorsURL.startsWith("https://") || mirrorsURL.startsWith("file://") || mirrorsURL.startsWith("ftp://") || mirrorsURL.startsWith("jar://"))) {
                this.log("Error processing mirrors URL: " + mirrorsURL, e);
            }
            return null;
        }
    }

    public synchronized String getMirrorLocation(String inputLocation) {
        URI relativeLocation;
        block8: {
            Assert.isNotNull((Object)inputLocation);
            if (this.baseURI == null) {
                return inputLocation;
            }
            relativeLocation = null;
            try {
                relativeLocation = this.baseURI.relativize(new URI(inputLocation));
            }
            catch (URISyntaxException e) {
                if (!Tracing.DEBUG_MIRRORS) break block8;
                this.log("Unable to make location relative: " + inputLocation, e);
            }
        }
        if (relativeLocation == null || relativeLocation.isAbsolute()) {
            return inputLocation;
        }
        MirrorInfo selectedMirror = this.selectMirror();
        if (selectedMirror == null) {
            return inputLocation;
        }
        if (Tracing.DEBUG_MIRRORS) {
            Tracing.debug((String)("Selected mirror for artifact " + inputLocation + ": " + selectedMirror));
        }
        try {
            return new URL(String.valueOf(selectedMirror.locationString) + relativeLocation.getPath()).toExternalForm();
        }
        catch (MalformedURLException e) {
            this.log("Unable to make location " + inputLocation + " relative to mirror " + selectedMirror.locationString, e);
            return inputLocation;
        }
    }

    private MirrorInfo[] initMirrors() {
        if (this.mirrors != null) {
            return this.mirrors;
        }
        String mirrorsURL = (String)this.repository.getProperties().get("p2.mirrorsURL");
        if (mirrorsURL != null) {
            this.mirrors = this.computeMirrors(mirrorsURL);
        }
        return this.mirrors;
    }

    private void log(String message, Throwable exception) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", message, exception));
    }

    public synchronized void reportResult(String toDownload, IStatus result) {
        if (this.mirrors == null) {
            return;
        }
        int i = 0;
        while (i < this.mirrors.length) {
            MirrorInfo mirror = this.mirrors[i];
            if (toDownload.startsWith(mirror.locationString)) {
                if (!result.isOK() && result.getSeverity() != 8) {
                    mirror.incrementFailureCount();
                }
                if (result instanceof DownloadStatus) {
                    long oldRate = mirror.bytesPerSecond;
                    long newRate = ((DownloadStatus)result).getTransferRate();
                    if (oldRate > 0L) {
                        newRate = (oldRate + newRate) / 2L;
                    }
                    mirror.setBytesPerSecond(newRate);
                }
                if (Tracing.DEBUG_MIRRORS) {
                    Tracing.debug((String)("Updated mirror " + mirror));
                }
                Arrays.sort(this.mirrors);
                return;
            }
            ++i;
        }
    }

    public synchronized boolean hasValidMirror() {
        return this.mirrors != null && this.mirrors.length > 0 && this.mirrors[0].failureCount == 0;
    }

    private MirrorInfo selectMirror() {
        int mirrorCount;
        this.initMirrors();
        if (this.mirrors == null || (mirrorCount = this.mirrors.length) == 0) {
            return null;
        }
        int highestMirror = Math.min(15, mirrorCount);
        int result = (int)(Math.log(this.random.nextInt(1 << highestMirror) + 1) / LOG2);
        if (result >= highestMirror || result < 0) {
            result = highestMirror - 1;
        }
        MirrorInfo selected = this.mirrors[highestMirror - 1 - result];
        if (selected.failureCount > 0) {
            selected = this.mirrors[0];
        }
        if (selected.failureCount > 0) {
            return null;
        }
        return selected;
    }

    public static class MirrorInfo
    implements Comparable {
        long bytesPerSecond;
        int failureCount;
        private final int initialRank;
        String locationString;

        public MirrorInfo(String location, int initialRank) {
            this.initialRank = initialRank;
            this.locationString = location;
            if (!this.locationString.endsWith("/")) {
                this.locationString = String.valueOf(this.locationString) + "/";
            }
            this.failureCount = 0;
            this.bytesPerSecond = -1L;
        }

        public int compareTo(Object o) {
            if (!(o instanceof MirrorInfo)) {
                return 0;
            }
            MirrorInfo that = (MirrorInfo)o;
            if (this.failureCount != that.failureCount) {
                return this.failureCount - that.failureCount;
            }
            if (this.bytesPerSecond != that.bytesPerSecond) {
                return (int)(that.bytesPerSecond - this.bytesPerSecond);
            }
            return this.initialRank - that.initialRank;
        }

        public void incrementFailureCount() {
            ++this.failureCount;
        }

        public void setBytesPerSecond(long newValue) {
            this.bytesPerSecond = newValue;
        }

        public String toString() {
            return "Mirror(" + this.locationString + ',' + this.failureCount + ',' + this.bytesPerSecond + ')';
        }
    }
}

