/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSorterService;

public final class CommonViewerSorter
extends TreePathViewerSorter {
    private static final int LEFT_UNDERSTANDS = 1;
    private static final int RIGHT_UNDERSTANDS = 2;
    private static final int BOTH_UNDERSTAND = 3;
    private NavigatorContentService contentService;
    private INavigatorSorterService sorterService;

    public void setContentService(INavigatorContentService aContentService) {
        this.contentService = (NavigatorContentService)aContentService;
        this.sorterService = this.contentService.getSorterService();
    }

    public int category(Object element) {
        if (this.contentService == null) {
            return 0;
        }
        INavigatorContentDescriptor source = this.contentService.getSourceOfContribution(element);
        if (source == null) {
            source = this.getSource(element);
        }
        return source != null ? source.getPriority() : 3;
    }

    public int compare(Viewer viewer, TreePath parentPath, Object e1, Object e2) {
        ViewerSorter sorter;
        if (this.contentService == null) {
            return -1;
        }
        INavigatorContentDescriptor sourceOfLvalue = this.contentService.getSourceOfContribution(e1);
        INavigatorContentDescriptor sourceOfRvalue = this.contentService.getSourceOfContribution(e2);
        Object parent = parentPath == null ? viewer.getInput() : parentPath.getLastSegment();
        if (sourceOfLvalue == sourceOfRvalue && (sorter = this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2)) != null) {
            return sorter.compare(viewer, e1, e2);
        }
        if (sourceOfLvalue == null) {
            sourceOfLvalue = this.getSource(e1);
        }
        if (sourceOfRvalue == null) {
            sourceOfRvalue = this.getSource(e2);
        }
        boolean[] flags = new boolean[]{sourceOfLvalue.isPossibleChild(e1), sourceOfLvalue.isPossibleChild(e2), sourceOfRvalue.isPossibleChild(e1), sourceOfRvalue.isPossibleChild(e2)};
        int whoknows = 0;
        whoknows |= flags[0] & flags[1] ? 1 : 0;
        int n = flags[2] & flags[3] ? 2 : 0;
        ViewerSorter sorter2 = null;
        switch (whoknows |= n) {
            case 3: {
                sorter2 = sourceOfLvalue.getPriority() > sourceOfRvalue.getPriority() ? this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2) : this.sorterService.findSorter(sourceOfRvalue, parent, e1, e2);
                break;
            }
            case 1: {
                sorter2 = this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2);
                break;
            }
            case 2: {
                sorter2 = this.sorterService.findSorter(sourceOfRvalue, parent, e1, e2);
            }
        }
        if (sorter2 != null) {
            return sorter2.compare(viewer, e1, e2);
        }
        int categoryDelta = this.category(e1) - this.category(e2);
        if (categoryDelta == 0) {
            return super.compare(viewer, e1, e2);
        }
        return categoryDelta;
    }

    private INavigatorContentDescriptor getSource(Object o) {
        Set descriptors = this.contentService.findDescriptorsWithPossibleChild(o);
        if (descriptors != null && descriptors.size() > 0) {
            return (INavigatorContentDescriptor)descriptors.iterator().next();
        }
        return null;
    }
}

