/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.p2.core.Activator;
import org.eclipse.equinox.internal.p2.core.Locker;
import org.eclipse.equinox.internal.p2.core.Locker_JavaIo;
import org.eclipse.equinox.internal.p2.core.Locker_JavaNio;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.osgi.service.datalocation.Location;

public class BasicLocation
implements AgentLocation {
    private boolean isReadOnly;
    private URL location = null;
    private Location parent;
    private URL defaultValue;
    private File lockFile;
    private Locker locker;
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    public static boolean DEBUG;

    private static boolean isRunningWithNio() {
        try {
            Class.forName("java.nio.channels.FileLock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Locker createLocker(File lock, String lockMode) {
        if (lockMode == null) {
            lockMode = Activator.context.getProperty(PROP_OSGI_LOCKING);
        }
        if ("none".equals(lockMode)) {
            return new MockLocker();
        }
        if ("java.io".equals(lockMode)) {
            return new Locker_JavaIo(lock);
        }
        if ("java.nio".equals(lockMode)) {
            if (BasicLocation.isRunningWithNio()) {
                return new Locker_JavaNio(lock);
            }
            return new Locker_JavaIo(lock);
        }
        if (BasicLocation.isRunningWithNio()) {
            return new Locker_JavaNio(lock);
        }
        return new Locker_JavaIo(lock);
    }

    public BasicLocation(String property, URL defaultValue, boolean isReadOnly) {
        this.defaultValue = defaultValue;
        this.isReadOnly = isReadOnly;
    }

    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    public URL getDefault() {
        return this.defaultValue;
    }

    public synchronized Location getParentLocation() {
        return this.parent;
    }

    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    public synchronized boolean isSet() {
        return this.location != null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public synchronized boolean setURL(URL value, boolean lock) {
        this.location = value;
        return lock;
    }

    public boolean set(URL value, boolean lock) {
        this.location = value;
        return lock;
    }

    public synchronized void setParent(Location value) {
        this.parent = value;
    }

    public synchronized boolean lock() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.lock(this.lockFile);
    }

    private boolean lock(File lock) throws IOException {
        if (lock == null || this.isReadOnly) {
            return false;
        }
        File parentFile = new File(lock.getParent());
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            return false;
        }
        this.setLocker(lock);
        if (this.locker == null) {
            return true;
        }
        boolean locked = false;
        try {
            boolean bl = locked = this.locker.lock();
            return bl;
        }
        finally {
            if (!locked) {
                this.locker = null;
            }
        }
    }

    private void setLocker(File lock) {
        if (this.locker != null) {
            return;
        }
        String lockMode = Activator.context.getProperty(PROP_OSGI_LOCKING);
        this.locker = BasicLocation.createLocker(lock, lockMode);
    }

    public synchronized void release() {
        if (this.locker != null) {
            this.locker.release();
        }
    }

    public URL getArtifactRepositoryURL() {
        return this.getMetadataRepositoryURL();
    }

    public URL getMetadataRepositoryURL() {
        try {
            return new URL(this.getDataArea("org.eclipse.equinox.p2.core"), "cache/");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getDataArea(String touchpointId) {
        try {
            return new URL(this.getURL(), String.valueOf(touchpointId) + '/');
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static class MockLocker
    implements Locker {
        private MockLocker() {
        }

        public boolean lock() {
            return true;
        }

        public void release() {
        }
    }
}

