/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.part.FileEditorInput;

public final class IDE {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    public static final String EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    private static MarkerHelpRegistry markerHelpRegistry = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private IDE() {
    }

    public static IMarkerHelpRegistry getMarkerHelpRegistry() {
        if (markerHelpRegistry == null) {
            markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(markerHelpRegistry);
        }
        return markerHelpRegistry;
    }

    public static void gotoMarker(IEditorPart editor, IMarker marker) {
        IGotoMarker gotoMarker = null;
        if (editor instanceof IGotoMarker) {
            gotoMarker = (IGotoMarker)editor;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            gotoMarker = (IGotoMarker)editor.getAdapter((Class)clazz);
        }
        if (gotoMarker != null) {
            gotoMarker.gotoMarker(marker);
        }
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, URI uri, String editorId, boolean activate) throws PartInitException {
        IFileStore fileStore;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        try {
            fileStore = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_coreExceptionFileStore, (Throwable)e);
        }
        IEditorInput input = IDE.getEditorInput(fileStore);
        return page.openEditor(input, editorId, activate);
    }

    private static IEditorInput getEditorInput(IFileStore fileStore) {
        IFile workspaceFile = IDE.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new FileStoreEditorInput(fileStore);
    }

    private static IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if ((files = IDE.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId, activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate) throws PartInitException {
        return IDE.openEditor(page, input, activate, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate, boolean determineContentType) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input, determineContentType);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId(), activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor(input);
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId());
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId, activate);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file) throws PartInitException {
        return IDE.getEditorDescriptor(file, true);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file, boolean determineContentType) throws PartInitException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return IDE.getEditorDescriptor(file.getName(), PlatformUI.getWorkbench().getEditorRegistry(), IDE.getDefaultEditor(file, determineContentType));
    }

    private static String getEditorId(IFileStore fileStore) throws PartInitException {
        String name = fileStore.fetchInfo().getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = null;
        try {
            InputStream is = null;
            try {
                is = fileStore.openInputStream(0, null);
                contentType = Platform.getContentTypeManager().findContentTypeFor(is, name);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        return IDE.getEditorDescriptor(name, editorReg, editorReg.getDefaultEditor(name, contentType)).getId();
    }

    public static IEditorDescriptor getEditorDescriptor(String name) throws PartInitException {
        return IDE.getEditorDescriptor(name, true);
    }

    public static IEditorDescriptor getEditorDescriptor(String name, boolean inferContentType) throws PartInitException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = inferContentType ? Platform.getContentTypeManager().findContentTypeFor(name) : null;
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        return IDE.getEditorDescriptor(name, editorReg, editorReg.getDefaultEditor(name, contentType));
    }

    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor) throws PartInitException {
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IEditorDescriptor editorDesc = defaultDescriptor;
        if (editorReg.isSystemInPlaceEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker) throws PartInitException {
        return IDE.openEditor(page, marker, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker, boolean activate) throws PartInitException {
        if (page == null || marker == null) {
            throw new IllegalArgumentException();
        }
        if (!(marker.getResource() instanceof IFile)) {
            IDEWorkbenchPlugin.log("Open editor on marker failed; marker resource not an IFile");
            return null;
        }
        IFile file = (IFile)marker.getResource();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = null;
        try {
            String editorID = (String)marker.getAttribute(EDITOR_ID_ATTR);
            if (editorID != null) {
                editorDesc = editorReg.findEditor(editorID);
            }
        }
        catch (CoreException coreException) {}
        IEditorPart editor = null;
        editor = editorDesc == null ? IDE.openEditor(page, file, activate) : page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), activate);
        if (editor != null) {
            IDE.gotoMarker(editor, marker);
        }
        return editor;
    }

    public static IEditorPart openEditorOnFileStore(IWorkbenchPage page, IFileStore fileStore) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorInput input = IDE.getEditorInput(fileStore);
        String editorId = IDE.getEditorId(fileStore);
        return page.openEditor(input, editorId);
    }

    public static boolean saveAllEditors(final IResource[] resourceRoots, final boolean confirm) {
        if (resourceRoots.length == 0) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnSaveAll){

            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (w == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                    w = windows[0];
                }
                if (w != null) {
                    result[0] = PlatformUI.getWorkbench().saveAll((IShellProvider)w, (IRunnableContext)w, (ISaveableFilter)new SaveFilter(resourceRoots), confirm);
                }
            }
        });
        return result[0];
    }

    public static void setDefaultEditor(IFile file, String editorID) {
        try {
            file.setPersistentProperty(EDITOR_KEY, editorID);
        }
        catch (CoreException coreException) {}
    }

    public static IEditorDescriptor getDefaultEditor(IFile file) {
        return IDE.getDefaultEditor(file, true);
    }

    public static IEditorDescriptor getDefaultEditor(IFile file, boolean determineContentType) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        try {
            IEditorDescriptor desc;
            String editorID = file.getPersistentProperty(EDITOR_KEY);
            if (editorID != null && (desc = editorReg.findEditor(editorID)) != null) {
                return desc;
            }
        }
        catch (CoreException coreException) {}
        IContentType contentType = null;
        if (determineContentType) {
            contentType = IDE.getContentType(file);
        }
        return editorReg.getDefaultEditor(file.getName(), contentType);
    }

    public static List computeSelectedResources(IStructuredSelection originalSelection) {
        ArrayList<Object> resources = null;
        Iterator e = originalSelection.iterator();
        while (e.hasNext()) {
            Object next = e.next();
            Object resource = null;
            if (next instanceof IResource) {
                resource = next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null) continue;
            if (resources == null) {
                resources = new ArrayList<Object>(originalSelection.size());
            }
            resources.add(resource);
        }
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentType getContentType(IFile file) {
        try {
            UIStats.start((int)14, (String)file.getName());
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                return null;
            }
            IContentType iContentType = contentDescription.getContentType();
            return iContentType;
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 274) return null;
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            return iContentType;
        }
        finally {
            UIStats.end((int)14, (Object)file, (String)file.getName());
        }
    }

    public static IContentType guessContentType(IFile file) {
        String fileName = file.getName();
        try {
            UIStats.start((int)14, (String)fileName);
            IContentTypeMatcher matcher = file.getProject().getContentTypeMatcher();
            IContentType iContentType = matcher.findContentTypeFor(fileName);
            return iContentType;
        }
        catch (CoreException coreException) {
            return null;
        }
        finally {
            UIStats.end((int)14, (Object)file, (String)fileName);
        }
    }

    public static boolean promptToConfirm(final Shell shell, final String title, String message, IResourceDelta delta, String[] ignoreModelProviderIds, boolean syncExec) {
        Object displayStatus;
        IStatus status = ResourceChangeValidator.getValidator().validateChange(delta, null);
        if (status.isOK()) {
            return true;
        }
        if (status.isMultiStatus()) {
            ArrayList<IStatus> result = new ArrayList<IStatus>();
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (!IDE.isIgnoredStatus(child, ignoreModelProviderIds)) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return true;
            }
            displayStatus = result.size() == 1 ? (IStatus)result.get(0) : new MultiStatus(status.getPlugin(), status.getCode(), result.toArray(new IStatus[result.size()]), status.getMessage(), status.getException());
        } else {
            if (IDE.isIgnoredStatus(status, ignoreModelProviderIds)) {
                return true;
            }
            displayStatus = status;
        }
        if (message == null) {
            message = IDEWorkbenchMessages.IDE_sideEffectWarning;
        }
        final String dialogMessage = NLS.bind((String)IDEWorkbenchMessages.IDE_areYouSure, (Object)message);
        boolean[] result = new boolean[1];
        Runnable runnable = new Runnable((IStatus)displayStatus, result){
            private final /* synthetic */ IStatus val$displayStatus;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$displayStatus = iStatus;
                this.val$result = blArray;
            }

            public void run() {
                ErrorDialog dialog = new ErrorDialog(this, shell, title, dialogMessage, this.val$displayStatus, 7){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                        this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                        this.createDetailsButton(parent);
                    }

                    protected void buttonPressed(int id) {
                        if (id == 2) {
                            super.buttonPressed(0);
                        } else if (id == 3) {
                            super.buttonPressed(1);
                        }
                        super.buttonPressed(id);
                    }
                };
                int code = dialog.open();
                this.val$result[0] = code == 0;
            }
        };
        if (syncExec) {
            shell.getDisplay().syncExec(runnable);
        } else {
            runnable.run();
        }
        return result[0];
    }

    private static boolean isIgnoredStatus(IStatus status, String[] ignoreModelProviderIds) {
        if (ignoreModelProviderIds == null) {
            return false;
        }
        if (status instanceof ModelStatus) {
            ModelStatus ms = (ModelStatus)status;
            int i = 0;
            while (i < ignoreModelProviderIds.length) {
                String id = ignoreModelProviderIds[i];
                if (ms.getModelProviderId().equals(id)) {
                    return true;
                }
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                String[] extended = desc.getExtendedModels();
                if (IDE.isIgnoredStatus(status, extended)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static interface Preferences {
        public static final String PROJECT_OPEN_NEW_PERSPECTIVE = "PROJECT_OPEN_NEW_PERSPECTIVE";
        public static final String SHOW_WORKSPACE_SELECTION_DIALOG = "SHOW_WORKSPACE_SELECTION_DIALOG";
        public static final String MAX_RECENT_WORKSPACES = "MAX_RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES = "RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES_PROTOCOL = "RECENT_WORKSPACES_PROTOCOL";
    }

    private static class SaveFilter
    implements ISaveableFilter {
        private final IResource[] roots;

        public SaveFilter(IResource[] roots) {
            this.roots = roots;
        }

        public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
            if (this.isDescendantOfRoots(saveable)) {
                return true;
            }
            int i = 0;
            while (i < containingParts.length) {
                IEditorPart editorPart;
                IWorkbenchPart workbenchPart = containingParts[i];
                if (workbenchPart instanceof IEditorPart && this.isEditingDescendantOf(editorPart = (IEditorPart)workbenchPart)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isDescendantOfRoots(Saveable saveable) {
            ResourceMapping mapping = ResourceUtil.getResourceMapping(saveable);
            if (mapping == null) {
                IFile file = ResourceUtil.getFile(saveable);
                if (file == null) return false;
                return this.isDescendantOfRoots((IResource)file);
            }
            try {
                ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                int i = 0;
                block2: while (true) {
                    if (i >= traversals.length) {
                        return false;
                    }
                    ResourceTraversal traversal = traversals[i];
                    IResource[] resources = traversal.getResources();
                    int j = 0;
                    while (true) {
                        if (j >= resources.length) {
                            ++i;
                            continue block2;
                        }
                        IResource resource = resources[j];
                        if (this.isDescendantOfRoots(resource)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log(NLS.bind((String)"An internal error occurred while determining the resources for {0}", (Object)saveable.getName()), e);
                return false;
            }
        }

        private boolean isDescendantOfRoots(IResource resource) {
            int l = 0;
            while (l < this.roots.length) {
                IResource root = this.roots[l];
                if (root.getFullPath().isPrefixOf(resource.getFullPath())) {
                    return true;
                }
                ++l;
            }
            return false;
        }

        private boolean isEditingDescendantOf(IEditorPart part) {
            IFile file = ResourceUtil.getFile(part.getEditorInput());
            if (file != null) {
                return this.isDescendantOfRoots((IResource)file);
            }
            return false;
        }
    }

    public static interface SharedImages {
        public static final String IMG_OBJ_PROJECT = "IMG_OBJ_PROJECT";
        public static final String IMG_OBJ_PROJECT_CLOSED = "IMG_OBJ_PROJECT_CLOSED";
        public static final String IMG_OPEN_MARKER = "IMG_OPEN_MARKER";
        public static final String IMG_OBJS_TASK_TSK = "IMG_OBJS_TASK_TSK";
        public static final String IMG_OBJS_BKMRK_TSK = "IMG_OBJS_BKMRK_TSK";
    }
}

