/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;

public class WizardFileSystemResourceExportPage1
extends WizardExportResourcesPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardFileSystemResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardFileSystemResourceExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardFileSystemResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String SELECT_DESTINATION_MESSAGE = DataTransferMessages.FileExport_selectDestinationMessage;
    private static final String SELECT_DESTINATION_TITLE = DataTransferMessages.FileExport_selectDestinationTitle;

    protected WizardFileSystemResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardFileSystemResourceExportPage1(IStructuredSelection selection) {
        this("fileSystemExportPage1", selection);
        this.setTitle(DataTransferMessages.DataTransfer_fileSystemTitle);
        this.setDescription(DataTransferMessages.FileExport_exportLocalFileSystem);
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.giveFocusToDestination();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.file_system_export_wizard_page");
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createOverwriteExisting(optionsGroup, font);
        this.createDirectoryStructureOptions((Composite)optionsGroup, font);
    }

    protected void createDirectoryStructureOptions(Composite optionsGroup, Font font) {
        this.createDirectoryStructureButton = new Button(optionsGroup, 16400);
        this.createDirectoryStructureButton.setText(DataTransferMessages.FileExport_createDirectoryStructure);
        this.createDirectoryStructureButton.setSelection(false);
        this.createDirectoryStructureButton.setFont(font);
        this.createSelectionOnlyButton = new Button(optionsGroup, 16400);
        this.createSelectionOnlyButton.setText(DataTransferMessages.FileExport_createSelectedDirectories);
        this.createSelectionOnlyButton.setSelection(true);
        this.createSelectionOnlyButton.setFont(font);
    }

    protected void createOverwriteExisting(Group optionsGroup, Font font) {
        this.overwriteExistingFilesCheckbox = new Button((Composite)optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(DataTransferMessages.ExportFile_overwriteExisting);
        this.overwriteExistingFilesCheckbox.setFont(font);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(DataTransferMessages.DataTransfer_createTargetDirectory)) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(DataTransferMessages.DataTransfer_directoryCreationError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.FileExport_directoryExists);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(FileSystemExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        op.setOverwriteFiles(this.overwriteExistingFilesCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_exportProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        List resourcesToExport = this.getWhiteCheckedResources();
        if (!this.ensureTargetIsValid(new File(this.getDestinationValue()))) {
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.executeExportOperation(new FileSystemExportOperation(null, resourcesToExport, this.getDestinationValue(), this));
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.FileExport_toDirectory;
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        dialog.setMessage(SELECT_DESTINATION_MESSAGE);
        dialog.setText(SELECT_DESTINATION_TITLE);
        dialog.setFilterPath(this.getDestinationValue());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedDirectoryName);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            boolean createDirectories = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(createDirectories);
            this.createSelectionOnlyButton.setSelection(!createDirectories);
        }
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer == null) {
            String threatenedContainer = this.getOverlappingProjectName(destinationValue);
            if (threatenedContainer == null) {
                this.setMessage(null);
            } else {
                this.setMessage(NLS.bind((String)DataTransferMessages.FileExport_damageWarning, (Object)threatenedContainer), 2);
            }
        } else {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.FileExport_conflictingContainer, (Object)conflictingContainer));
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected boolean validateSourceGroup() {
        boolean isValid = true;
        List resourcesToExport = this.getWhiteCheckedResources();
        if (resourcesToExport.size() == 0) {
            this.setErrorMessage(DataTransferMessages.FileExport_noneSelected);
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        return super.validateSourceGroup() && isValid;
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.FileExport_destinationEmpty;
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        String firstSegment;
        Path testPath = new Path(targetDirectory);
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (testPath.equals((Object)rootPath)) {
            return rootPath.lastSegment();
        }
        if (testPath.matchingFirstSegments(rootPath) == rootPath.segmentCount() && !Character.isLetterOrDigit((firstSegment = testPath.removeFirstSegments(rootPath.segmentCount()).segment(0)).charAt(0))) {
            return firstSegment;
        }
        return null;
    }

    private String getOverlappingProjectName(String targetDirectory) {
        Path testPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] containers = root.findContainersForLocation((IPath)(testPath = new Path(targetDirectory)));
        if (containers.length > 0) {
            return containers[0].getProject().getName();
        }
        return null;
    }
}

