/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.ECFMetadataTransport;
import org.eclipse.equinox.internal.p2.metadata.repository.URLMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CacheManager {
    private static SynchronousProvisioningListener busListener;
    private static final String CONTENT_FILENAME = "content";
    private static final String JAR_EXTENSION = ".jar";
    private static final String XML_EXTENSION = ".xml";
    static /* synthetic */ Class class$0;

    private int computeHash(URL repositoryLocation) {
        return repositoryLocation.toExternalForm().hashCode();
    }

    public File createCache(URL repositoryLocation, IProgressMonitor monitor) throws IOException, ProvisionException {
        File cacheFile = this.getCache(repositoryLocation);
        URL jarLocation = URLMetadataRepository.getActualLocation(repositoryLocation, JAR_EXTENSION);
        URL xmlLocation = URLMetadataRepository.getActualLocation(repositoryLocation, XML_EXTENSION);
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AgentLocation agentLocation = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        URL dataArea = agentLocation.getDataArea("org.eclipse.equinox.p2.metadata.repository/cache/");
        File dataAreaFile = URLUtil.toFile((URL)dataArea);
        int hashCode = this.computeHash(repositoryLocation);
        if (cacheFile == null || this.isCacheStale(repositoryLocation, cacheFile)) {
            URL remoteFile;
            long lastModifiedRemote = this.getTransport().getLastModified(jarLocation);
            if (lastModifiedRemote != 0L) {
                cacheFile = new File(dataAreaFile, CONTENT_FILENAME + hashCode + JAR_EXTENSION);
                remoteFile = jarLocation;
            } else {
                lastModifiedRemote = this.getTransport().getLastModified(xmlLocation);
                if (lastModifiedRemote == 0L) {
                    return null;
                }
                cacheFile = new File(dataAreaFile, CONTENT_FILENAME + hashCode + XML_EXTENSION);
                remoteFile = xmlLocation;
            }
            cacheFile.getParentFile().mkdirs();
            BufferedOutputStream metadata = new BufferedOutputStream(new FileOutputStream(cacheFile));
            try {
                IStatus result = this.getTransport().download(remoteFile.toExternalForm(), metadata, monitor);
                if (!result.isOK()) {
                    throw new ProvisionException(result);
                }
            }
            finally {
                ((OutputStream)metadata).close();
            }
        }
        return cacheFile;
    }

    void deleteCache(URL repositoryLocation) {
        File cacheFile = this.getCache(repositoryLocation);
        if (cacheFile != null) {
            this.safeDelete(cacheFile);
        }
    }

    private File getCache(URL repositoryLocation) {
        int hashCode;
        AgentLocation agentLocation;
        URL dataArea;
        File dataAreaFile;
        File cacheFile;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(cacheFile = new File(dataAreaFile = URLUtil.toFile((URL)(dataArea = (agentLocation = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).getDataArea("org.eclipse.equinox.p2.metadata.repository/cache/"))), CONTENT_FILENAME + (hashCode = this.computeHash(repositoryLocation)) + JAR_EXTENSION)).exists() && !(cacheFile = new File(dataAreaFile, CONTENT_FILENAME + hashCode + XML_EXTENSION)).exists()) {
            return null;
        }
        return cacheFile;
    }

    private Object getService(BundleContext ctx, String name) {
        ServiceReference reference = ctx.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = ctx.getService(reference);
        ctx.ungetService(reference);
        return result;
    }

    private ECFMetadataTransport getTransport() {
        return ECFMetadataTransport.getInstance();
    }

    private boolean isCacheStale(URL repositoryLocation, File cacheFile) {
        long lastModified = cacheFile.lastModified();
        String name = cacheFile.getName();
        URL metadataLocation = null;
        if (name.endsWith(XML_EXTENSION)) {
            metadataLocation = URLMetadataRepository.getActualLocation(repositoryLocation, XML_EXTENSION);
        } else if (name.endsWith(JAR_EXTENSION)) {
            metadataLocation = URLMetadataRepository.getActualLocation(repositoryLocation, JAR_EXTENSION);
        }
        long lastModifiedRemote = 0L;
        try {
            lastModifiedRemote = this.getTransport().getLastModified(metadataLocation);
        }
        catch (ProvisionException provisionException) {
            return true;
        }
        return lastModifiedRemote > lastModified;
    }

    public void registerRepoEventListener() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)this.getService(Activator.getContext(), IProvisioningEventBus.SERVICE_NAME);
        if (eventBus == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", "ProvisioningEventBus could not be obtained. Metadata caches may not be cleaned up properly."));
            return;
        }
        if (busListener == null) {
            busListener = new SynchronousProvisioningListener(){

                public void notify(EventObject o) {
                    RepositoryEvent event;
                    if (o instanceof RepositoryEvent && 1 == (event = (RepositoryEvent)o).getKind() && event.getRepositoryType() == 0) {
                        CacheManager.this.deleteCache(event.getRepositoryLocation());
                    }
                }
            };
            eventBus.addListener((ProvisioningListener)busListener);
        }
    }

    private boolean safeDelete(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
            return true;
        }
        return false;
    }

    public void unregisterRepoEventListener() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)this.getService(Activator.getContext(), IProvisioningEventBus.SERVICE_NAME);
        if (eventBus != null && busListener != null) {
            eventBus.removeListener((ProvisioningListener)busListener);
            busListener = null;
        }
    }
}

