/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.ConfigurationParser;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.osgi.util.NLS;

public class PlatformXmlListener
extends DirectoryChangeListener {
    private static final String PLATFORM_XML = "platform.xml";
    private boolean changed = false;
    private File root;
    private long lastModified = -1L;
    private Set configRepositories;

    private String toString(String[] list) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            buffer.append(list[i]);
            if (i + 1 < list.length) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    public PlatformXmlListener(File file) {
        if (!PLATFORM_XML.equals(file.getName())) {
            throw new IllegalArgumentException();
        }
        this.root = file;
    }

    public boolean added(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public boolean changed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public Long getSeenFile(File file) {
        return new Long(0L);
    }

    public boolean isInterested(File file) {
        return file.getName().equals(PLATFORM_XML) && this.lastModified != file.lastModified();
    }

    public boolean removed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public void startPoll() {
        this.changed = false;
    }

    public void stopPoll() {
        if (this.changed) {
            this.lastModified = this.root.lastModified();
            try {
                Configuration configuration = ConfigurationParser.parse((File)this.root, (URL)Activator.getOSGiInstallArea());
                this.synchronizeConfiguration(configuration);
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", Messages.errorProcessingConfg, (Throwable)e));
            }
        }
        this.changed = false;
    }

    public Collection getMetadataRepositories() {
        if (this.configRepositories == null) {
            return Collections.EMPTY_SET;
        }
        return this.configRepositories;
    }

    private IMetadataRepository getMatchingRepo(Collection repositoryList, String urlString) {
        if (repositoryList == null) {
            return null;
        }
        IPath urlPath = new Path(urlString).makeAbsolute();
        Iterator iter = repositoryList.iterator();
        while (iter.hasNext()) {
            IMetadataRepository repo = (IMetadataRepository)iter.next();
            Path repoPath = new Path(repo.getLocation().toExternalForm());
            if (repoPath.makeAbsolute().equals((Object)urlPath)) {
                return repo;
            }
            if (!(repo instanceof ExtensionLocationMetadataRepository)) continue;
            try {
                File one = ExtensionLocationMetadataRepository.getBaseDirectory((URL)repo.getLocation());
                File two = ExtensionLocationMetadataRepository.getBaseDirectory((URL)new URL(urlString));
                if (!one.equals(two)) continue;
                return repo;
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while comparing repository locations.", (Throwable)e));
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while comparing repository locations.", (Throwable)e));
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void synchronizeConfiguration(Configuration config) {
        sites = config.getSites();
        newRepos = new LinkedHashSet<IMetadataRepository>();
        toBeRemoved = new HashSet<Site>();
        iter = sites.iterator();
        while (iter.hasNext()) {
            site = (Site)iter.next();
            siteURL = site.getUrl();
            match = this.getMatchingRepo(Activator.getRepositories(), siteURL);
            if (match == null) {
                try {
                    block19: {
                        eclipseExtensionURL = String.valueOf(siteURL) + ".eclipseextension";
                        location = new URL(eclipseExtensionURL);
                        properties = new HashMap<String, String>();
                        properties.put("org.eclipse.update.site.policy", site.getPolicy());
                        properties.put("org.eclipse.update.site.list", this.toString(site.getList()));
                        properties.put("p2.system", Boolean.TRUE.toString());
                        metadataRepository = null;
                        try {
                            metadataRepository = Activator.createExtensionLocationMetadataRepository(location, "extension location metadata repository: " + location.toExternalForm(), properties);
                            break block19;
                        }
                        catch (ProvisionException v0) {
                            try {
                                metadataRepository = Activator.loadMetadataRepository(location, null);
                            }
                            catch (ProvisionException inner) {
                                fileURL = new URL(siteURL);
                                file = URLUtil.toFile((URL)fileURL);
                                if (file != null && !file.exists()) {
                                    toBeRemoved.add(site);
                                    continue;
                                }
                                throw inner;
                            }
                            inner = properties.keySet().iterator();
                            ** while (inner.hasNext())
                        }
lbl-1000:
                        // 1 sources

                        {
                            key = (String)inner.next();
                            value = (String)properties.get(key);
                            metadataRepository.setProperty(key, value);
                            continue;
                        }
lbl43:
                        // 1 sources

                        if (metadataRepository instanceof ExtensionLocationMetadataRepository) {
                            ((ExtensionLocationMetadataRepository)metadataRepository).ensureInitialized();
                        }
                    }
                    newRepos.add(metadataRepository);
                    try {
                        Activator.createExtensionLocationArtifactRepository(location, "extension location artifact repository: " + location.toExternalForm(), properties);
                        continue;
                    }
                    catch (ProvisionException v1) {
                        artifactRepository = Activator.loadArtifactRepository(location, null);
                        inner = properties.keySet().iterator();
                        ** while (inner.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        key = (String)inner.next();
                        value = (String)properties.get(key);
                        artifactRepository.setProperty(key, value);
                        continue;
                    }
lbl61:
                    // 1 sources

                    if (!(artifactRepository instanceof ExtensionLocationArtifactRepository)) continue;
                    ((ExtensionLocationArtifactRepository)artifactRepository).ensureInitialized();
                }
                catch (MalformedURLException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                catch (ProvisionException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                continue;
            }
            newRepos.add(match);
        }
        if (!toBeRemoved.isEmpty()) {
            iter = toBeRemoved.iterator();
            while (iter.hasNext()) {
                config.removeSite((Site)iter.next());
            }
            try {
                config.save(this.root, Activator.getOSGiInstallArea());
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while saving configuration at: " + this.root, (Throwable)e));
            }
        }
        this.configRepositories = newRepos;
    }
}

