/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ILink;
import org.eclipse.help.IToc;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.xml.sax.SAXException;

public class TocValidator {
    private static final boolean DEBUG = false;
    private HashMap processedTocs = new HashMap();
    private TocFileParser parser = new TocFileParser();

    public static ArrayList validate(String[] hrefs) throws IOException, SAXException, ParserConfigurationException {
        TocValidator v = new TocValidator();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < hrefs.length) {
            v.processToc(hrefs[i], null, result);
            ++i;
        }
        return result;
    }

    private TocValidator() {
    }

    private void processToc(String href, String plugin, ArrayList result) throws IOException, SAXException, ParserConfigurationException {
        String path;
        if (href.startsWith("/")) {
            int index = (href = href.substring(1)).indexOf("/");
            if (index == -1) {
                throw new IOException("Invalid parameters supplied to the validate method.");
            }
            plugin = href.substring(0, index);
            path = href.substring(index + 1);
        } else {
            path = href;
        }
        if (plugin == null) {
            throw new IOException("Invalid parameters supplied to the validate method.");
        }
        String key = "/" + plugin + "/" + path;
        if (this.processedTocs.get(key) != null) {
            return;
        }
        this.processedTocs.put(key, new Object());
        TocContribution contribution = this.parser.parse(new TocFile(plugin, path, true, "en", null, null));
        this.process((IUAElement)contribution.getToc(), plugin, path, result);
    }

    private void process(IUAElement element, String plugin, String path, ArrayList result) throws SAXException, ParserConfigurationException {
        String href;
        if (element instanceof ILink) {
            href = ((ILink)element).getToc();
            try {
                this.processToc(href, plugin, result);
            }
            catch (IOException iOException) {
                result.add(new BrokenLink("/" + plugin + "/" + path, href));
            }
        } else if (element instanceof IHelpResource && (href = element instanceof IToc ? ((IToc)element).getTopic(null).getHref() : ((IHelpResource)element).getHref()) != null && !this.checkLink(href, plugin)) {
            result.add(new BrokenLink("/" + plugin + "/" + path, href));
        }
        IUAElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            this.process(children[i], plugin, path, result);
            ++i;
        }
    }

    private boolean checkLink(String href, String plugin) {
        if (href.startsWith("http")) {
            return true;
        }
        boolean result = true;
        InputStream i = null;
        try {
            HelpURLConnection c = new HelpURLConnection(this.createURL(href, plugin));
            i = c.getInputStream();
            if (i == null) {
                result = false;
            }
        }
        catch (Exception exception) {
            result = false;
        }
        if (i != null) {
            try {
                i.close();
            }
            catch (Exception exception) {}
            i = null;
        }
        return result;
    }

    private URL createURL(String href, String plugin) throws MalformedURLException {
        StringBuffer url = new StringBuffer("file:/");
        url.append(plugin);
        url.append("/");
        url.append(href);
        return new URL(url.toString());
    }

    public static class BrokenLink {
        private String tocID;
        private String href;

        private BrokenLink(String tocID, String href) {
            this.tocID = tocID;
            this.href = href;
        }

        public String getTocID() {
            return this.tocID;
        }

        public String getHref() {
            return this.href;
        }
    }
}

