/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditICDialog
extends StatusDialog
implements IShellProvider {
    private Group group;
    private Label nameLabel;
    private Text nameText;
    private Label hostLabel;
    private Text hostText;
    private Label pathLabel;
    private Text pathText;
    private Button radio1;
    private Button radio2;
    private Text portText;
    Point shellSize;
    Point shellLocation;
    private String infoCenterName = "";
    private String selectedName = "";
    private String selectedHost = "";
    private String selectedPort = "";
    private String selectedPath = "";
    private String enteredHost;
    private String enteredName;
    private String enteredPort;
    private String enteredPath;
    private String enteredUseDefault;
    private StatusInfo dialogStatus;
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            EditICDialog.this.updateValidity();
        }
    };

    public EditICDialog(Shell parentShell, String infoCenterName) {
        super(parentShell);
        this.infoCenterName = infoCenterName;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setSize(topComposite.computeSize(-1, -1));
        Composite topGroup = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topGroup.setLayout((Layout)layout);
        topGroup.setFont(topComposite.getFont());
        topGroup.setLayoutData((Object)new GridData(768));
        this.createGroup(parent);
        this.updateValidity();
        return topComposite;
    }

    public void initializeBounds() {
        this.shellSize = this.getInitialSize();
        this.shellLocation = this.getInitialLocation(this.shellSize);
        this.getShell().setBounds(this.shellLocation.x, this.shellLocation.y, this.shellSize.x + 150, this.shellSize.y - 80);
        this.getShell().setText(NLS.bind((String)Messages.EditICDialog_7, (Object)this.infoCenterName));
    }

    private void createGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.EditICDialog_9);
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createNameSection((Composite)this.group);
        this.createHostSection((Composite)this.group);
        this.createPathSection((Composite)this.group);
        this.createPortSection((Composite)this.group);
    }

    private void createNameSection(Composite parent) {
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(Messages.EditICDialog_10);
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.nameText.getOrientation() == 0x4000000) {
            this.nameText.setOrientation(0x2000000);
        }
        this.nameText.addListener(24, this.changeListener);
        this.nameText.setText(this.selectedName);
    }

    private void createHostSection(Composite parent) {
        this.hostLabel = new Label(parent, 0);
        this.hostLabel.setText(Messages.EditICDialog_11);
        this.hostText = new Text(parent, 2048);
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.hostText.getOrientation() == 0x4000000) {
            this.hostText.setOrientation(0x2000000);
        }
        this.hostText.addListener(24, this.changeListener);
        this.hostText.setText(this.selectedHost);
    }

    private void createPathSection(Composite parent) {
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setText(Messages.EditICDialog_12);
        this.pathText = new Text(parent, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.pathText.getOrientation() == 0x4000000) {
            this.pathText.setOrientation(0x2000000);
        }
        this.pathText.addListener(24, this.changeListener);
        this.pathText.setText(this.selectedPath);
    }

    private void createPortSection(Composite parent) {
        Composite portComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        portComposite.setLayout((Layout)layout);
        portComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.radio1 = new Button(portComposite, 16);
        this.radio1.setText(Messages.EditICDialog_13);
        this.radio1.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.radio1.addListener(13, this.changeListener);
        this.radio2 = new Button(portComposite, 16);
        this.radio2.setText(Messages.EditICDialog_14);
        this.radio2.addListener(13, this.changeListener);
        this.portText = new Text(portComposite, 2048);
        this.portText.setLayoutData((Object)new GridData(50, -1));
        this.portText.addListener(24, this.changeListener);
        if (this.selectedPort.equals("80")) {
            this.radio1.setSelection(true);
            this.portText.setText("");
            this.portText.setEnabled(false);
        } else {
            this.radio2.setSelection(true);
            this.portText.setText(this.selectedPort);
            this.portText.setEnabled(true);
        }
    }

    public void setTextValues(String icName, String host, String port, String path) {
        this.selectedName = icName;
        this.selectedHost = host;
        this.selectedPort = port;
        this.selectedPath = path;
    }

    public String getEnteredHost() {
        return this.enteredHost;
    }

    public String getEnteredPath() {
        return this.enteredPath;
    }

    public String getEnteredPort() {
        return this.enteredPort;
    }

    public String getEnteredName() {
        return this.enteredName;
    }

    public String getEnteredDefault() {
        return this.enteredUseDefault;
    }

    protected void okPressed() {
        this.enteredHost = this.hostText.getText();
        this.enteredName = this.nameText.getText();
        this.enteredPath = this.pathText.getText();
        if (this.radio1.getSelection()) {
            this.enteredUseDefault = "true";
            this.enteredPort = "80";
        } else {
            this.enteredUseDefault = "false";
            this.enteredPort = this.portText.getText();
        }
        this.setReturnCode(0);
        this.close();
    }

    private void updateValidity() {
        boolean errorFound;
        block9: {
            String errorMessage = "";
            errorFound = false;
            this.dialogStatus = new StatusInfo();
            if (this.hostText != null && this.hostText.getText().equals("") && !errorFound) {
                errorMessage = Messages.AddICDialog_17;
                this.dialogStatus.setError(errorMessage);
                errorFound = true;
            }
            if (this.radio2 != null && this.radio2.getSelection()) {
                try {
                    this.portText.setEnabled(true);
                    int port = Integer.parseInt(this.portText.getText());
                    if (!(port >= 0 && port <= 65535 || errorFound)) {
                        errorMessage = Messages.AddICDialog_19;
                        this.dialogStatus.setError(errorMessage);
                        errorFound = true;
                    }
                    break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!errorFound) {
                        errorMessage = Messages.AddICDialog_19;
                        this.dialogStatus.setError(errorMessage);
                        errorFound = true;
                    }
                    break block9;
                }
            }
            if (this.radio1 != null && this.radio1.getSelection()) {
                this.portText.setEnabled(false);
            }
        }
        if (errorFound) {
            this.updateStatus(this.dialogStatus);
        } else {
            this.dialogStatus.setOK();
            this.updateStatus(this.dialogStatus);
        }
    }
}

