/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTBatchParser;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.UndoEdit;

public class CleanUpRefactoring
extends Refactoring
implements IScheduledRefactoring {
    private static final RefactoringTickProvider CLEAN_UP_REFACTORING_TICK_PROVIDER = new RefactoringTickProvider(0, 1, 0, 0);
    private final List fCleanUps;
    private final Hashtable fProjects;
    private Change fChange;
    private boolean fLeaveFilesDirty;
    private final String fName;
    private boolean fUseProjectOptions;

    public CleanUpRefactoring() {
        this(FixMessages.CleanUpRefactoring_Refactoring_name);
    }

    public CleanUpRefactoring(String name) {
        this.fName = name;
        this.fCleanUps = new ArrayList();
        this.fProjects = new Hashtable();
        this.fUseProjectOptions = false;
    }

    public void setUseProjectOptions(boolean enabled) {
        this.fUseProjectOptions = enabled;
    }

    public void addCompilationUnit(ICompilationUnit unit) {
        this.addCleanUpTarget(new CleanUpTarget(unit));
    }

    public void addCleanUpTarget(CleanUpTarget target) {
        IJavaProject javaProject = target.getCompilationUnit().getJavaProject();
        if (!this.fProjects.containsKey(javaProject)) {
            this.fProjects.put(javaProject, new ArrayList());
        }
        List targets = (List)this.fProjects.get(javaProject);
        targets.add(target);
    }

    public CleanUpTarget[] getCleanUpTargets() {
        ArrayList result = new ArrayList();
        Iterator iter = this.fProjects.values().iterator();
        while (iter.hasNext()) {
            List projectTargets = (List)iter.next();
            result.addAll(projectTargets);
        }
        return result.toArray(new CleanUpTarget[result.size()]);
    }

    public int getCleanUpTargetsSize() {
        int result = 0;
        Iterator iter = this.fProjects.values().iterator();
        while (iter.hasNext()) {
            List projectTargets = (List)iter.next();
            result += projectTargets.size();
        }
        return result;
    }

    public void addCleanUp(ICleanUp fix) {
        this.fCleanUps.add(fix);
    }

    public void clearCleanUps() {
        this.fCleanUps.clear();
    }

    public boolean hasCleanUps() {
        return !this.fCleanUps.isEmpty();
    }

    public ICleanUp[] getCleanUps() {
        return this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
    }

    public IJavaProject[] getProjects() {
        return this.fProjects.keySet().toArray(new IJavaProject[this.fProjects.keySet().size()]);
    }

    public void setLeaveFilesDirty(boolean leaveFilesDirty) {
        this.fLeaveFilesDirty = leaveFilesDirty;
    }

    public String getName() {
        return this.fName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return this.fChange;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (this.fProjects.size() == 0 || this.fCleanUps.size() == 0) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            this.fChange = new NullChange();
            return new RefactoringStatus();
        }
        int cuCount = this.getCleanUpTargetsSize();
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        pm.beginTask("", cuCount * 2 * this.fCleanUps.size() + 4 * cleanUps.length);
        try {
            DynamicValidationStateChange change = new DynamicValidationStateChange(this.getName());
            change.setSchedulingRule(this.getSchedulingRule());
            Iterator projectIter = this.fProjects.entrySet().iterator();
            while (projectIter.hasNext()) {
                Map.Entry entry = projectIter.next();
                IJavaProject project = (IJavaProject)entry.getKey();
                List targetsList = (List)entry.getValue();
                CleanUpTarget[] targets = targetsList.toArray(new CleanUpTarget[targetsList.size()]);
                if (this.fUseProjectOptions) {
                    result.merge(this.setProjectOptions(project, cleanUps));
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                }
                result.merge(this.checkPreConditions(project, targets, (IProgressMonitor)new SubProgressMonitor(pm, 3 * cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                Change[] changes = this.cleanUpProject(project, targets, cleanUps, pm);
                result.merge(this.checkPostConditions(new SubProgressMonitor(pm, cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                int i = 0;
                while (i < changes.length) {
                    change.add(changes[i]);
                    ++i;
                }
            }
            this.fChange = change;
            ArrayList files = new ArrayList();
            this.findFilesToBeModified(change, files);
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), this.getValidationContext()));
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void findFilesToBeModified(CompositeChange change, List result) throws JavaModelException {
        Change[] children = change.getChildren();
        int i = 0;
        while (i < children.length) {
            Change child = children[i];
            if (child instanceof CompositeChange) {
                this.findFilesToBeModified((CompositeChange)child, result);
            } else if (child instanceof MultiStateCompilationUnitChange) {
                result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            } else if (child instanceof CompilationUnitChange) {
                result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            }
            ++i;
        }
    }

    private Change[] cleanUpProject(IJavaProject project, CleanUpTarget[] targets, ICleanUp[] cleanUps, IProgressMonitor monitor) throws CoreException {
        CleanUpFixpointIterator iter = new CleanUpFixpointIterator(targets, cleanUps);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2 * targets.length * cleanUps.length);
        subMonitor.beginTask("", targets.length);
        subMonitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Parser_Startup_message, BasicElementLabels.getResourceName((IResource)project.getProject())));
        try {
            while (iter.hasNext()) {
                iter.next((IProgressMonitor)subMonitor);
            }
            Change[] changeArray = iter.getResult();
            return changeArray;
        }
        finally {
            iter.dispose();
            subMonitor.done();
        }
    }

    private RefactoringStatus setProjectOptions(IJavaProject javaProject, ICleanUp[] cleanUps) {
        Map options = CleanUpPreferenceUtil.loadOptions((IScopeContext)new ProjectScope(javaProject.getProject()));
        if (options == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(FixMessages.CleanUpRefactoring_could_not_retrive_profile, BasicElementLabels.getResourceName((IResource)javaProject.getProject())));
        }
        MapCleanUpOptions cleanUpOptions = new MapCleanUpOptions(options);
        int j = 0;
        while (j < cleanUps.length) {
            cleanUps[j].setOptions(cleanUpOptions);
            ++j;
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkPreConditions(IJavaProject javaProject, CleanUpTarget[] targets, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[targets.length];
        int i = 0;
        while (i < targets.length) {
            compilationUnits[i] = targets[i].getCompilationUnit();
            ++i;
        }
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", compilationUnits.length * cleanUps.length);
        monitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Initialize_message, BasicElementLabels.getResourceName((IResource)javaProject.getProject())));
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPreConditions(javaProject, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private RefactoringStatus checkPostConditions(SubProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", cleanUps.length);
        monitor.subTask(FixMessages.CleanUpRefactoring_checkingPostConditions_message);
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPostConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1)));
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static String getChangeName(ICompilationUnit compilationUnit) {
        StringBuffer buf = new StringBuffer();
        JavaElementLabels.getCompilationUnitLabel(compilationUnit, JavaElementLabels.ALL_DEFAULT, buf);
        buf.append(JavaElementLabels.CONCAT_STRING);
        StringBuffer buf2 = new StringBuffer();
        JavaElementLabels.getPackageFragmentLabel((IPackageFragment)compilationUnit.getParent(), 0x800000000L, buf2);
        buf.append(buf2.toString().replace('.', '/'));
        return buf.toString();
    }

    public static CleanUpChange calculateChange(ICleanUp.CleanUpContext context, ICleanUp[] cleanUps, List undoneCleanUps) throws CoreException {
        if (cleanUps.length == 0) {
            return null;
        }
        CleanUpChange solution = null;
        int i = 0;
        do {
            ICleanUp cleanUp;
            IFix fix;
            if ((fix = (cleanUp = cleanUps[i]).createFix(context)) == null) continue;
            CompilationUnitChange current = fix.createChange();
            TextEdit currentEdit = current.getEdit();
            if (solution != null) {
                if (TextEditUtil.overlaps(currentEdit, solution.getEdit())) {
                    undoneCleanUps.add(cleanUp);
                    continue;
                }
                CleanUpChange merge = new CleanUpChange(FixMessages.CleanUpRefactoring_clean_up_multi_chang_name, context.getCompilationUnit());
                merge.setEdit(TextEditUtil.merge(currentEdit, solution.getEdit()));
                CleanUpRefactoring.copyChangeGroups(merge, solution);
                CleanUpRefactoring.copyChangeGroups(merge, current);
                solution = merge;
                continue;
            }
            solution = new CleanUpChange(current.getName(), context.getCompilationUnit());
            solution.setEdit(currentEdit);
            CleanUpRefactoring.copyChangeGroups(solution, current);
        } while (++i < cleanUps.length && (context.getAST() == null || !cleanUps[i].getRequirements().requiresFreshAST()));
        while (i < cleanUps.length) {
            undoneCleanUps.add(cleanUps[i]);
            ++i;
        }
        return solution;
    }

    private static void copyChangeGroups(CompilationUnitChange target, CompilationUnitChange source) {
        TextEditBasedChangeGroup[] changeGroups = source.getChangeGroups();
        int i = 0;
        while (i < changeGroups.length) {
            TextEditGroup newGroup;
            TextEditGroup textEditGroup = changeGroups[i].getTextEditGroup();
            if (textEditGroup instanceof CategorizedTextEditGroup) {
                String label = textEditGroup.getName();
                newGroup = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            } else {
                newGroup = new TextEditGroup(textEditGroup.getName());
            }
            TextEdit[] textEdits = textEditGroup.getTextEdits();
            int j = 0;
            while (j < textEdits.length) {
                newGroup.addTextEdit(textEdits[j]);
                ++j;
            }
            target.addTextEditGroup(newGroup);
            ++i;
        }
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return CLEAN_UP_REFACTORING_TICK_PROVIDER;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static ICleanUp[] createCleanUps() {
        return JavaPlugin.getDefault().getCleanUpRegistry().getCleanUps();
    }

    public static ICleanUp[] createCleanUps(Map settings) {
        ICleanUp[] result = CleanUpRefactoring.createCleanUps();
        int i = 0;
        while (i < result.length) {
            result[i].setOptions(new MapCleanUpOptions(settings));
            ++i;
        }
        return result;
    }

    public static ASTParser createCleanUpASTParser() {
        ASTParser result = ASTParser.newParser((int)3);
        result.setResolveBindings(true);
        result.setStatementsRecovery(true);
        result.setBindingsRecovery(true);
        return result;
    }

    private static class CleanUpASTRequestor
    extends ASTRequestor {
        private final List fUndoneElements;
        private final Hashtable fSolutions;
        private final Hashtable fCompilationUnitParseElementMap;
        private final CleanUpRefactoringProgressMonitor fMonitor;

        public CleanUpASTRequestor(List parseList, Hashtable solutions, CleanUpRefactoringProgressMonitor monitor) {
            this.fSolutions = solutions;
            this.fMonitor = monitor;
            this.fUndoneElements = new ArrayList();
            this.fCompilationUnitParseElementMap = new Hashtable(parseList.size());
            Iterator iter = parseList.iterator();
            while (iter.hasNext()) {
                ParseListElement element = (ParseListElement)iter.next();
                this.fCompilationUnitParseElementMap.put(element.getTarget().getCompilationUnit(), element);
            }
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            this.fMonitor.subTask(this.fMonitor.getSubTaskMessage(source));
            ICompilationUnit primary = (ICompilationUnit)source.getPrimaryElement();
            ParseListElement element = (ParseListElement)this.fCompilationUnitParseElementMap.get(primary);
            CleanUpTarget target = element.getTarget();
            ICleanUp.CleanUpContext context = target instanceof MultiFixTarget ? new IMultiFix.MultiFixContext(source, ast, ((MultiFixTarget)target).getProblems()) : new ICleanUp.CleanUpContext(source, ast);
            ICleanUp[] rejectedCleanUps = this.calculateSolutions(context, element.getCleanUps());
            if (rejectedCleanUps.length > 0) {
                this.fUndoneElements.add(new ParseListElement(target, rejectedCleanUps));
                this.fMonitor.reset();
            } else {
                this.fMonitor.flush();
            }
        }

        public void acceptSource(ICompilationUnit source) {
            this.acceptAST(source, null);
        }

        public List getUndoneElements() {
            return this.fUndoneElements;
        }

        private ICleanUp[] calculateSolutions(ICleanUp.CleanUpContext context, ICleanUp[] cleanUps) {
            CleanUpChange solution;
            ArrayList result = new ArrayList();
            try {
                solution = CleanUpRefactoring.calculateChange(context, cleanUps, result);
            }
            catch (CoreException e) {
                throw new FixCalculationException(e);
            }
            if (solution != null) {
                this.integrateSolution(solution, context.getCompilationUnit());
            }
            return result.toArray(new ICleanUp[result.size()]);
        }

        private void integrateSolution(CleanUpChange solution, ICompilationUnit source) {
            ICompilationUnit primary = source.getPrimary();
            ArrayList<CleanUpChange> changes = (ArrayList<CleanUpChange>)this.fSolutions.get(primary);
            if (changes == null) {
                changes = new ArrayList<CleanUpChange>();
                this.fSolutions.put(primary, changes);
            }
            changes.add(solution);
        }
    }

    public static class CleanUpChange
    extends CompilationUnitChange {
        private UndoEdit fUndoEdit;

        public CleanUpChange(String name, ICompilationUnit cunit) {
            super(name, cunit);
        }

        protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
            this.fUndoEdit = edit;
            return super.createUndoChange(edit, stampToRestore);
        }

        public UndoEdit getUndoEdit() {
            return this.fUndoEdit;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (Display.getCurrent() == null) {
                Change[] result = new Change[1];
                CoreException[] exs = new CoreException[1];
                Display.getDefault().syncExec(new Runnable(this, result, pm, exs){
                    final /* synthetic */ CleanUpChange this$1;
                    private final /* synthetic */ Change[] val$result;
                    private final /* synthetic */ IProgressMonitor val$pm;
                    private final /* synthetic */ CoreException[] val$exs;
                    {
                        this.this$1 = cleanUpChange;
                        this.val$result = changeArray;
                        this.val$pm = iProgressMonitor;
                        this.val$exs = coreExceptionArray;
                    }

                    public void run() {
                        try {
                            this.val$result[0] = CleanUpChange.access$0(this.this$1, this.val$pm);
                        }
                        catch (CoreException e) {
                            this.val$exs[0] = e;
                        }
                    }
                });
                if (exs[0] != null) {
                    throw exs[0];
                }
                return result[0];
            }
            return super.perform(pm);
        }

        static /* synthetic */ Change access$0(CleanUpChange cleanUpChange, IProgressMonitor iProgressMonitor) throws CoreException {
            return super.perform(iProgressMonitor);
        }
    }

    private class CleanUpFixpointIterator {
        private List fParseList;
        private final Hashtable fSolutions;
        private final Hashtable fWorkingCopies;
        private final Map fCleanUpOptions;
        private final int fSize;
        private int fIndex;

        public CleanUpFixpointIterator(CleanUpTarget[] targets, ICleanUp[] cleanUps) {
            this.fSolutions = new Hashtable(targets.length);
            this.fWorkingCopies = new Hashtable();
            this.fParseList = new ArrayList(targets.length);
            int i = 0;
            while (i < targets.length) {
                this.fParseList.add(new ParseListElement(targets[i], cleanUps));
                ++i;
            }
            this.fCleanUpOptions = new Hashtable();
            i = 0;
            while (i < cleanUps.length) {
                ICleanUp cleanUp = cleanUps[i];
                Map currentCleanUpOption = cleanUp.getRequirements().getCompilerOptions();
                if (currentCleanUpOption != null) {
                    this.fCleanUpOptions.putAll(currentCleanUpOption);
                }
                ++i;
            }
            this.fSize = targets.length;
            this.fIndex = 1;
        }

        public boolean hasNext() {
            return !this.fParseList.isEmpty();
        }

        public void next(IProgressMonitor monitor) throws CoreException {
            ArrayList<ICompilationUnit> parseList = new ArrayList<ICompilationUnit>();
            ArrayList<ICompilationUnit> sourceList = new ArrayList<ICompilationUnit>();
            Iterator iter = this.fParseList.iterator();
            while (iter.hasNext()) {
                ParseListElement element = (ParseListElement)iter.next();
                ICompilationUnit compilationUnit = element.getTarget().getCompilationUnit();
                if (this.fSolutions.containsKey(compilationUnit)) {
                    if (this.fWorkingCopies.containsKey(compilationUnit)) {
                        compilationUnit = (ICompilationUnit)this.fWorkingCopies.get(compilationUnit);
                    } else {
                        compilationUnit = compilationUnit.getWorkingCopy(new WorkingCopyOwner(this){
                            final /* synthetic */ CleanUpFixpointIterator this$1;
                            {
                                this.this$1 = cleanUpFixpointIterator;
                            }
                        }, null);
                        this.fWorkingCopies.put(compilationUnit.getPrimary(), compilationUnit);
                    }
                    this.applyChange(compilationUnit, (List)this.fSolutions.get(compilationUnit.getPrimary()));
                }
                if (this.requiresAST(element.getCleanUps())) {
                    parseList.add(compilationUnit);
                    continue;
                }
                sourceList.add(compilationUnit);
            }
            CleanUpRefactoringProgressMonitor cuMonitor = new CleanUpRefactoringProgressMonitor(monitor, parseList.size() + sourceList.size(), this.fSize, this.fIndex);
            CleanUpASTRequestor requestor = new CleanUpASTRequestor(this.fParseList, this.fSolutions, cuMonitor);
            if (parseList.size() > 0) {
                ASTBatchParser parser = new ASTBatchParser(this){
                    final /* synthetic */ CleanUpFixpointIterator this$1;
                    {
                        this.this$1 = cleanUpFixpointIterator;
                    }

                    protected ASTParser createParser(IJavaProject project) {
                        ASTParser result = CleanUpRefactoring.createCleanUpASTParser();
                        result.setProject(project);
                        Map options = RefactoringASTParser.getCompilerOptions((IJavaElement)project);
                        options.putAll(CleanUpFixpointIterator.access$0(this.this$1));
                        result.setCompilerOptions(options);
                        return result;
                    }
                };
                try {
                    ICompilationUnit[] units = parseList.toArray(new ICompilationUnit[parseList.size()]);
                    parser.createASTs(units, new String[0], requestor, (IProgressMonitor)cuMonitor);
                }
                catch (FixCalculationException e) {
                    throw e.getException();
                }
            }
            Iterator iterator = sourceList.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                monitor.worked(1);
                requestor.acceptSource(cu);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            this.fParseList = requestor.getUndoneElements();
            this.fIndex = cuMonitor.getIndex();
        }

        public void dispose() {
            Iterator iterator = this.fWorkingCopies.values().iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                try {
                    cu.discardWorkingCopy();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            this.fWorkingCopies.clear();
        }

        private boolean requiresAST(ICleanUp[] cleanUps) {
            int i = 0;
            while (i < cleanUps.length) {
                if (cleanUps[i].getRequirements().requiresAST()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Change[] getResult() {
            Change[] result = new Change[this.fSolutions.size()];
            int i = 0;
            Iterator iterator = this.fSolutions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                List changes = (List)entry.getValue();
                ICompilationUnit unit = (ICompilationUnit)entry.getKey();
                int saveMode = CleanUpRefactoring.this.fLeaveFilesDirty ? 4 : 1;
                if (changes.size() == 1) {
                    CleanUpChange change = (CleanUpChange)((Object)changes.get(0));
                    change.setSaveMode(saveMode);
                    result[i] = change;
                } else {
                    MultiStateCompilationUnitChange mscuc = new MultiStateCompilationUnitChange(CleanUpRefactoring.getChangeName(unit), unit);
                    int j = 0;
                    while (j < changes.size()) {
                        mscuc.addChange(this.createGroupFreeChange((CleanUpChange)((Object)changes.get(j))));
                        ++j;
                    }
                    mscuc.setSaveMode(saveMode);
                    result[i] = mscuc;
                }
                ++i;
            }
            return result;
        }

        private TextChange createGroupFreeChange(CleanUpChange change) {
            CleanUpChange result = new CleanUpChange(change.getName(), change.getCompilationUnit());
            result.setEdit(change.getEdit());
            result.setSaveMode(change.getSaveMode());
            return result;
        }

        private void applyChange(ICompilationUnit compilationUnit, List changes) throws JavaModelException, CoreException {
            Document document = new Document(((CompilationUnitChange)((Object)changes.get(0))).getCurrentContent((IProgressMonitor)new NullProgressMonitor()));
            int i = 0;
            while (i < changes.size()) {
                CleanUpChange change = (CleanUpChange)((Object)changes.get(i));
                TextEdit edit = change.getEdit().copy();
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException e) {
                    JavaPlugin.log(e);
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                }
                ++i;
            }
            compilationUnit.getBuffer().setContents(document.get());
        }

        static /* synthetic */ Map access$0(CleanUpFixpointIterator cleanUpFixpointIterator) {
            return cleanUpFixpointIterator.fCleanUpOptions;
        }
    }

    private final class CleanUpRefactoringProgressMonitor
    extends SubProgressMonitor {
        private double fRealWork;
        private int fFlushCount = 0;
        private final int fSize;
        private final int fIndex;

        private CleanUpRefactoringProgressMonitor(IProgressMonitor monitor, int ticks, int size, int index) {
            super(monitor, ticks);
            this.fSize = size;
            this.fIndex = index;
        }

        public void internalWorked(double work) {
            this.fRealWork += work;
        }

        public void flush() {
            super.internalWorked(this.fRealWork);
            this.reset();
            ++this.fFlushCount;
        }

        public void reset() {
            this.fRealWork = 0.0;
        }

        public void done() {
        }

        public int getIndex() {
            return this.fIndex + this.fFlushCount;
        }

        public String getSubTaskMessage(ICompilationUnit source) {
            String typeName = BasicElementLabels.getFileName((ITypeRoot)source);
            return Messages.format(FixMessages.CleanUpRefactoring_ProcessingCompilationUnit_message, new Object[]{new Integer(this.getIndex()), new Integer(this.fSize), typeName});
        }
    }

    public static class CleanUpTarget {
        private final ICompilationUnit fCompilationUnit;

        public CleanUpTarget(ICompilationUnit unit) {
            this.fCompilationUnit = unit;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }
    }

    private static class FixCalculationException
    extends RuntimeException {
        private static final long serialVersionUID = 3807273310144726165L;
        private final CoreException fException;

        public FixCalculationException(CoreException exception) {
            this.fException = exception;
        }

        public CoreException getException() {
            return this.fException;
        }
    }

    public static class MultiFixTarget
    extends CleanUpTarget {
        private final IProblemLocation[] fProblems;

        public MultiFixTarget(ICompilationUnit unit, IProblemLocation[] problems) {
            super(unit);
            this.fProblems = problems;
        }

        public IProblemLocation[] getProblems() {
            return this.fProblems;
        }
    }

    private static class ParseListElement {
        private final CleanUpTarget fTarget;
        private final ICleanUp[] fCleanUpsArray;

        public ParseListElement(CleanUpTarget cleanUpTarget, ICleanUp[] cleanUps) {
            this.fTarget = cleanUpTarget;
            this.fCleanUpsArray = cleanUps;
        }

        public CleanUpTarget getTarget() {
            return this.fTarget;
        }

        public ICleanUp[] getCleanUps() {
            return this.fCleanUpsArray;
        }
    }
}

