/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.dialogs.SortMembersMessageDialog;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class MultiSortMembersAction
extends CleanUpAction {
    public MultiSortMembersAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.sort_members_action");
    }

    public MultiSortMembersAction(JavaEditor editor) {
        super(editor);
        this.setText(ActionMessages.SortMembersAction_label);
        this.setDescription(ActionMessages.SortMembersAction_description);
        this.setToolTipText(ActionMessages.SortMembersAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.sort_members_action");
    }

    protected ICleanUp[] createCleanUps(ICompilationUnit[] units) {
        try {
            if (!this.hasMembersToSort(units)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.MultiSortMembersAction_noElementsToSortDialog_title, (String)ActionMessages.MultiSortMembersAction_noElementsToSortDialog_message);
                return null;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
        Map settings = this.getSettings();
        if (settings == null) {
            return null;
        }
        return new ICleanUp[]{new SortMembersCleanUp(settings)};
    }

    protected Map getSettings() {
        SortMembersMessageDialog dialog = new SortMembersMessageDialog(this.getShell());
        if (dialog.open() != 0) {
            return null;
        }
        Hashtable<String, String> settings = new Hashtable<String, String>();
        settings.put("cleanup.sort_members", "true");
        settings.put("cleanup.sort_members_all", !dialog.isNotSortingFieldsEnabled() ? "true" : "false");
        return settings;
    }

    protected String getActionName() {
        return ActionMessages.SortMembersAction_dialog_title;
    }

    private boolean hasMembersToSort(ICompilationUnit[] units) throws JavaModelException {
        int i = 0;
        while (i < units.length) {
            if (this.hasMembersToSort((IJavaElement[])units[i].getTypes())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasMembersToSort(IJavaElement[] members) throws JavaModelException {
        if (members.length > 1) {
            return true;
        }
        if (members.length == 0) {
            return false;
        }
        IJavaElement elem = members[0];
        if (!(elem instanceof IParent)) {
            return false;
        }
        return this.hasMembersToSort(((IParent)elem).getChildren());
    }
}

