/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    static /* synthetic */ Class class$0;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IJavaElement[] elements;
        IRegion wordRegion;
        IAction openAction;
        block13: {
            ITypeRoot input;
            block12: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ITextEditor textEditor = (ITextEditor)this.getAdapter(clazz);
                if (region == null || !(textEditor instanceof JavaEditor)) {
                    return null;
                }
                openAction = textEditor.getAction("OpenEditor");
                if (!(openAction instanceof SelectionDispatchAction)) {
                    return null;
                }
                int offset = region.getOffset();
                input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, false);
                if (input == null) {
                    return null;
                }
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                wordRegion = JavaWordFinder.findWord(document, offset);
                if (wordRegion != null && wordRegion.getLength() != 0) break block12;
                return null;
            }
            elements = null;
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            elements = this.selectOpenableElements(elements);
            if (elements.length != 0) break block13;
            return null;
        }
        try {
            IHyperlink[] result = new IHyperlink[elements.length];
            int i = 0;
            while (i < elements.length) {
                result[i] = new JavaElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, elements[i], elements.length > 1);
                ++i;
            }
            return result;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private IJavaElement[] selectOpenableElements(IJavaElement[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }
}

