/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.FieldProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocInlineTagCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocLinkTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CompletionProposalCollector
extends CompletionRequestor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ResultCollector"));
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    private final CompletionProposalLabelProvider fLabelProvider = new CompletionProposalLabelProvider();
    private final ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private final List fJavaProposals = new ArrayList();
    private final List fKeywords = new ArrayList();
    private final Set fSuggestedMethodNames = new HashSet();
    private final ICompilationUnit fCompilationUnit;
    private final IJavaProject fJavaProject;
    private int fUserReplacementLength;
    private CompletionContext fContext;
    private IProblem fLastProblem;
    private long fStartTime;
    private long fUITime;
    private JavaContentAssistInvocationContext fInvocationContext;

    public CompletionProposalCollector(ICompilationUnit cu) {
        this(cu.getJavaProject(), cu, false);
    }

    public CompletionProposalCollector(IJavaProject project) {
        this(project, null, false);
    }

    private CompletionProposalCollector(IJavaProject project, ICompilationUnit cu, boolean ignoreAll) {
        super(ignoreAll);
        this.fJavaProject = project;
        this.fCompilationUnit = cu;
        this.fUserReplacementLength = -1;
        if (!ignoreAll) {
            this.setRequireExtendedContext(true);
        }
    }

    public CompletionProposalCollector(ICompilationUnit cu, boolean ignoreAll) {
        this(cu.getJavaProject(), cu, ignoreAll);
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        super.setIgnored(completionProposalKind, ignore);
        if (completionProposalKind == 7 && !ignore) {
            this.setRequireExtendedContext(true);
        }
    }

    public void setInvocationContext(JavaContentAssistInvocationContext context) {
        Assert.isNotNull((Object)context);
        this.fInvocationContext = context;
        context.setCollector(this);
    }

    protected final JavaContentAssistInvocationContext getInvocationContext() {
        if (this.fInvocationContext == null) {
            this.setInvocationContext(new JavaContentAssistInvocationContext(this.getCompilationUnit()));
        }
        return this.fInvocationContext;
    }

    public void accept(CompletionProposal proposal) {
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            if (this.isFiltered(proposal)) {
                return;
            }
            if (proposal.getKind() == 11) {
                this.acceptPotentialMethodDeclaration(proposal);
            } else {
                IJavaCompletionProposal javaProposal = this.createJavaCompletionProposal(proposal);
                if (javaProposal != null) {
                    this.fJavaProposals.add(javaProposal);
                    if (proposal.getKind() == 3) {
                        this.fKeywords.add(javaProposal);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Exception when processing proposal for: " + String.valueOf(proposal.getCompletion()), (Throwable)e));
        }
        if (DEBUG) {
            this.fUITime += System.currentTimeMillis() - start;
        }
    }

    public void acceptContext(CompletionContext context) {
        this.fContext = context;
        this.fLabelProvider.setContext(context);
    }

    public void beginReporting() {
        if (DEBUG) {
            this.fStartTime = System.currentTimeMillis();
            this.fUITime = 0L;
        }
        this.fLastProblem = null;
        this.fJavaProposals.clear();
        this.fKeywords.clear();
        this.fSuggestedMethodNames.clear();
    }

    public void completionFailure(IProblem problem) {
        this.fLastProblem = problem;
    }

    public void endReporting() {
        if (DEBUG) {
            long total = System.currentTimeMillis() - this.fStartTime;
            System.err.println("Core Collector (core):\t" + (total - this.fUITime));
            System.err.println("Core Collector (ui):\t" + this.fUITime);
        }
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }

    public final IJavaCompletionProposal[] getJavaCompletionProposals() {
        return this.fJavaProposals.toArray(new IJavaCompletionProposal[this.fJavaProposals.size()]);
    }

    public final IJavaCompletionProposal[] getKeywordCompletionProposals() {
        return this.fKeywords.toArray(new JavaCompletionProposal[this.fKeywords.size()]);
    }

    public final void setReplacementLength(int length) {
        Assert.isLegal((length >= 0 ? 1 : 0) != 0);
        this.fUserReplacementLength = length;
    }

    protected int computeRelevance(CompletionProposal proposal) {
        int baseRelevance = proposal.getRelevance() * 16;
        switch (proposal.getKind()) {
            case 8: {
                return baseRelevance + 0;
            }
            case 4: {
                return baseRelevance + 1;
            }
            case 3: {
                return baseRelevance + 2;
            }
            case 1: 
            case 9: {
                return baseRelevance + 3;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return baseRelevance + 4;
            }
            case 11: {
                return baseRelevance + 4;
            }
            case 2: {
                return baseRelevance + 5;
            }
            case 5: 
            case 10: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 3: {
                return this.createKeywordProposal(proposal);
            }
            case 8: {
                return this.createPackageProposal(proposal);
            }
            case 9: {
                return this.createTypeProposal(proposal);
            }
            case 16: {
                return this.createJavadocLinkTypeProposal(proposal);
            }
            case 2: 
            case 14: 
            case 17: {
                return this.createFieldProposal(proposal);
            }
            case 25: {
                return this.createFieldWithCastedReceiverProposal(proposal);
            }
            case 6: 
            case 12: 
            case 15: 
            case 24: {
                return this.createMethodReferenceProposal(proposal);
            }
            case 7: {
                return this.createMethodDeclarationProposal(proposal);
            }
            case 1: {
                return this.createAnonymousTypeProposal(proposal);
            }
            case 4: {
                return this.createLabelProposal(proposal);
            }
            case 5: 
            case 10: {
                return this.createLocalVariableProposal(proposal);
            }
            case 13: {
                return this.createAnnotationAttributeReferenceProposal(proposal);
            }
            case 18: 
            case 19: {
                return this.createJavadocSimpleProposal(proposal);
            }
            case 20: {
                return this.createJavadocInlineTagProposal(proposal);
            }
        }
        return null;
    }

    protected final IContextInformation createMethodContextInformation(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 6 ? 1 : 0) != 0);
        return new ProposalContextInformation(methodProposal);
    }

    protected final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    protected final CompletionContext getContext() {
        return this.fContext;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    protected final CompletionProposalLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final int getLength(CompletionProposal proposal) {
        int length;
        int start = proposal.getReplaceStart();
        int end = proposal.getReplaceEnd();
        if (this.fUserReplacementLength == -1) {
            length = end - start;
        } else {
            length = this.fUserReplacementLength;
            int behindCompletion = proposal.getCompletionLocation() + 1;
            if (start < behindCompletion) {
                length += behindCompletion - start;
            }
        }
        return length;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        if (this.isIgnored(proposal.getKind())) {
            return true;
        }
        char[] declaringType = this.getDeclaringType(proposal);
        return declaringType != null && TypeFilter.isFiltered(declaringType);
    }

    protected final char[] getDeclaringType(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: {
                char[] declaration = proposal.getDeclarationSignature();
                if (declaration == null) {
                    return "java.lang.Object".toCharArray();
                }
                return Signature.toCharArray((char[])declaration);
            }
            case 8: {
                return proposal.getDeclarationSignature();
            }
            case 9: 
            case 16: {
                return Signature.toCharArray((char[])proposal.getSignature());
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 18: 
            case 19: 
            case 20: {
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        try {
            IJavaElement enclosingElement = null;
            if (this.getContext().isExtended()) {
                enclosingElement = this.getContext().getEnclosingElement();
            } else if (this.fCompilationUnit != null) {
                enclosingElement = this.fCompilationUnit.getElementAt(proposal.getCompletionLocation() + 1);
            }
            if (enclosingElement == null) {
                return;
            }
            IType type = (IType)enclosingElement.getAncestor(7);
            if (type != null) {
                String prefix = String.valueOf(proposal.getName());
                int completionStart = proposal.getReplaceStart();
                int completionEnd = proposal.getReplaceEnd();
                int relevance = this.computeRelevance(proposal);
                GetterSetterCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance + 1, this.fSuggestedMethodNames, this.fJavaProposals);
                MethodDeclarationCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance, this.fSuggestedMethodNames, this.fJavaProposals);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private IJavaCompletionProposal createAnnotationAttributeReferenceProposal(CompletionProposal proposal) {
        StyledString displayString = this.fLabelProvider.createLabelWithTypeAndDeclaration(proposal);
        ImageDescriptor descriptor = this.fLabelProvider.createMethodImageDescriptor(proposal);
        String completion = String.valueOf(proposal.getCompletion());
        return new JavaCompletionProposal(completion, proposal.getReplaceStart(), this.getLength(proposal), this.getImage(descriptor), displayString, this.computeRelevance(proposal));
    }

    private IJavaCompletionProposal createAnonymousTypeProposal(CompletionProposal proposal) {
        IJavaElement element;
        block5: {
            if (this.fCompilationUnit == null || this.fJavaProject == null) {
                return null;
            }
            char[] declarationKey = proposal.getDeclarationKey();
            if (declarationKey == null) {
                return null;
            }
            try {
                element = this.fJavaProject.findElement(new String(declarationKey), null);
                if (element instanceof IType) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        IType type = (IType)element;
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        int relevance = this.computeRelevance(proposal);
        StyledString label = this.fLabelProvider.createAnonymousTypeLabel(proposal);
        AnonymousTypeCompletionProposal javaProposal = new AnonymousTypeCompletionProposal(this.fJavaProject, this.fCompilationUnit, start, length, completion, label, String.valueOf(proposal.getDeclarationSignature()), type, relevance);
        javaProposal.setProposalInfo(new AnonymousTypeProposalInfo(this.fJavaProject, proposal));
        return javaProposal;
    }

    private IJavaCompletionProposal createFieldProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createStyledLabel(proposal);
        Image image = this.getImage(this.fLabelProvider.createFieldImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        JavaCompletionProposal javaProposal = new JavaCompletionProposal(completion, start, length, image, label, relevance, this.getContext().isInJavadoc(), this.getInvocationContext());
        if (this.fJavaProject != null) {
            javaProposal.setProposalInfo(new FieldProposalInfo(this.fJavaProject, proposal));
        }
        javaProposal.setTriggerCharacters(VAR_TRIGGER);
        return javaProposal;
    }

    private IJavaCompletionProposal createFieldWithCastedReceiverProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        completion = CodeFormatterUtil.format(1, completion, 0, "\n", this.fJavaProject);
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createStyledLabel(proposal);
        Image image = this.getImage(this.fLabelProvider.createFieldImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        JavaFieldWithCastedReceiverCompletionProposal javaProposal = new JavaFieldWithCastedReceiverCompletionProposal(completion, start, length, image, label, relevance, this.getContext().isInJavadoc(), this.getInvocationContext(), proposal);
        if (this.fJavaProject != null) {
            javaProposal.setProposalInfo(new FieldProposalInfo(this.fJavaProject, proposal));
        }
        javaProposal.setTriggerCharacters(VAR_TRIGGER);
        return javaProposal;
    }

    private IJavaCompletionProposal createJavadocSimpleProposal(CompletionProposal javadocProposal) {
        LazyJavaCompletionProposal proposal = new LazyJavaCompletionProposal(javadocProposal, this.getInvocationContext());
        return proposal;
    }

    private IJavaCompletionProposal createJavadocInlineTagProposal(CompletionProposal javadocProposal) {
        JavadocInlineTagCompletionProposal proposal = new JavadocInlineTagCompletionProposal(javadocProposal, this.getInvocationContext());
        this.adaptLength(proposal, javadocProposal);
        return proposal;
    }

    private IJavaCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createSimpleLabel(proposal);
        int relevance = this.computeRelevance(proposal);
        return new JavaCompletionProposal(completion, start, length, null, label, relevance);
    }

    private IJavaCompletionProposal createLabelProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createSimpleLabel(proposal);
        int relevance = this.computeRelevance(proposal);
        return new JavaCompletionProposal(completion, start, length, null, label, relevance);
    }

    private IJavaCompletionProposal createLocalVariableProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        Image image = this.getImage(this.fLabelProvider.createLocalImageDescriptor(proposal));
        StyledString label = this.fLabelProvider.createSimpleLabelWithType(proposal);
        int relevance = this.computeRelevance(proposal);
        JavaCompletionProposal javaProposal = new JavaCompletionProposal(completion, start, length, image, label, relevance);
        javaProposal.setTriggerCharacters(VAR_TRIGGER);
        return javaProposal;
    }

    private IJavaCompletionProposal createMethodDeclarationProposal(CompletionProposal proposal) {
        if (this.fCompilationUnit == null || this.fJavaProject == null) {
            return null;
        }
        String name = String.valueOf(proposal.getName());
        String[] paramTypes = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
        int index = 0;
        while (index < paramTypes.length) {
            paramTypes[index] = Signature.toString((String)paramTypes[index]);
            ++index;
        }
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createOverrideMethodProposalLabel(proposal);
        OverrideCompletionProposal javaProposal = new OverrideCompletionProposal(this.fJavaProject, this.fCompilationUnit, name, paramTypes, start, length, label, String.valueOf(proposal.getCompletion()));
        javaProposal.setImage(this.getImage(this.fLabelProvider.createMethodImageDescriptor(proposal)));
        javaProposal.setProposalInfo(new MethodProposalInfo(this.fJavaProject, proposal));
        javaProposal.setRelevance(this.computeRelevance(proposal));
        this.fSuggestedMethodNames.add(new String(name));
        return javaProposal;
    }

    private IJavaCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        JavaMethodCompletionProposal proposal = new JavaMethodCompletionProposal(methodProposal, this.getInvocationContext());
        this.adaptLength(proposal, methodProposal);
        return proposal;
    }

    private void adaptLength(LazyJavaCompletionProposal proposal, CompletionProposal coreProposal) {
        if (this.fUserReplacementLength != -1) {
            proposal.setReplacementLength(this.getLength(coreProposal));
        }
    }

    private IJavaCompletionProposal createPackageProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = this.fLabelProvider.createSimpleLabel(proposal);
        Image image = this.getImage(this.fLabelProvider.createPackageImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        return new JavaCompletionProposal(completion, start, length, image, label, relevance);
    }

    private IJavaCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        LazyJavaTypeCompletionProposal proposal = new LazyJavaTypeCompletionProposal(typeProposal, this.getInvocationContext());
        this.adaptLength(proposal, typeProposal);
        return proposal;
    }

    private IJavaCompletionProposal createJavadocLinkTypeProposal(CompletionProposal typeProposal) {
        JavadocLinkTypeCompletionProposal proposal = new JavadocLinkTypeCompletionProposal(typeProposal, this.getInvocationContext());
        this.adaptLength(proposal, typeProposal);
        return proposal;
    }
}

