/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.browser;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.pdb.PDBPlugin;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.AnalysisManager;
import org.eclipse.imp.pdb.analysis.IAnalysisDescriptor;
import org.eclipse.imp.pdb.browser.SelectContextMenuAction;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.FactKey;
import org.eclipse.imp.pdb.facts.db.IFactContext;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.db.context.ProjectContext;
import org.eclipse.imp.pdb.facts.impl.reference.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TriggerAnalysisMenuAction
extends Action
implements IMenuCreator {
    private Menu fMenu;

    public TriggerAnalysisMenuAction() {
        this.setMenuCreator(this);
        this.setText("Analyze");
        this.setToolTipText("Trigger an analysis");
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        Set analyses = AnalysisManager.getInstance().getAnalysisDescriptorSet();
        for (IAnalysisDescriptor analysis : analyses) {
            MenuItem menuItem = new MenuItem(this.fMenu, 8);
            menuItem.setText(analysis.getName());
            menuItem.setData((Object)analysis);
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IAnalysisDescriptor a = (IAnalysisDescriptor)e.widget.getData();
                    TriggerAnalysisMenuAction.this.triggerAnalysis(a);
                }
            });
        }
        return this.fMenu;
    }

    protected void triggerAnalysis(IAnalysisDescriptor a) {
        for (Type type : a.getOutputDescriptors()) {
            if (type != null) {
                IProject project = SelectContextMenuAction.getInstance().getSelectedProject();
                try {
                    ISourceProject srcProject = ModelFactory.open((IProject)project);
                    FactKey key = new FactKey(type, (IFactContext)new ProjectContext(srcProject));
                    try {
                        FactBase.getInstance().getFact((IFactKey)key);
                    }
                    catch (AnalysisException e) {
                        FactBase.getInstance().defineFact((IFactKey)new FactKey(TypeFactory.getInstance().stringType(), key.getContext()), (IValue)ValueFactory.getInstance().string(e.getMessage()));
                        PDBPlugin.getInstance().logException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (ModelFactory.ModelException e) {
                    PDBPlugin.getInstance().logException(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            PDBPlugin.getInstance().writeErrorMsg("Analysis does not provide output descriptors: " + a.getName());
        }
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

